/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.gui.TransparentTextField;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.SearchPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.sorting.ISorting;
import com.chaosthedude.naturescompass.sorting.NameSorting;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import com.chaosthedude.naturescompass.utils.CompassState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class NaturesCompassScreen
extends class_437 {
    public class_1937 world;
    private class_1657 player;
    private List<class_1959> allowedBiomes;
    private List<class_1959> biomesMatchingSearch;
    private class_1799 stack;
    private NaturesCompassItem natureCompass;
    private class_4185 startSearchButton;
    private class_4185 teleportButton;
    private class_4185 cancelButton;
    private class_4185 sortByButton;
    private TransparentTextField searchTextField;
    private BiomeSearchList selectionList;
    private ISorting sortingCategory;

    public NaturesCompassScreen(class_1937 world, class_1657 player, class_1799 stack, NaturesCompassItem natureCompass, List<class_2960> allowedBiomes) {
        super((class_2561)class_2561.method_43471((String)"string.naturescompass.selectBiome"));
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.natureCompass = natureCompass;
        this.allowedBiomes = new ArrayList<class_1959>();
        this.loadAllowedBiomes(allowedBiomes);
        this.sortingCategory = new NameSorting();
        this.biomesMatchingSearch = new ArrayList<class_1959>(this.allowedBiomes);
    }

    public boolean method_25401(double scroll1, double scroll2, double scroll3) {
        return this.selectionList.method_25401(scroll1, scroll2, scroll3);
    }

    protected void method_25426() {
        this.method_37067();
        this.setupButtons();
        this.setupTextFields();
        if (this.selectionList == null) {
            this.selectionList = new BiomeSearchList(this, this.field_22787, this.field_22789 + 110, this.field_22790, 40, this.field_22790, 45);
        }
        this.method_37063((class_364)this.selectionList);
    }

    public void method_25393() {
        this.searchTextField.method_1865();
        boolean bl = this.teleportButton.field_22763 = this.natureCompass.getState(this.stack) == CompassState.FOUND;
        if (this.allowedBiomes.size() != NaturesCompass.allowedBiomes.size()) {
            this.teleportButton.field_22764 = NaturesCompass.canTeleport;
            this.method_37066((class_364)this.selectionList);
            this.loadAllowedBiomes(NaturesCompass.allowedBiomes);
            this.biomesMatchingSearch = new ArrayList<class_1959>(this.allowedBiomes);
            this.selectionList = new BiomeSearchList(this, this.field_22787, this.field_22789 + 110, this.field_22790, 40, this.field_22790, 45);
            this.method_37063((class_364)this.selectionList);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(context);
        context.method_25300(this.field_22793, class_1074.method_4662((String)"string.naturescompass.selectBiome", (Object[])new Object[0]), 65, 15, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, partialTicks);
    }

    public boolean method_25404(int par1, int par2, int par3) {
        boolean ret = super.method_25404(par1, par2, par3);
        if (this.searchTextField.method_25370()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        boolean ret = super.method_25400(typedChar, keyCode);
        if (this.searchTextField.method_25370()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void selectBiome(BiomeSearchEntry entry) {
        boolean enable;
        this.startSearchButton.field_22763 = enable = entry != null;
    }

    public void searchForBiome(class_1959 biome) {
        ClientPlayNetworking.send((class_2960)SearchPacket.ID, (class_2540)new SearchPacket(BiomeUtils.getIdentifierForBiome(this.world, biome), this.player.method_24515()));
        this.field_22787.method_1507(null);
    }

    public void teleport() {
        ClientPlayNetworking.send((class_2960)TeleportPacket.ID, (class_2540)new TeleportPacket());
        this.field_22787.method_1507(null);
    }

    public ISorting getSortingCategory() {
        return this.sortingCategory;
    }

    public void processSearchTerm() {
        this.biomesMatchingSearch = new ArrayList<class_1959>();
        String searchTerm = this.searchTextField.method_1882().toLowerCase();
        for (class_1959 biome : this.allowedBiomes) {
            if (searchTerm.startsWith("$")) {
                if (!BiomeUtils.getBiomeTags(this.world, biome).toLowerCase().contains(searchTerm.substring(1))) continue;
                this.biomesMatchingSearch.add(biome);
                continue;
            }
            if (searchTerm.startsWith("@")) {
                if (!BiomeUtils.getBiomeSource(this.world, biome).toLowerCase().contains(searchTerm.substring(1))) continue;
                this.biomesMatchingSearch.add(biome);
                continue;
            }
            if (!BiomeUtils.getBiomeNameForDisplay(this.world, biome).toLowerCase().contains(searchTerm)) continue;
            this.biomesMatchingSearch.add(biome);
        }
        this.selectionList.refreshList();
    }

    public List<class_1959> sortBiomes() {
        List<class_1959> biomes = this.biomesMatchingSearch;
        Collections.sort(biomes, new NameSorting());
        Collections.sort(biomes, this.sortingCategory);
        return biomes;
    }

    private void setupButtons() {
        this.cancelButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, this.field_22790 - 30, 110, 20, (class_2561)class_2561.method_43471((String)"gui.cancel"), onPress -> this.field_22787.method_1507(null)));
        this.sortByButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, 65, 110, 20, (class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName())), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.method_25355((class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"string.naturescompass.sortBy", (Object[])new Object[0]) + ": " + this.sortingCategory.getLocalizedName())));
            this.selectionList.refreshList();
        }));
        this.startSearchButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, 40, 110, 20, (class_2561)class_2561.method_43471((String)"string.naturescompass.startSearch"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((BiomeSearchEntry)this.selectionList.method_25334()).searchForBiome();
            }
        }));
        this.teleportButton = (class_4185)this.method_37063((class_364)new TransparentButton(this.field_22789 - 120, 10, 110, 20, (class_2561)class_2561.method_43471((String)"string.naturescompass.teleport"), onPress -> this.teleport()));
        this.startSearchButton.field_22763 = false;
        this.teleportButton.field_22764 = NaturesCompass.canTeleport;
    }

    private void setupTextFields() {
        this.searchTextField = new TransparentTextField(this.field_22793, 130, 10, 140, 20, (class_2561)class_2561.method_43471((String)"string.naturescompass.search"));
        this.method_37063((class_364)this.searchTextField);
    }

    private void loadAllowedBiomes(List<class_2960> allowedBiomeIDs) {
        this.allowedBiomes = new ArrayList<class_1959>();
        for (class_2960 biomeID : allowedBiomeIDs) {
            Optional<class_1959> optionalBiome = BiomeUtils.getBiomeForIdentifier(this.world, biomeID);
            if (!optionalBiome.isPresent()) continue;
            this.allowedBiomes.add(optionalBiome.get());
        }
    }
}

