/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network;

import immersive_melodies.cobalt.network.Message;
import immersive_melodies.resources.Melody;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public abstract class FragmentedMessage
extends Message {
    private final String name;
    private final byte[] fragment;
    private final int length;
    private static final Map<String, Queue<byte[]>> buffer = new ConcurrentHashMap<String, Queue<byte[]>>();

    public FragmentedMessage(String name, byte[] fragment, int length) {
        this.name = name;
        this.fragment = fragment;
        this.length = length;
    }

    public FragmentedMessage(class_2540 b) {
        this.name = b.method_19772();
        this.fragment = b.method_10795();
        this.length = b.readInt();
    }

    @Override
    public void encode(class_2540 b) {
        b.method_10814(this.name);
        b.method_10813(this.fragment);
        b.writeInt(this.length);
    }

    @Override
    public void receive(class_1657 e) {
        Queue byteBuffer = buffer.computeIfAbsent((e == null ? "local" : e.method_5845()) + ":" + this.name, k -> new ConcurrentLinkedQueue());
        byteBuffer.add(this.fragment);
        if (byteBuffer.stream().mapToInt(f -> ((byte[])f).length).sum() == this.length) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            for (byte[] b : byteBuffer) {
                buffer.writeBytes(b);
            }
            this.finish(e, this.name, new Melody(buffer));
        }
    }

    protected abstract void finish(class_1657 var1, String var2, Melody var3);
}

