/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.annotation.ConditionalMixin;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class BetterTrimsMixinPlugin
implements IMixinConfigPlugin {
    public static boolean testClass(String className) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)className).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            for (AnnotationNode node : annotationNodes) {
                if (!node.desc.equals(Type.getDescriptor(ConditionalMixin.class))) continue;
                String modid = (String)Annotations.getValue((AnnotationNode)node, (String)"modid");
                boolean applyIfPresent = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"applyIfPresent", (Object)Boolean.TRUE);
                if (BetterTrimsMixinPlugin.isModLoaded(modid)) {
                    BetterTrims.LOGGER.debug("BetterTrimsMixinPlugin: " + className + " is" + (applyIfPresent ? " " : " not ") + "being applied because " + modid + " is loaded");
                    return applyIfPresent;
                }
                BetterTrims.LOGGER.debug("BetterTrimsMixinPlugin: " + className + " is" + (!applyIfPresent ? " " : " not ") + "being applied because " + modid + " is not loaded");
                return !applyIfPresent;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            BetterTrims.LOGGER.error("BetterTrimsMixinPlugin: Failed to load class " + className + ", it will not be applied", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetName, String className) {
        return BetterTrimsMixinPlugin.testClass(className);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

