/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.config;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.config.Config;
import com.bawnorton.bettertrims.config.annotation.BooleanOption;
import com.bawnorton.bettertrims.config.annotation.FloatOption;
import com.bawnorton.bettertrims.config.annotation.IntOption;
import com.bawnorton.bettertrims.config.annotation.NestedOption;
import com.bawnorton.bettertrims.config.option.ConfigOptionReference;
import com.bawnorton.bettertrims.networking.Networking;
import com.bawnorton.bettertrims.reflection.Reflection;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public abstract class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static final Path localConfigPath = FabricLoader.getInstance().getConfigDir().resolve("bettertrims.json");
    private static final Path serverConfigPath = FabricLoader.getInstance().getConfigDir().resolve("bettertrims-server.json");
    private static boolean loaded = false;

    public static Config getConfig() {
        if (!loaded) {
            BetterTrims.LOGGER.warn("Attempted to access configs before they were loaded, loading configs now");
            ConfigManager.loadConfigs();
        }
        if (Networking.isDedicated()) {
            return Config.getServerInstance();
        }
        return Config.getLocalInstance();
    }

    public static void loadConfigs() {
        ConfigManager.loadLocalConfig();
        ConfigManager.loadServerConfig();
        loaded = true;
    }

    private static void loadLocalConfig() {
        Config config = ConfigManager.loadLocal();
        ConfigManager.validateFields(config);
        Config.updateLocal(config);
        ConfigManager.saveLocalConfig();
        BetterTrims.LOGGER.info("Loaded local config");
    }

    private static void loadServerConfig() {
        Config config = ConfigManager.loadServer();
        ConfigManager.validateFields(config);
        Config.updateServer(config);
        ConfigManager.saveServerConfig();
        BetterTrims.LOGGER.info("Loaded server config");
    }

    private static void validateFields(Object instance) {
        ConfigManager.validateFloatFields(instance);
        ConfigManager.validateIntFields(instance);
        ConfigManager.validateBooleanFields(instance);
        ConfigManager.validateNestedFields(instance);
    }

    private static void validateFloatFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, FloatOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, Float.valueOf(annotation.value()));
            if (reference.floatValue().floatValue() < annotation.min()) {
                reference.floatValue(Float.valueOf(annotation.min()));
            }
            if (reference.floatValue().floatValue() > annotation.max()) {
                reference.floatValue(Float.valueOf(annotation.max()));
            }
        });
    }

    private static void validateIntFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, IntOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, annotation.value());
            if (reference.intValue() < annotation.min()) {
                reference.intValue(annotation.min());
            }
            if (reference.intValue() > annotation.max()) {
                reference.intValue(annotation.max());
            }
        });
    }

    private static void validateBooleanFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, BooleanOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, annotation.value());
        });
    }

    private static void validateNestedFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, NestedOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, Reflection.newInstance(field.getType()));
            Object nestedOption = Reflection.accessField(field, instance, Object.class);
            ConfigManager.validateFields(nestedOption);
        });
    }

    private static void setIfNull(ConfigOptionReference reference, Object value) {
        if (reference.isValueNull()) {
            reference.setConfigValue(value);
        }
    }

    public static String serializeConfig() {
        return GSON.toJson((Object)Config.getServerInstance());
    }

    public static void deserializeConfig(String serialized) {
        Config.updateServer((Config)GSON.fromJson(serialized, Config.class));
        ConfigManager.saveServerConfig();
    }

    private static Config loadLocal() {
        return ConfigManager.load(Config.getLocalInstance(), localConfigPath);
    }

    private static Config loadServer() {
        return ConfigManager.load(Config.getServerInstance(), serverConfigPath);
    }

    private static Config load(Config defaultConfig, Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                return defaultConfig;
            }
            try {
                return (Config)GSON.fromJson((Reader)Files.newBufferedReader(path), Config.class);
            }
            catch (JsonSyntaxException e) {
                BetterTrims.LOGGER.error("Failed to parse defaultConfig file, using default config");
            }
        }
        catch (IOException e) {
            BetterTrims.LOGGER.error("Failed to load config", (Throwable)e);
        }
        return defaultConfig;
    }

    public static boolean loaded() {
        return loaded;
    }

    public static void saveLocalConfig() {
        ConfigManager.save(Config.getLocalInstance(), localConfigPath);
    }

    public static void saveServerConfig() {
        ConfigManager.save(Config.getServerInstance(), serverConfigPath);
    }

    private static void save(Config config, Path path) {
        try {
            Files.write(path, GSON.toJson((Object)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BetterTrims.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }
}

