/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin;

import com.bawnorton.bettertrims.config.ConfigManager;
import com.bawnorton.bettertrims.effect.ArmorTrimEffects;
import com.bawnorton.bettertrims.extend.AreaEffectCloudEntityExtender;
import com.bawnorton.bettertrims.extend.LivingEntityExtender;
import com.bawnorton.bettertrims.mixin.EntityMixin;
import com.bawnorton.bettertrims.mixin.accessor.AreaEffectCloudEntityAccessor;
import com.bawnorton.bettertrims.util.EquippedStack;
import com.bawnorton.bettertrims.util.NumberWrapper;
import com.bawnorton.bettertrims.util.RandomHelper;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_5151;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityExtender {
    @Shadow
    @Final
    private Map<class_1291, class_1293> field_6280;
    @Unique
    private int stopwatch = 0;

    @Shadow
    public abstract float method_6067();

    @Shadow
    public abstract void method_6073(float var1);

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Override
    @Unique
    public Iterable<EquippedStack> betterTrims$getTrimmables() {
        ArrayList<EquippedStack> equipped = new ArrayList<EquippedStack>();
        for (class_1304 slot : class_1304.values()) {
            class_1799 equippedStack = this.method_6118(slot);
            if (!(equippedStack.method_7909() instanceof class_5151)) continue;
            equipped.add(EquippedStack.of(equippedStack, slot));
        }
        return equipped;
    }

    @Override
    protected boolean checkIfNetheriteTrimmed(boolean original) {
        NumberWrapper netheriteCount = NumberWrapper.zero();
        ArmorTrimEffects.NETHERITE.apply(this.betterTrims$getTrimmables(), () -> netheriteCount.increment(ConfigManager.getConfig().netheriteFireResistance));
        return original || netheriteCount.getFloat() >= 0.99f;
    }

    @Override
    protected float reduceNetheriteTrimDamage(float original) {
        NumberWrapper netheriteCount = NumberWrapper.zero();
        ArmorTrimEffects.NETHERITE.apply(this.betterTrims$getTrimmables(), () -> netheriteCount.increment(ConfigManager.getConfig().netheriteFireResistance));
        return original * (1.0f - netheriteCount.getFloat());
    }

    @Override
    protected float applyTrimStepHeightIncrease(float original) {
        NumberWrapper increase = NumberWrapper.zero();
        ArmorTrimEffects.LEATHER.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().leatherStepHeightIncrease));
        return original + increase.getFloat();
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;updateVelocity(FLnet/minecraft/util/math/Vec3d;)V", ordinal=0))
    private float applyTrimSwimSpeedIncrease(float original) {
        if (!ArmorTrimEffects.COPPER.appliesTo(this.betterTrims$getTrimmables())) {
            return original;
        }
        NumberWrapper increase = NumberWrapper.zero();
        ArmorTrimEffects.COPPER.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().copperSwimSpeedIncrease));
        int dsLevel = class_1890.method_8232((class_1309)((class_1309)this));
        if (dsLevel > 0) {
            original += (float)dsLevel * ConfigManager.getConfig().copperSwimSpeedIncrease.floatValue();
        }
        return original + increase.getFloat();
    }

    @ModifyReturnValue(method={"getMovementSpeed()F"}, at={@At(value="RETURN")})
    private float applyTrimSpeedIncrease(float original) {
        class_1496 horseEntity;
        class_1309 class_13092;
        class_1309 class_13093 = (class_1309)this;
        if (class_13093 instanceof class_1496 && (class_13092 = (horseEntity = (class_1496)class_13093).method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            NumberWrapper increase = NumberWrapper.one();
            ArmorTrimEffects.REDSTONE.apply(((LivingEntityExtender)player).betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().redstoneMovementSpeedIncrease));
            if (this.betterTrims$shouldSilverApply()) {
                ArmorTrimEffects.SILVER.apply(((LivingEntityExtender)player).betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().silverEffects.movementSpeed));
            }
            return original * increase.getFloat();
        }
        NumberWrapper increase = NumberWrapper.one();
        ArmorTrimEffects.REDSTONE.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().redstoneMovementSpeedIncrease));
        if (this.betterTrims$shouldSilverApply()) {
            ArmorTrimEffects.SILVER.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().silverEffects.movementSpeed));
        }
        return original * increase.getFloat();
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getVelocity()Lnet/minecraft/util/math/Vec3d;", ordinal=2)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isFallFlying()Z"))})
    private class_243 applyTrimSpeedIncrease(class_243 original) {
        NumberWrapper increase = NumberWrapper.one();
        ArmorTrimEffects.REDSTONE.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().redstoneMovementSpeedIncrease));
        if (this.betterTrims$shouldSilverApply()) {
            ArmorTrimEffects.SILVER.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().silverEffects.movementSpeed));
        }
        return original.method_18805((double)increase.getFloat(), 1.0, (double)increase.getFloat());
    }

    @WrapOperation(method={"applyArmorToDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/DamageUtil;getDamageLeft(FFF)F")})
    private float applyTrimDamageReduction(float damage, float armor, float armorToughness, Operation<Float> original) {
        float orignal = ((Float)original.call(new Object[]{Float.valueOf(damage), Float.valueOf(armor), Float.valueOf(armorToughness)})).floatValue();
        NumberWrapper decrease = NumberWrapper.one();
        ArmorTrimEffects.DIAMOND.apply(this.betterTrims$getTrimmables(), () -> decrease.decrement(ConfigManager.getConfig().diamondDamageReduction));
        if (this.betterTrims$shouldSilverApply()) {
            ArmorTrimEffects.SILVER.apply(this.betterTrims$getTrimmables(), () -> decrease.decrement(ConfigManager.getConfig().silverEffects.damageReduction));
        }
        return decrease.getFloat() * orignal;
    }

    @ModifyReturnValue(method={"getJumpVelocity"}, at={@At(value="RETURN")})
    private float applyTrimJumpHeight(float original) {
        if (this.betterTrims$shouldSilverApply()) {
            NumberWrapper increase = NumberWrapper.zero();
            ArmorTrimEffects.SILVER.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().silverEffects.jumpHeight));
            return original + increase.getFloat();
        }
        return original;
    }

    @ModifyArg(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setAttacker(Lnet/minecraft/entity/LivingEntity;)V"))
    @Nullable
    private class_1309 applyFireChargeTrim(@Nullable class_1309 original) {
        if (original == null) {
            return null;
        }
        NumberWrapper duration = NumberWrapper.zero();
        ArmorTrimEffects.FIRE_CHARGE.apply(this.betterTrims$getTrimmables(), () -> duration.increment(ConfigManager.getConfig().fireChargeFireDuration));
        if (duration.getInt() > 0) {
            original.method_5639(duration.getInt());
        }
        duration.set(0);
        ArmorTrimEffects.FIRE_CHARGE.apply(((LivingEntityExtender)original).betterTrims$getTrimmables(), () -> duration.increment(ConfigManager.getConfig().fireChargeFireDuration));
        if (duration.getInt() > 0) {
            this.method_5639(duration.getInt());
        }
        return original;
    }

    @Override
    protected void onLand(class_2248 instance, class_1922 world, class_1297 entity, Operation<Void> original) {
        if (ConfigManager.getConfig().slimeBallEffects.bounce.booleanValue() && ArmorTrimEffects.SLIME_BALL.appliesTo(this.method_6118(class_1304.field_6166))) {
            class_243 vec3d = this.method_18798();
            if (vec3d.field_1351 < 0.0) {
                this.method_18800(vec3d.field_1352, -vec3d.field_1351, vec3d.field_1350);
            }
        } else {
            super.onLand(instance, world, entity, original);
        }
    }

    @ModifyReturnValue(method={"computeFallDamage"}, at={@At(value="RETURN")})
    private int applyTrimFallDamageReduction(int original) {
        if (ConfigManager.getConfig().slimeBallEffects.bounce.booleanValue() && ArmorTrimEffects.SLIME_BALL.appliesTo(this.method_6118(class_1304.field_6166))) {
            return 0;
        }
        NumberWrapper decrease = NumberWrapper.one();
        ArmorTrimEffects.SLIME_BALL.apply(this.betterTrims$getTrimmables(), () -> decrease.decrement(ConfigManager.getConfig().slimeBallEffects.fallDamageReduction));
        return (int)((float)original * decrease.getFloat());
    }

    @ModifyVariable(method={"takeKnockback"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private double applyTrimKnockbackDecrease(double original) {
        NumberWrapper increase = NumberWrapper.one();
        ArmorTrimEffects.SLIME_BALL.apply(this.betterTrims$getTrimmables(), () -> increase.increment(ConfigManager.getConfig().slimeBallEffects.knockbackIncrease));
        return original * (double)increase.getFloat();
    }

    @Inject(method={"tickStatusEffects"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;next()Ljava/lang/Object;", remap=false)})
    private void manageAreaEffectCloud(CallbackInfo ci) {
        if (!ArmorTrimEffects.DRAGONS_BREATH.appliesTo(this.betterTrims$getTrimmables())) {
            return;
        }
        NumberWrapper radius = NumberWrapper.zero();
        ArmorTrimEffects.DRAGONS_BREATH.apply(this.betterTrims$getTrimmables(), () -> radius.increment(ConfigManager.getConfig().dragonBreathRadius));
        class_1295 areaEffectCloud = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
        ((AreaEffectCloudEntityExtender)areaEffectCloud).betterTrims$setTrimOwner((class_1309)this);
        areaEffectCloud.method_5607((class_1309)this);
        areaEffectCloud.method_5604(1);
        areaEffectCloud.method_5603(radius.getFloat());
        this.field_6280.values().forEach(arg_0 -> ((class_1295)areaEffectCloud).method_5610(arg_0));
        ((AreaEffectCloudEntityAccessor)areaEffectCloud).invokeUpdateColor();
        this.method_37908().method_8649((class_1297)areaEffectCloud);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void addAbsorptionHearts(CallbackInfo ci) {
        ++this.stopwatch;
        if (!ArmorTrimEffects.ENCHANTED_GOLDEN_APPLE.appliesTo(this.betterTrims$getTrimmables())) {
            return;
        }
        NumberWrapper ticksUntilHeal = NumberWrapper.of(ConfigManager.getConfig().enchantedGoldenAppleEffects.absorptionDelay);
        NumberWrapper absorptionAmount = NumberWrapper.zero();
        ArmorTrimEffects.ENCHANTED_GOLDEN_APPLE.apply(this.betterTrims$getTrimmables(), () -> {
            ticksUntilHeal.decrement(ConfigManager.getConfig().enchantedGoldenAppleEffects.absorptionDelayReduction);
            absorptionAmount.increment(ConfigManager.getConfig().enchantedGoldenAppleEffects.absorptionAmount);
        });
        if (absorptionAmount.getFloat() > (float)ConfigManager.getConfig().enchantedGoldenAppleEffects.maxAbsorption.intValue()) {
            absorptionAmount.set(ConfigManager.getConfig().enchantedGoldenAppleEffects.maxAbsorption);
        }
        ticksUntilHeal.decrement(this.stopwatch);
        if (ticksUntilHeal.getInt() > 0) {
            return;
        }
        this.stopwatch = 0;
        if (this.method_6067() < absorptionAmount.getFloat()) {
            this.method_6073(absorptionAmount.getFloat());
        }
    }

    @ModifyExpressionValue(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isDead()Z", ordinal=0)})
    private boolean shouldDodge(boolean original, class_1282 source, float amount) {
        if (original) {
            return true;
        }
        if (!ArmorTrimEffects.ENDER_PEARL.appliesTo(this.betterTrims$getTrimmables())) {
            return false;
        }
        NumberWrapper chance = NumberWrapper.zero();
        ArmorTrimEffects.ENDER_PEARL.apply(this.betterTrims$getTrimmables(), () -> chance.increment(ConfigManager.getConfig().enderPearlEffects.dodgeChance));
        if (chance.getFloat() > RandomHelper.nextFloat() || source.method_48789(class_8103.field_42251) && ConfigManager.getConfig().enderPearlEffects.waterDamagesUser.booleanValue()) {
            this.betterTrims$randomTpEntity((class_1309)this);
        }
        return false;
    }

    @ModifyReturnValue(method={"hurtByWater"}, at={@At(value="RETURN")})
    private boolean checkTrims(boolean original) {
        if (original) {
            return true;
        }
        return ConfigManager.getConfig().enderPearlEffects.waterDamagesUser != false && ArmorTrimEffects.ENDER_PEARL.appliesTo(this.betterTrims$getTrimmables());
    }

    @ModifyReturnValue(method={"hasStatusEffect"}, at={@At(value="RETURN")})
    private boolean checkForSilverTrim(boolean original, class_1291 statusEffect) {
        if (statusEffect != class_1294.field_5925) {
            return original;
        }
        if (original) {
            return true;
        }
        return this.betterTrims$shouldSilverApply() && ArmorTrimEffects.SILVER.appliesTo(this.betterTrims$getTrimmables());
    }

    @ModifyVariable(method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1293 addTrimAmplifierBuff(class_1293 original) {
        NumberWrapper chance = NumberWrapper.zero();
        ArmorTrimEffects.GLOWSTONE_DUST.apply(this.betterTrims$getTrimmables(), () -> chance.increment(ConfigManager.getConfig().glowstonePotionAmplifierIncreaseChance));
        if (chance.getFloat() > RandomHelper.nextFloat()) {
            original = new class_1293(original.method_5579(), original.method_5584(), original.method_5578() + 1, original.method_5591(), original.method_5581(), original.method_5592());
        }
        return original;
    }
}

