/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Locale;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.util.JSONHelper;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.apache.commons.lang3.EnumUtils;

public class SerializerEnum<T extends Enum<T>>
implements ISerializer<T> {
    public final T defaultValue;
    private final Class<T> enumClass;

    public SerializerEnum(Class<T> enumClass) {
        this(enumClass, null);
    }

    public SerializerEnum(Class<T> enumClass, T defaultValue) {
        this.enumClass = enumClass;
        this.defaultValue = defaultValue;
    }

    @Override
    public T fromJSON(JsonElement json) {
        return this.getByName(JSONHelper.getAsString(json));
    }

    @Override
    public JsonElement toJSON(T toWrite) {
        return new JsonPrimitive(((Enum)toWrite).name());
    }

    @Override
    public T fromByteBuf(class_2540 buffer) {
        return this.getByName(buffer.method_19772());
    }

    @Override
    public void toByteBuf(class_2540 buffer, T toWrite) {
        buffer.method_10814(((Enum)toWrite).name());
    }

    @Override
    public class_2520 toNBT(T toWrite) {
        return class_2519.method_23256((String)((Enum)toWrite).name());
    }

    @Override
    public T fromNBT(class_2520 nbt) {
        if (nbt instanceof class_2497) {
            class_2497 integer = (class_2497)nbt;
            return this.getByIndex(integer.method_10701());
        }
        if (nbt instanceof class_2519) {
            class_2519 stringTag = (class_2519)nbt;
            return this.getByName(stringTag.method_10714());
        }
        throw new NBTParseException("Expected NBT to be a String tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }

    private T getByIndex(int index) {
        Enum[] values = (Enum[])this.enumClass.getEnumConstants();
        if (index < 0 || index > values.length) {
            throw new IndexOutOfBoundsException("Cannot read enum by index. Class: " + this.enumClass.getCanonicalName() + " Index: " + index + " Size: " + values.length);
        }
        return (T)values[index];
    }

    private T getByName(String name) {
        Enum value = EnumUtils.getEnum(this.enumClass, (String)name);
        if (value == null) {
            value = EnumUtils.getEnum(this.enumClass, (String)name.toUpperCase(Locale.ROOT));
        }
        if (value == null) {
            value = this.defaultValue;
        }
        return (T)value;
    }
}

