/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v2;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2792;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandlerV2 {
    public static NetworkHandlerV2 build(String modId) {
        return NetworkHandlerV2.build(modId, -1);
    }

    public static NetworkHandlerV2 build(String modId, int id) {
        return NetworkHandlerV2.build(modId, id, false, false);
    }

    public static NetworkHandlerV2 build(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        return NetworkHandlerV2.build(modId, -1, clientAcceptsVanillaOrMissing, serverAcceptsVanillaOrMissing);
    }

    public static NetworkHandlerV2 build(String modId, int id, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        return ModContext.get(modId).getNetworkHandlerV2(id, clientAcceptsVanillaOrMissing, serverAcceptsVanillaOrMissing);
    }

    @Deprecated(forRemoval=true)
    public <T extends MessageV2<T>> void register(Class<? extends T> var1, Supplier<T> var2, MessageDirection var3);

    public <T extends MessageV2<T>> NetworkHandlerV2 registerClientbound(Class<T> var1);

    public <T extends MessageV2<T>> NetworkHandlerV2 registerServerbound(Class<T> var1);

    public class_2596<class_2792> toServerboundPacket(MessageV2<?> var1);

    public class_2596<class_2602> toClientboundPacket(MessageV2<?> var1);

    default public void sendToServer(MessageV2<?> message) {
        Proxy.INSTANCE.getClientPacketListener().method_2883(this.toServerboundPacket(message));
    }

    default public void sendTo(MessageV2<?> message, class_3222 player) {
        player.field_13987.method_14364(this.toClientboundPacket(message));
    }

    default public void sendToAll(MessageV2<?> message) {
        CommonAbstractions.INSTANCE.getMinecraftServer().method_3760().method_14581(this.toClientboundPacket(message));
    }

    default public void sendToAllExcept(MessageV2<?> message, class_3222 exclude) {
        for (class_3222 player : CommonAbstractions.INSTANCE.getMinecraftServer().method_3760().method_14571()) {
            if (player == exclude) continue;
            this.sendTo(message, player);
        }
    }

    default public void sendToAllNear(MessageV2<?> message, class_2338 pos, class_1937 level) {
        this.sendToAllNearExcept(message, null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 64.0, level);
    }

    default public void sendToAllNear(MessageV2<?> message, double posX, double posY, double posZ, double distance, class_1937 level) {
        this.sendToAllNearExcept(message, null, posX, posY, posZ, 64.0, level);
    }

    default public void sendToAllNearExcept(MessageV2<?> message, @Nullable class_3222 exclude, double posX, double posY, double posZ, double distance, class_1937 level) {
        CommonAbstractions.INSTANCE.getMinecraftServer().method_3760().method_14605((class_1657)exclude, posX, posY, posZ, distance, level.method_27983(), this.toClientboundPacket(message));
    }

    default public void sendToAllTracking(MessageV2<?> message, class_1297 entity) {
        ((class_3215)entity.method_5770().method_8398()).method_18754(entity, this.toClientboundPacket(message));
    }

    default public void sendToAllTrackingAndSelf(MessageV2<?> message, class_1297 entity) {
        ((class_3215)entity.method_5770().method_8398()).method_18751(entity, this.toClientboundPacket(message));
    }

    default public void sendToDimension(MessageV2<?> message, class_1937 level) {
        this.sendToDimension(message, (class_5321<class_1937>)level.method_27983());
    }

    default public void sendToDimension(MessageV2<?> message, class_5321<class_1937> dimension) {
        CommonAbstractions.INSTANCE.getMinecraftServer().method_3760().method_14589(this.toClientboundPacket(message), dimension);
    }
}

