/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.config;

import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.config.CrosshairVisibility;
import net.minecraft.class_310;
import net.minecraft.class_5498;

public enum Perspective {
    FIRST_PERSON(class_5498.field_26664, CrosshairVisibility.ALWAYS),
    THIRD_PERSON_BACK(class_5498.field_26665, CrosshairVisibility.NEVER),
    THIRD_PERSON_FRONT(class_5498.field_26666, CrosshairVisibility.NEVER),
    SHOULDER_SURFING(class_5498.field_26665, CrosshairVisibility.ALWAYS);

    private final class_5498 cameraType;
    private final CrosshairVisibility defaultCrosshairVisibility;

    private Perspective(class_5498 cameraType, CrosshairVisibility defaultCrosshairVisibility) {
        this.cameraType = cameraType;
        this.defaultCrosshairVisibility = defaultCrosshairVisibility;
    }

    public class_5498 getCameraType() {
        return this.cameraType;
    }

    public CrosshairVisibility getDefaultCrosshairVisibility() {
        return this.defaultCrosshairVisibility;
    }

    public Perspective next() {
        Perspective next = Perspective.values()[(this.ordinal() + 1) % Perspective.values().length];
        if (Config.CLIENT.replaceDefaultPerspective()) {
            if (this == FIRST_PERSON) {
                next = SHOULDER_SURFING;
            } else if (this == SHOULDER_SURFING) {
                next = THIRD_PERSON_FRONT;
            } else if (this == THIRD_PERSON_FRONT) {
                next = FIRST_PERSON;
            }
        }
        if (Config.CLIENT.skipThirdPersonFront() && next == THIRD_PERSON_FRONT) {
            return next.next();
        }
        return next;
    }

    public static Perspective of(class_5498 cameraType, boolean shoulderSurfing) {
        switch (cameraType) {
            case field_26664: {
                return FIRST_PERSON;
            }
            case field_26665: {
                return shoulderSurfing ? SHOULDER_SURFING : THIRD_PERSON_BACK;
            }
            case field_26666: {
                return THIRD_PERSON_FRONT;
            }
        }
        return FIRST_PERSON;
    }

    public static Perspective current() {
        return Perspective.of(class_310.method_1551().field_1690.method_31044(), ShoulderInstance.getInstance().doShoulderSurfing());
    }
}

