/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.common;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.implementations.blockentities.IViewCellStorage;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInteractionPacket;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.ToolboxMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.IMEInteractionHandler;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.me.crafting.CraftAmountMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerListener;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class MEStorageMenu
extends AEBaseMenu
implements IConfigManagerListener,
IConfigurableObject,
IMEInteractionHandler {
    public static final class_3917<MEStorageMenu> TYPE = MenuTypeBuilder.create(MEStorageMenu::new, ITerminalHost.class).build("item_terminal");
    public static final class_3917<MEStorageMenu> PORTABLE_ITEM_CELL_TYPE = MenuTypeBuilder.create(MEStorageMenu::new, IPortableTerminal.class).build("portable_item_cell");
    public static final class_3917<MEStorageMenu> PORTABLE_FLUID_CELL_TYPE = MenuTypeBuilder.create(MEStorageMenu::new, IPortableTerminal.class).build("portable_fluid_cell");
    public static final class_3917<MEStorageMenu> WIRELESS_TYPE = MenuTypeBuilder.create(MEStorageMenu::new, IPortableTerminal.class).build("wirelessterm");
    private final List<RestrictedInputSlot> viewCellSlots;
    private final IConfigManager clientCM;
    private final ToolboxMenu toolboxMenu;
    private final ITerminalHost host;
    @GuiSync(value=98)
    public boolean hasPower = false;
    @GuiSync(value=100)
    public int activeCraftingJobs = -1;
    private IConfigManagerListener gui;
    private IConfigManager serverCM;
    @Nullable
    protected final MEStorage storage;
    @Nullable
    protected final IEnergySource powerSource;
    private final IncrementalUpdateHelper updateHelper = new IncrementalUpdateHelper();
    @Nullable
    private IGridNode networkNode;
    @Nullable
    private IClientRepo clientRepo;
    private Set<AEKey> previousCraftables = Collections.emptySet();
    private KeyCounter previousAvailableStacks = new KeyCounter();

    public MEStorageMenu(class_3917<?> menuType, int id, class_1661 ip, ITerminalHost host) {
        this(menuType, id, ip, host, true);
    }

    protected MEStorageMenu(class_3917<?> menuType, int id, class_1661 ip, ITerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, host);
        this.host = host;
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.clientCM.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        IEnergySource powerSource = null;
        if (this.isServerSide()) {
            this.serverCM = host.getConfigManager();
            this.storage = host.getInventory();
            if (this.storage != null) {
                IActionHost actionHost;
                IGridNode node;
                if (host instanceof IPortableTerminal || host instanceof IMEChest) {
                    powerSource = (IEnergySource)((Object)host);
                } else if (host instanceof IActionHost && (node = (actionHost = (IActionHost)((Object)host)).getActionableNode()) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    powerSource = new ChannelPowerSrc(this.networkNode, g.getEnergyService());
                }
            } else {
                this.setValidMenu(false);
            }
        } else {
            this.storage = null;
        }
        this.powerSource = powerSource;
        if (!this.hideViewCells() && host instanceof IViewCellStorage) {
            InternalInventory viewCellStorage = ((IViewCellStorage)((Object)host)).getViewCellStorage();
            this.viewCellSlots = new ArrayList<RestrictedInputSlot>(viewCellStorage.size());
            for (int i = 0; i < viewCellStorage.size(); ++i) {
                RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.VIEW_CELL, viewCellStorage, i);
                this.addSlot(slot, SlotSemantics.VIEW_CELL);
                this.viewCellSlots.add(slot);
            }
        } else {
            this.viewCellSlots = Collections.emptyList();
        }
        this.toolboxMenu = new ToolboxMenu(this);
        this.setupUpgrades(host.getUpgrades());
        if (bindInventory) {
            this.createPlayerInventorySlots(ip);
        }
    }

    public ToolboxMenu getToolbox() {
        return this.toolboxMenu;
    }

    protected boolean hideViewCells() {
        return false;
    }

    @Nullable
    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public boolean isKeyVisible(AEKey key) {
        ItemMenuHost itemMenuHost;
        class_1792 class_17922;
        ITerminalHost iTerminalHost = this.host;
        if (iTerminalHost instanceof ItemMenuHost && (class_17922 = (itemMenuHost = (ItemMenuHost)((Object)iTerminalHost)).getItemStack().method_7909()) instanceof IBasicCellItem) {
            IBasicCellItem basicCellItem = (IBasicCellItem)class_17922;
            return basicCellItem.getKeyType().contains(key);
        }
        return true;
    }

    @Override
    public void method_7623() {
        this.toolboxMenu.tick();
        if (this.isServerSide()) {
            if (this.storage != this.host.getInventory()) {
                this.setValidMenu(false);
                return;
            }
            this.updateActiveCraftingJobs();
            for (Setting<?> set : this.serverCM.getSettings()) {
                Object sideRemote;
                Object sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                set.copy(this.serverCM, this.clientCM);
                this.sendPacketToClient(new ConfigValuePacket(set, this.serverCM));
            }
            Set<AEKey> craftables = this.getCraftablesFromGrid();
            KeyCounter availableStacks = this.storage == null ? new KeyCounter() : this.storage.getAvailableStacks();
            KeyCounter requestables = new KeyCounter();
            try {
                Sets.difference(this.previousCraftables, craftables).forEach(this.updateHelper::addChange);
                Sets.difference(craftables, this.previousCraftables).forEach(this.updateHelper::addChange);
                this.previousAvailableStacks.removeAll(availableStacks);
                this.previousAvailableStacks.removeZeros();
                this.previousAvailableStacks.keySet().forEach(this.updateHelper::addChange);
                if (this.updateHelper.hasChanges()) {
                    MEInventoryUpdatePacket.Builder builder = MEInventoryUpdatePacket.builder(this.field_7763, this.updateHelper.isFullUpdate());
                    builder.setFilter(this::isKeyVisible);
                    builder.addChanges(this.updateHelper, availableStacks, craftables, requestables);
                    builder.buildAndSend(x$0 -> this.sendPacketToClient((BasePacket)x$0));
                    this.updateHelper.commitChanges();
                }
            }
            catch (Exception e) {
                AELog.warn(e, "Failed to send incremental inventory update to client");
            }
            this.previousCraftables = ImmutableSet.copyOf(craftables);
            this.previousAvailableStacks = availableStacks;
            this.updatePowerStatus();
            super.method_7623();
        }
    }

    protected boolean showsCraftables() {
        return true;
    }

    private Set<AEKey> getCraftablesFromGrid() {
        ITerminalHost iTerminalHost;
        IGridNode hostNode = this.networkNode;
        if (hostNode == null && (iTerminalHost = this.host) instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)((Object)iTerminalHost);
            hostNode = actionHost.getActionableNode();
        }
        if (!this.showsCraftables()) {
            return Collections.emptySet();
        }
        if (hostNode != null && hostNode.isActive()) {
            return hostNode.getGrid().getCraftingService().getCraftables(this::isKeyVisible);
        }
        return Collections.emptySet();
    }

    protected void updatePowerStatus() {
        if (this.networkNode != null) {
            this.hasPower = this.networkNode.isActive();
        } else {
            IEnergySource iEnergySource = this.powerSource;
            if (iEnergySource instanceof IEnergyService) {
                IEnergyService energyService = (IEnergyService)iEnergySource;
                this.hasPower = energyService.isNetworkPowered();
            } else {
                this.hasPower = this.powerSource != null ? this.powerSource.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8 : false;
            }
        }
    }

    private void updateActiveCraftingJobs() {
        IGridNode hostNode = this.networkNode;
        if (hostNode == null && this.host instanceof IActionHost) {
            hostNode = ((IActionHost)((Object)this.host)).getActionableNode();
        }
        IGrid grid = null;
        if (hostNode != null) {
            grid = hostNode.getGrid();
        }
        if (grid == null) {
            this.activeCraftingJobs = -1;
            return;
        }
        int activeJobs = 0;
        for (ICraftingCPU cpus : grid.getCraftingService().getCpus()) {
            if (!cpus.isBusy()) continue;
            ++activeJobs;
        }
        this.activeCraftingJobs = activeJobs;
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (this.getGui() != null) {
            this.getGui().onSettingChanged(manager, setting);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (this.isServerSide()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public List<class_1799> getViewCells() {
        return this.viewCellSlots.stream().map(AppEngSlot::method_7677).collect(Collectors.toList());
    }

    protected final boolean canInteractWithGrid() {
        return this.storage != null && this.powerSource != null && this.isPowered();
    }

    @Override
    public final void handleInteraction(long serial, InventoryAction action) {
        if (this.isClientSide()) {
            NetworkHandler.instance().sendToServer(new MEInteractionPacket(this.field_7763, serial, action));
            return;
        }
        if (!this.canInteractWithGrid()) {
            return;
        }
        class_3222 player = (class_3222)this.getPlayerInventory().field_7546;
        if (serial == -1L) {
            this.handleNetworkInteraction(player, null, action);
            return;
        }
        AEKey stack = this.getStackBySerial(serial);
        if (stack == null) {
            return;
        }
        this.handleNetworkInteraction(player, stack, action);
    }

    protected void handleNetworkInteraction(class_3222 player, @Nullable AEKey clickedKey, InventoryAction action) {
        if (this.storage == null) {
            return;
        }
        if (action == InventoryAction.PICKUP_OR_SET_DOWN && ContainerItemStrategies.isKeySupported(clickedKey)) {
            action = InventoryAction.FILL_ITEM;
        }
        if (action == InventoryAction.SPLIT_OR_PLACE_SINGLE && ContainerItemStrategies.getContainedStack(this.method_34255()) != null) {
            action = InventoryAction.EMPTY_ITEM;
        }
        if (action == InventoryAction.FILL_ITEM) {
            this.tryFillContainerItem(clickedKey, false);
        } else if (action == InventoryAction.SHIFT_CLICK) {
            this.tryFillContainerItem(clickedKey, true);
        } else if (action == InventoryAction.EMPTY_ITEM) {
            this.handleEmptyHeldItem((what, amount, mode) -> StorageHelper.poweredInsert(this.powerSource, this.storage, what, amount, this.getActionSource(), mode));
        } else if (action == InventoryAction.AUTO_CRAFT) {
            MenuLocator locator = this.getLocator();
            if (locator != null && clickedKey != null) {
                CraftAmountMenu.open(player, locator, clickedKey, clickedKey.getAmountPerUnit());
            }
            return;
        }
        if (clickedKey == null) {
            if (action == InventoryAction.SPLIT_OR_PLACE_SINGLE || action == InventoryAction.ROLL_DOWN) {
                this.putCarriedItemIntoNetwork(true);
            } else if (action == InventoryAction.PICKUP_OR_SET_DOWN) {
                this.putCarriedItemIntoNetwork(false);
            }
            return;
        }
        if (!(clickedKey instanceof AEItemKey)) {
            return;
        }
        AEItemKey clickedItem = (AEItemKey)clickedKey;
        switch (action) {
            case SHIFT_CLICK: {
                this.moveOneStackToPlayer(clickedItem);
                break;
            }
            case ROLL_DOWN: {
                AEItemKey what2;
                long inserted;
                class_1799 carried = this.method_34255();
                if (carried.method_7960() || (inserted = StorageHelper.poweredInsert(this.powerSource, this.storage, what2 = AEItemKey.of(carried), 1L, this.getActionSource())) <= 0L) break;
                this.method_34255().method_7934(1);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                long extracted;
                class_1799 item = this.method_34255();
                if (!item.method_7960()) {
                    if (item.method_7947() >= item.method_7914()) {
                        return;
                    }
                    if (!clickedItem.matches(item)) {
                        return;
                    }
                }
                if ((extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, clickedItem, 1L, this.getActionSource())) <= 0L) break;
                if (item.method_7960()) {
                    this.method_34254(clickedItem.toStack());
                    break;
                }
                item.method_7933(1);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (!this.method_34255().method_7960()) {
                    this.putCarriedItemIntoNetwork(false);
                    break;
                }
                long extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, clickedItem, clickedItem.getMaxStackSize(), this.getActionSource());
                if (extracted > 0L) {
                    this.method_34254(clickedItem.toStack((int)extracted));
                    break;
                }
                this.method_34254(class_1799.field_8037);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!this.method_34255().method_7960()) {
                    this.putCarriedItemIntoNetwork(true);
                    break;
                }
                long extracted = this.storage.extract(clickedItem, clickedItem.getMaxStackSize(), Actionable.SIMULATE, this.getActionSource());
                if (extracted > 0L) {
                    extracted = extracted + 1L >> 1;
                    extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, clickedItem, extracted, this.getActionSource());
                }
                if (extracted > 0L) {
                    this.method_34254(clickedItem.toStack((int)extracted));
                    break;
                }
                this.method_34254(class_1799.field_8037);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.method_31549().field_7477) break;
                class_1799 is = clickedItem.toStack();
                is.method_7939(is.method_7914());
                this.method_34254(is);
                break;
            }
            case MOVE_REGION: {
                int playerInv = player.method_31548().field_7547.size();
                for (int slotNum = 0; slotNum < playerInv && this.moveOneStackToPlayer(clickedItem); ++slotNum) {
                }
                break;
            }
            default: {
                AELog.warn("Received unhandled inventory action %s from client in %s", new Object[]{action, this.getClass()});
            }
        }
    }

    private void tryFillContainerItem(@Nullable AEKey clickedKey, boolean moveToPlayer) {
        AEFluidKey fluidKey;
        boolean grabbedEmptyBucket = false;
        if (this.method_34255().method_7960() && clickedKey instanceof AEFluidKey && (fluidKey = (AEFluidKey)clickedKey).getFluid().method_15774() != class_1802.field_8162 && this.storage != null && this.storage.extract(AEItemKey.of((class_1935)class_1802.field_8550), 1L, Actionable.MODULATE, this.getActionSource()) >= 1L) {
            class_1799 bucket = class_1802.field_8550.method_7854();
            this.method_34254(bucket);
            grabbedEmptyBucket = true;
        }
        class_1792 carriedBefore = this.method_34255().method_7909();
        this.handleFillingHeldItem((amount, mode) -> StorageHelper.poweredExtraction(this.powerSource, this.storage, clickedKey, amount, this.getActionSource(), mode), clickedKey);
        if (grabbedEmptyBucket && this.method_34255().method_31574(class_1802.field_8550)) {
            long inserted = this.storage.insert(AEItemKey.of(this.method_34255()), this.method_34255().method_7947(), Actionable.MODULATE, this.getActionSource());
            class_1799 newCarried = this.method_34255().method_7972();
            newCarried.method_7934(Ints.saturatedCast((long)inserted));
            this.method_34254(newCarried);
        }
        if (moveToPlayer && !this.method_34255().method_31574(carriedBefore) && this.getPlayer().method_7270(this.method_34255())) {
            this.method_34254(class_1799.field_8037);
        }
    }

    protected void putCarriedItemIntoNetwork(boolean singleItem) {
        class_1799 heldStack = this.method_34255();
        AEItemKey what = AEItemKey.of(heldStack);
        if (what == null) {
            return;
        }
        int amount = heldStack.method_7947();
        if (singleItem) {
            amount = 1;
        }
        long inserted = StorageHelper.poweredInsert(this.powerSource, this.storage, what, amount, this.getActionSource());
        this.method_34254(Platform.getInsertionRemainder(heldStack, inserted));
    }

    private boolean moveOneStackToPlayer(AEItemKey stack) {
        int toExtract;
        class_1799 myItem = stack.toStack();
        class_1661 playerInv = this.getPlayerInventory();
        int slot = playerInv.method_7390(myItem);
        if (slot != -1) {
            toExtract = myItem.method_7914() - playerInv.method_5438(slot).method_7947();
        } else {
            slot = playerInv.method_7376();
            if (slot == -1) {
                return false;
            }
            toExtract = myItem.method_7914();
        }
        if (toExtract <= 0) {
            return false;
        }
        long extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, stack, toExtract, this.getActionSource());
        if (extracted == 0L) {
            return false;
        }
        class_1799 itemInSlot = playerInv.method_5438(slot);
        if (itemInSlot.method_7960()) {
            playerInv.method_5447(slot, stack.toStack((int)extracted));
        } else {
            itemInSlot.method_7933((int)extracted);
        }
        return true;
    }

    @Nullable
    protected final AEKey getStackBySerial(long serial) {
        return this.updateHelper.getBySerial(serial);
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private IConfigManagerListener getGui() {
        return this.gui;
    }

    public void setGui(IConfigManagerListener gui) {
        this.gui = gui;
    }

    @Nullable
    public IClientRepo getClientRepo() {
        return this.clientRepo;
    }

    public void setClientRepo(@Nullable IClientRepo clientRepo) {
        this.clientRepo = clientRepo;
    }

    @Override
    protected class_1799 transferStackToMenu(class_1799 input) {
        if (!this.canInteractWithGrid()) {
            return super.transferStackToMenu(input);
        }
        AEItemKey key = AEItemKey.of(input);
        if (key == null || !this.isKeyVisible(key)) {
            return input;
        }
        long inserted = StorageHelper.poweredInsert(this.powerSource, this.storage, key, input.method_7947(), this.getActionSource());
        return Platform.getInsertionRemainder(input, inserted);
    }

    public boolean hasItemType(class_1799 itemStack, int amount) {
        IClientRepo clientRepo = this.getClientRepo();
        if (clientRepo != null) {
            for (GridInventoryEntry stack : clientRepo.getAllEntries()) {
                if (!AEItemKey.matches(stack.getWhat(), itemStack)) continue;
                if (stack.getStoredAmount() >= (long)amount) {
                    return true;
                }
                amount = (int)((long)amount - stack.getStoredAmount());
            }
        }
        return false;
    }

    protected final KeyCounter getPreviousAvailableStacks() {
        Preconditions.checkState((boolean)this.isServerSide());
        return this.previousAvailableStacks;
    }

    public boolean canConfigureTypeFilter() {
        return this.host.getConfigManager().hasSetting(Settings.TYPE_FILTER);
    }

    public ITerminalHost getHost() {
        return this.host;
    }
}

