/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.inventories.InternalInventory;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.client.Point;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.IOptionalSlot;
import appeng.menu.slot.IPartitionSlotHost;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class CellPartitionSlot
extends FakeSlot
implements IOptionalSlot {
    private final IPartitionSlotHost host;
    private final int slot;

    public CellPartitionSlot(InternalInventory inv, IPartitionSlotHost containerBus, int invSlot) {
        super(inv, invSlot);
        this.host = containerBus;
        this.slot = invSlot;
    }

    @Override
    public class_1799 method_7677() {
        if (!this.isSlotEnabled()) {
            this.clearStack();
        }
        return super.method_7677();
    }

    @Override
    public boolean isSlotEnabled() {
        return this.host.isPartitionSlotEnabled(this.slot);
    }

    @Override
    public void method_7673(class_1799 is) {
        if (this.canFitInsideCell(is)) {
            super.method_7673(is);
        }
    }

    @Override
    public boolean isRenderDisabled() {
        return true;
    }

    @Override
    public Point getBackgroundPos() {
        return new Point(this.field_7873 - 1, this.field_7872 - 1);
    }

    @Override
    @Nullable
    public List<class_2561> getCustomTooltip(class_1799 carriedItem) {
        if (!this.canFitInsideCell(carriedItem)) {
            return List.of(Tooltips.of(GuiText.CantFitInsideStorageCell, Tooltips.RED, new Object[0]));
        }
        return super.getCustomTooltip(carriedItem);
    }

    private boolean canFitInsideCell(class_1799 stack) {
        StorageCell cellInv = StorageCells.getCellInventory(stack, null);
        return cellInv == null || cellInv.canFitInsideCell();
    }
}

