/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.services;

import appeng.core.worlddata.AESavedData;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

class ChunkLoadState
extends AESavedData {
    public static final String NAME = "ae2_chunk_load_state";
    private final class_3218 level;
    private final Long2ObjectMap<Set<class_2338>> forceLoadedChunks = new Long2ObjectOpenHashMap();

    public static ChunkLoadState get(class_3218 level) {
        return (ChunkLoadState)level.method_17983().method_17924(tag -> new ChunkLoadState(level, (class_2487)tag), () -> new ChunkLoadState(level), NAME);
    }

    private ChunkLoadState(class_3218 level) {
        this.level = level;
    }

    private ChunkLoadState(class_3218 level, class_2487 tag) {
        this(level);
        class_2499 forcedChunks = tag.method_10554("forcedChunks", 10);
        for (int i = 0; i < forcedChunks.size(); ++i) {
            class_2487 forcedChunk = forcedChunks.method_10602(i);
            class_1923 chunkPos = new class_1923(forcedChunk.method_10550("cx"), forcedChunk.method_10550("cz"));
            HashSet<class_2338> blockSet = new HashSet<class_2338>();
            class_2499 blocks = forcedChunk.method_10554("blocks", 10);
            for (int j = 0; j < blocks.size(); ++j) {
                blockSet.add(class_2512.method_10691((class_2487)blocks.method_10602(j)));
            }
            this.forceLoadedChunks.put(chunkPos.method_8324(), blockSet);
        }
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 forcedChunks = new class_2499();
        for (Long2ObjectMap.Entry entry : this.forceLoadedChunks.long2ObjectEntrySet()) {
            class_1923 chunkPos = new class_1923(entry.getLongKey());
            class_2487 forcedChunk = new class_2487();
            forcedChunk.method_10569("cx", chunkPos.field_9181);
            forcedChunk.method_10569("cz", chunkPos.field_9180);
            class_2499 list = new class_2499();
            for (class_2338 pos : (Set)entry.getValue()) {
                list.add((Object)class_2512.method_10692((class_2338)pos));
            }
            forcedChunk.method_10566("blocks", (class_2520)list);
            forcedChunks.add((Object)forcedChunk);
        }
        tag.method_10566("forcedChunks", (class_2520)forcedChunks);
        return tag;
    }

    public void forceChunk(class_1923 chunkPos, class_2338 sourcePos) {
        long chunk = chunkPos.method_8324();
        ((Set)this.forceLoadedChunks.computeIfAbsent(chunk, pos -> new HashSet())).add(sourcePos.method_10062());
        this.level.method_17988(chunkPos.field_9181, chunkPos.field_9180, true);
        this.method_80();
    }

    public void releaseChunk(class_1923 chunkPos, class_2338 sourcePos) {
        Set map = (Set)this.forceLoadedChunks.get(chunkPos.method_8324());
        if (map == null) {
            return;
        }
        map.remove(sourcePos);
        if (map.isEmpty()) {
            this.forceLoadedChunks.remove(chunkPos.method_8324());
            this.level.method_17988(chunkPos.field_9181, chunkPos.field_9180, false);
        }
        this.method_80();
    }

    public void releaseAll(class_2338 sourcePos) {
        long[] relevantChunks;
        for (long chunk : relevantChunks = this.forceLoadedChunks.long2ObjectEntrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(sourcePos)).mapToLong(Long2ObjectMap.Entry::getLongKey).toArray()) {
            this.releaseChunk(new class_1923(chunk), sourcePos);
        }
    }

    public Map<class_2338, LongSet> getAllBlocks() {
        HashMap<class_2338, LongSet> blocks = new HashMap<class_2338, LongSet>();
        for (Long2ObjectMap.Entry entry : this.forceLoadedChunks.long2ObjectEntrySet()) {
            for (class_2338 blockPos : (Set)entry.getValue()) {
                blocks.computeIfAbsent(blockPos, pos -> new LongOpenHashSet()).add(entry.getLongKey());
            }
        }
        return blocks;
    }

    public boolean isForceLoaded(int cx, int cz) {
        return this.forceLoadedChunks.containsKey(class_1923.method_8331((int)cx, (int)cz));
    }
}

