/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.Config;
import com.bisecthosting.mods.bhmenu.config.values.BooleanValue;
import com.bisecthosting.mods.bhmenu.config.values.StringValue;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class GlobalConfigs {
    public final File configDirectory;
    private final Map<String, Config> configs = new HashMap<String, Config>();
    public StringValue title;
    public StringValue description;
    public BooleanValue useLanguageFiles;
    public StringValue partnerId;
    public StringValue packId;
    public BooleanValue packEditMode;

    public GlobalConfigs(File configDirectory) {
        this.configDirectory = configDirectory;
        if (!this.configDirectory.exists() && !this.configDirectory.mkdir()) {
            ModRef.LOGGER.warn("Could not create configuration directory: " + this.configDirectory.getAbsolutePath());
        }
    }

    public void load() {
        this.loadGeneralConfigs();
        this.loadModuleConfigs();
    }

    private void loadModuleConfigs() {
        for (IModule module : ModRoot.get().modules.getAll()) {
            File configFile = GlobalConfigs.getConfigFile(this.configDirectory, module.getId());
            Properties properties = new Properties();
            Config moduleConfigFile = new Config(properties, configFile);
            moduleConfigFile.load();
            ModRoot.get().modules.putEnabledValue(module.getId(), moduleConfigFile.defineBoolean("enabled", true, new String[0]));
            module.buildConfigs(moduleConfigFile);
            moduleConfigFile.save();
            this.configs.put(module.getId(), moduleConfigFile);
        }
    }

    private void loadGeneralConfigs() {
        File configFile = GlobalConfigs.getConfigFile(this.configDirectory, "general");
        Properties properties = new Properties();
        Config config = new Config(properties, configFile);
        config.load();
        this.partnerId = config.defineString("partner_id", "", "Your partner ID to use in during the ordering process.", "Without this you will not be credited for the purchases.", "(Your partner id is not the same as your referral link, please check your client area to find your partner id at https://www.bisecthosting.com/partners/console.php).");
        this.packId = config.defineString("pack_id", "", "The id of this modpack.", "(This is BH internal pack id; Find the id here: https://www.bisecthosting.com/partners/console.php)");
        this.packEditMode = config.defineBoolean("pack_edit_mode", true, "Set this to false to disable pack config screen and enable user configs instead.", "This should always be done by the pack author once they are done with configuring the pack.", "To re-enable Pack Edit Mode, please edit the config file.");
        StringBuilder commentBuilder = config.getComments();
        commentBuilder.append("BHMenu config file.").append("\n\n");
        commentBuilder.append("IMPORTANT INFO").append("\n");
        this.configs.put("general", config);
        config.save();
    }

    public void save() {
        this.configs.values().forEach(Config::save);
    }

    private static File getConfigFile(File parent, String name) {
        return new File(parent, "bhmenu-" + name + ".properties");
    }
}

