/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class MergedStorage
implements Storage<ItemVariant> {
    private Set<Storage<ItemVariant>> dupCheck = new HashSet<Storage<ItemVariant>>();
    public List<Storage<ItemVariant>> parts = new ArrayList<Storage<ItemVariant>>();
    private boolean iterating;

    public Collection<Storage<ItemVariant>> getStorages() {
        return this.parts;
    }

    public void add(Storage<ItemVariant> storage) {
        if (storage == this) {
            return;
        }
        if (storage instanceof MergedStorage) {
            MergedStorage str = (MergedStorage)storage;
            str.parts.forEach(this::add);
            return;
        }
        if (this.dupCheck.add(storage)) {
            this.parts.add(storage);
        }
    }

    public void clear() {
        this.parts.clear();
        this.dupCheck.clear();
    }

    public boolean supportsInsertion() {
        for (Storage<ItemVariant> part : this.parts) {
            if (!part.supportsInsertion()) continue;
            return true;
        }
        return false;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long amount = 0L;
        for (Storage<ItemVariant> part : this.parts) {
            if ((amount += part.insert((Object)resource, maxAmount - amount, transaction)) == maxAmount) break;
        }
        return amount;
    }

    public boolean supportsExtraction() {
        for (Storage<ItemVariant> part : this.parts) {
            if (!part.supportsExtraction()) continue;
            return true;
        }
        return false;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long amount = 0L;
        for (Storage<ItemVariant> part : this.parts) {
            if ((amount += part.extract((Object)resource, maxAmount - amount, transaction)) == maxAmount) break;
        }
        return amount;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        if (this.iterating) {
            new Throwable("Recursive storage access").printStackTrace();
            return Collections.emptyIterator();
        }
        return new CombinedIterator();
    }

    private class CombinedIterator
    implements Iterator<StorageView<ItemVariant>> {
        final Iterator<Storage<ItemVariant>> partIterator;
        Iterator<? extends StorageView<ItemVariant>> currentPartIterator;

        CombinedIterator() {
            this.partIterator = MergedStorage.this.parts.iterator();
            this.currentPartIterator = null;
            this.advanceCurrentPartIterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentPartIterator != null && this.currentPartIterator.hasNext();
        }

        @Override
        public StorageView<ItemVariant> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StorageView<ItemVariant> returned = this.currentPartIterator.next();
            if (!this.currentPartIterator.hasNext()) {
                this.advanceCurrentPartIterator();
            }
            return returned;
        }

        private void advanceCurrentPartIterator() {
            MergedStorage.this.iterating = true;
            while (this.partIterator.hasNext()) {
                this.currentPartIterator = this.partIterator.next().iterator();
                if (!this.currentPartIterator.hasNext()) continue;
            }
            MergedStorage.this.iterating = false;
        }
    }
}

