/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry;

import java.util.ArrayList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.config.MidnightConfig;
import net.soulsweaponry.items.TestItem;
import net.soulsweaponry.items.material.ModToolMaterials;
import net.soulsweaponry.networking.PacketRegistry;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.EventRegistry;
import net.soulsweaponry.registry.GunRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.RecipeRegistry;
import net.soulsweaponry.registry.SpawnInit;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.world.gen.OreGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.GeckoLib;

public class SoulsWeaponry
implements ModInitializer {
    public static final String ModId = "soulsweapons";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Soulslike Weaponry");
    public static class_1761 MAIN_GROUP;
    public static final ArrayList<class_1792> ITEM_GROUP_LIST;

    public void onInitialize() {
        long start = System.currentTimeMillis();
        MidnightConfig.init(ModId, ConfigConstructor.class);
        LOGGER.info("Config initialized!");
        GeckoLib.initialize();
        LOGGER.info("Successfully initialized Geckolib!");
        BlockRegistry.init();
        ItemRegistry.init();
        EffectRegistry.init();
        EnchantRegistry.init();
        EntityRegistry.init();
        EventRegistry.init();
        ParticleRegistry.init();
        SpawnInit.init();
        WeaponRegistry.init();
        ArmorRegistry.init();
        GunRegistry.init();
        OreGenerator.generateOres();
        LOGGER.info("Successfully registered SoulsWeapons content!");
        RecipeRegistry.init();
        LOGGER.info("Successfully registered recipes!");
        PacketRegistry.registerC2SPackets();
        FabricLoader.getInstance().getModContainer(ModId).ifPresent(modContainer -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960(ModId, "2d_weapons"), (ModContainer)modContainer, (class_2561)class_2561.method_43470((String)"2D Weapon Models"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            LOGGER.info("Successfully registered built-in 2D model resourcepack!");
        });
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ItemRegistry.registerItem(new TestItem(ModToolMaterials.MOONSTONE_OR_VERGLAS, 10, -2.4f, (class_1792.class_1793)new FabricItemSettings().fireproof().rarity(class_1814.field_8903)), "test_item");
        }
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)new class_2960(ModId, "general"), (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.soulsweapons.general")).method_47320(() -> new class_1799((class_1935)ItemRegistry.MOONSTONE)).method_47317((displayContext, entries) -> {
            for (class_1792 item : ITEM_GROUP_LIST) {
                entries.method_45421((class_1935)item);
            }
        }).method_47324());
        long end = System.currentTimeMillis();
        LOGGER.info("Initializing done, time taken: " + (end - start) + "ms");
    }

    static {
        ITEM_GROUP_LIST = new ArrayList();
    }
}

