/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.client.renderer.entity.mobs;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.soulsweaponry.client.model.entity.mobs.MoonknightModel;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.util.CustomDeathHandler;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MoonknightRenderer
extends GeoEntityRenderer<Moonknight> {
    int[] rgbColorOne = new int[]{254, 200, 203};
    int[] rgbColorTwo = new int[]{254, 254, 218};
    int[] rgbColorThree = new int[]{106, 73, 156};
    int[] rgbColorFour = new int[]{176, 253, 252};
    double[] translation = new double[]{0.0, 4.0, 0.0};
    public static final class_2960 CRYSTAL_BEAM_TEXTURE = new class_2960("soulsweapons", "textures/entity/core_beam.png");
    private static final class_1921 CRYSTAL_BEAM_LAYER = class_1921.method_23584((class_2960)CRYSTAL_BEAM_TEXTURE);

    public MoonknightRenderer(class_5617.class_5618 ctx) {
        super(ctx, (GeoModel)new MoonknightModel());
        this.field_4673 = 2.5f;
    }

    protected float getDeathMaxRotation(Moonknight entityLivingBaseIn) {
        return 0.0f;
    }

    public void render(Moonknight entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferIn, int packedLightIn) {
        super.method_3936((class_1297)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        CustomDeathHandler.renderDeathLight((class_1309)entity, entityYaw, partialTicks, stack, this.translation, bufferIn, packedLightIn, entity.deathTicks, this.rgbColorOne, this.rgbColorTwo, this.rgbColorThree, this.rgbColorFour);
        class_2338 blockPos = entity.getBeamLocation();
        if (entity.getCanBeam() && blockPos != null) {
            float yOffset = 4.0f;
            if (entity.getIncreasingBeamHeight()) {
                entity.setBeamHeight(0.0325f + entity.getBeamHeight());
            } else {
                entity.setBeamHeight(0.0f);
            }
            float m = (float)blockPos.method_10263() + 0.5f;
            float n = (float)blockPos.method_10264() + entity.getBeamHeight();
            float o = (float)blockPos.method_10260() + 0.5f;
            float p = (float)((double)m - entity.method_23317());
            float q = (float)((double)n - entity.method_23318());
            float r = (float)((double)o - entity.method_23321());
            stack.method_46416(p, q, r);
            MoonknightRenderer.renderCoreBeam(-p, -q + yOffset, -r, partialTicks, entity.field_6012, stack, bufferIn, packedLightIn);
        }
    }

    private static void renderCoreBeam(float dx, float dy, float dz, float tickDelta, int age, class_4587 matrices, class_4597 vertexConsumers, int light) {
        float xzLength = class_3532.method_15355((float)(dx * dx + dz * dz));
        float vecLength = class_3532.method_15355((float)(dx * dx + dy * dy + dz * dz));
        matrices.method_22903();
        matrices.method_46416(0.0f, 2.0f, 0.0f);
        matrices.method_22907(class_7833.field_40716.rotation((float)(-Math.atan2(dz, dx)) - 1.5707964f));
        matrices.method_22907(class_7833.field_40714.rotation((float)(-Math.atan2(xzLength, dy)) - 1.5707964f));
        class_4588 vertexConsumer = vertexConsumers.getBuffer(CRYSTAL_BEAM_LAYER);
        float h = 0.0f - ((float)age + tickDelta) * 0.01f;
        float i = vecLength / 32.0f - ((float)age + tickDelta) * 0.01f;
        float k = 0.0f;
        float l = 0.75f;
        float m = 0.0f;
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        Matrix3f matrix3f = entry.method_23762();
        for (int n = 1; n <= 8; ++n) {
            float o = class_3532.method_15374((float)((float)n * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float p = class_3532.method_15362((float)((float)n * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float q = (float)n / 8.0f;
            vertexConsumer.method_22918(matrix4f, k * 0.2f, l * 0.2f, 0.0f).method_1336(255, 255, 255, 255).method_22913(m, h).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrix3f, 0.0f, -1.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, k, l, vecLength).method_1336(255, 255, 255, 255).method_22913(m, i).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrix3f, 0.0f, -1.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, o, p, vecLength).method_1336(255, 255, 255, 255).method_22913(q, i).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrix3f, 0.0f, -1.0f, 0.0f).method_1344();
            vertexConsumer.method_22918(matrix4f, o * 0.2f, p * 0.2f, 0.0f).method_1336(255, 255, 255, 255).method_22913(q, h).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(matrix3f, 0.0f, -1.0f, 0.0f).method_1344();
            k = o;
            l = p;
            m = q;
        }
        matrices.method_22909();
    }
}

