/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2223;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8046;
import net.soulsweaponry.registry.EntityRegistry;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AreaEffectSphere
extends class_1297
implements class_8046 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<Float> RADIUS = class_2945.method_12791(AreaEffectSphere.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> WAITING = class_2945.method_12791(AreaEffectSphere.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2394> PARTICLE_ID = class_2945.method_12791(AreaEffectSphere.class, (class_2941)class_2943.field_13314);
    private final List<class_1293> effects = Lists.newArrayList();
    private final Map<class_1297, Integer> affectedEntities = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusGrowth;
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUuid;

    public AreaEffectSphere(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
    }

    public AreaEffectSphere(class_1937 world, double x, double y, double z) {
        this(EntityRegistry.AREA_EFFECT_SPHERE, world);
        this.method_5814(x, y, z);
    }

    protected void method_5693() {
        this.method_5841().method_12784(RADIUS, (Object)Float.valueOf(3.0f));
        this.method_5841().method_12784(WAITING, (Object)false);
        this.method_5841().method_12784(PARTICLE_ID, (Object)class_2398.field_11226);
    }

    public void setRadius(float radius) {
        if (!this.method_37908().field_9236) {
            this.method_5841().method_12778(RADIUS, (Object)Float.valueOf(class_3532.method_15363((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    public float getRadius() {
        return ((Float)this.method_5841().method_12789(RADIUS)).floatValue();
    }

    public void addEffect(class_1293 effect) {
        this.effects.add(effect);
    }

    public class_2394 getParticleType() {
        return (class_2394)this.method_5841().method_12789(PARTICLE_ID);
    }

    public void setParticleType(class_2394 particle) {
        this.method_5841().method_12778(PARTICLE_ID, (Object)particle);
    }

    protected void setWaiting(boolean waiting) {
        this.method_5841().method_12778(WAITING, (Object)waiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.method_5841().method_12789(WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void method_5773() {
        super.method_5773();
        boolean bl = this.isWaiting();
        float f = this.getRadius();
        if (this.method_37908().field_9236) {
            if (bl && this.field_5974.method_43056()) {
                return;
            }
            int points = class_3532.method_15375((float)(this.getRadius() * 6.7f));
            AreaEffectSphere.randomParticleBox(this.method_37908(), this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), points, this.getRadius() * 1.25f, this.getParticleType(), this.field_5974);
        } else {
            boolean bl2;
            if (this.field_6012 >= this.waitTime + this.duration) {
                this.method_31472();
                return;
            }
            boolean bl3 = bl2 = this.field_6012 < this.waitTime;
            if (bl != bl2) {
                this.setWaiting(bl2);
            }
            if (bl2) {
                return;
            }
            if (this.radiusGrowth != 0.0f) {
                if ((f += this.radiusGrowth) < 0.5f) {
                    this.method_31472();
                    return;
                }
                this.setRadius(f);
            }
            if (this.field_6012 % 5 == 0) {
                this.affectedEntities.entrySet().removeIf(entry -> this.field_6012 >= (Integer)entry.getValue());
                ArrayList list = Lists.newArrayList();
                list.addAll(this.effects);
                if (list.isEmpty()) {
                    this.affectedEntities.clear();
                } else {
                    List list2 = this.method_37908().method_18467(class_1309.class, this.method_5829());
                    if (!list2.isEmpty()) {
                        Iterator var27 = list2.iterator();
                        while (true) {
                            double r;
                            double q;
                            double s;
                            if (!var27.hasNext()) {
                                return;
                            }
                            class_1309 livingEntity = (class_1309)var27.next();
                            if (this.affectedEntities.containsKey(livingEntity) || !livingEntity.method_6086() || !((s = (q = livingEntity.method_23317() - this.method_23317()) * q + (r = livingEntity.method_23321() - this.method_23321()) * r) <= (double)(f * f))) continue;
                            this.affectedEntities.put((class_1297)livingEntity, this.field_6012 + this.reapplicationDelay);
                            for (class_1293 statusEffectInstance2 : list) {
                                if (statusEffectInstance2.method_5579().method_5561()) {
                                    statusEffectInstance2.method_5579().method_5564((class_1297)this, (class_1297)this.getOwner(), livingEntity, statusEffectInstance2.method_5578(), 0.5);
                                    continue;
                                }
                                livingEntity.method_37222(new class_1293(statusEffectInstance2), (class_1297)this);
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((f += this.radiusOnUse) < 0.5f) {
                                    this.method_31472();
                                    return;
                                }
                                this.setRadius(f);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration <= 0) break;
                        }
                        this.method_31472();
                        return;
                    }
                }
            }
        }
    }

    public static void randomParticleBox(class_1937 world, double x, double y, double z, double points, float sizeModifier, class_2394 particle, class_5819 random) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            world.method_8466(particle, true, x + velocityX * (double)sizeModifier + random.method_43059(), y + velocityY * (double)sizeModifier + random.method_43059(), z + velocityZ * (double)sizeModifier + random.method_43059(), 0.0, 0.0, 0.0);
            ++i;
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public float getRadiusGrowth() {
        return this.radiusGrowth;
    }

    public void setRadiusGrowth(float radiusGrowth) {
        this.radiusGrowth = radiusGrowth;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int durationOnUse) {
        this.durationOnUse = durationOnUse;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public class_1309 getOwner() {
        class_1297 entity;
        if (this.owner == null && this.ownerUuid != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUuid)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    protected void method_5749(class_2487 nbt) {
        this.field_6012 = nbt.method_10550("Age");
        this.duration = nbt.method_10550("Duration");
        this.waitTime = nbt.method_10550("WaitTime");
        this.reapplicationDelay = nbt.method_10550("ReapplicationDelay");
        this.durationOnUse = nbt.method_10550("DurationOnUse");
        this.radiusOnUse = nbt.method_10583("RadiusOnUse");
        this.radiusGrowth = nbt.method_10583("RadiusPerTick");
        this.setRadius(nbt.method_10583("Radius"));
        if (nbt.method_25928("Owner")) {
            this.ownerUuid = nbt.method_25926("Owner");
        }
        if (nbt.method_10573("Particle", 8)) {
            try {
                this.setParticleType(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("Particle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("Particle"), (Object)var5);
            }
        }
        if (nbt.method_10573("Effects", 9)) {
            class_2499 nbtList = nbt.method_10554("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < nbtList.size(); ++i) {
                class_1293 statusEffectInstance = class_1293.method_5583((class_2487)nbtList.method_10602(i));
                if (statusEffectInstance == null) continue;
                this.addEffect(statusEffectInstance);
            }
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("Age", this.field_6012);
        nbt.method_10569("Duration", this.duration);
        nbt.method_10569("WaitTime", this.waitTime);
        nbt.method_10569("ReapplicationDelay", this.reapplicationDelay);
        nbt.method_10569("DurationOnUse", this.durationOnUse);
        nbt.method_10548("RadiusOnUse", this.radiusOnUse);
        nbt.method_10548("RadiusPerTick", this.radiusGrowth);
        nbt.method_10548("Radius", this.getRadius());
        nbt.method_10582("Particle", this.getParticleType().method_10293());
        if (this.ownerUuid != null) {
            nbt.method_25927("Owner", this.ownerUuid);
        }
        if (!this.effects.isEmpty()) {
            class_2499 nbtList = new class_2499();
            for (class_1293 statusEffectInstance : this.effects) {
                nbtList.add((Object)statusEffectInstance.method_5582(new class_2487()));
            }
            nbt.method_10566("Effects", (class_2520)nbtList);
        }
    }

    public void method_5674(class_2940<?> data) {
        if (RADIUS.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 2.0f));
    }
}

