/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.FreyrSwordEntity;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.util.CustomDamageSource;

public class FreyrSwordGoal
extends class_1352 {
    private final FreyrSwordEntity entity;
    private int attackTicks;
    private final double[][] hitFrames = new double[][]{{6.0, 1.0}, {13.0, 1.0}, {20.0, 1.1}, {29.0, 1.25}};
    private final double animationFrameCap = 3.5;

    public FreyrSwordGoal(FreyrSwordEntity entity) {
        this.entity = entity;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.entity.method_5968();
        return this.entity.method_35057() != null && target != null && target.method_5805() && this.entity.method_18395(target);
    }

    public boolean method_6266() {
        if (this.entity.method_35057() != null && this.entity.method_5968() != null) {
            if (!this.entity.isBlockPosNullish(this.entity.getStationaryPos()) && this.entity.method_5858((class_1297)this.entity.method_5968()) > this.entity.getFollowRange()) {
                this.method_6270();
                return false;
            }
            if (this.entity.method_35057().method_5858((class_1297)this.entity.method_5968()) > this.entity.getFollowRange()) {
                this.method_6270();
                return false;
            }
        }
        return super.method_6266();
    }

    public void method_6270() {
        super.method_6270();
        this.entity.setAnimationAttacking(false);
        this.attackTicks = 0;
        this.entity.method_5980(null);
    }

    public void method_6268() {
        class_1309 target = this.entity.method_5968();
        if (target != null) {
            this.attackTarget(target, this.entity.method_37908());
        }
    }

    private void attackTarget(class_1309 target, class_1937 world) {
        ++this.attackTicks;
        if ((double)this.attackTicks >= this.animationFrameCap * 10.0) {
            this.attackTicks = 0;
        }
        this.entity.method_5988().method_35111((class_1297)target);
        class_243 vecTarget = this.entity.method_5720().method_1019(target.method_19538());
        this.entity.method_30634(vecTarget.method_10216(), vecTarget.method_10214(), vecTarget.method_10215());
        this.entity.setAnimationAttacking(true);
        for (double[] hitFrame : this.hitFrames) {
            if ((double)this.attackTicks != hitFrame[0] || !target.method_5643(CustomDamageSource.create(this.entity.method_37908(), CustomDamageSource.FREYR_SWORD, (class_1297)this.entity, (class_1297)this.entity.method_35057()), (float)((double)this.getAttackDamage(target) * hitFrame[1]))) continue;
            int fire = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)this.entity.asItemStack());
            if (fire > 0) {
                target.method_5639(fire * 4);
            }
            if (!world.field_9236) {
                ParticleHandler.singleParticle(this.entity.method_37908(), (class_2394)class_2398.field_11227, target.method_23317(), target.method_23320(), target.method_23321(), 0.0, 0.0, 0.0);
            } else {
                world.method_8466((class_2394)class_2398.field_11227, true, target.method_23317(), target.method_23320(), target.method_23321(), 0.0, 0.0, 0.0);
            }
            world.method_8396(null, this.entity.method_24515(), class_3417.field_14706, class_3419.field_15254, 0.8f, 1.0f);
        }
    }

    public float getAttackDamage(class_1309 target) {
        return target != null ? (float)ConfigConstructor.sword_of_freyr_damage + class_1890.method_8218((class_1799)this.entity.asItemStack(), (class_1310)target.method_6046()) : (float)ConfigConstructor.sword_of_freyr_damage;
    }
}

