/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import org.jetbrains.annotations.Nullable;

public class MoonknightGoal
extends class_1352 {
    private final Moonknight boss;
    private int attackStatus;
    private int attackCooldown;
    private int specialCooldown;
    private int targetNotVisibleTicks;
    private class_2338 targetPos;
    private float yaw;
    private MoonlightProjectile.RotationState projectileRotation = MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT;
    private float bonusBeamHeight = 0.0f;
    private double height = 0.0;
    private class_2338 pos;

    public MoonknightGoal(Moonknight boss) {
        this.boss = boss;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.boss.method_5968();
        return target != null && target.method_5805() && this.boss.method_18395(target);
    }

    public float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.fallen_icon_damage_modifier;
    }

    private void resetAttack(float attackCDModifier, boolean wasSpecial, float specialCDModifier) {
        if (!this.boss.isPhaseTwo()) {
            this.checkAttackPhaseOne(Moonknight.MoonknightPhaseOne.IDLE, this.boss.method_5968());
        } else {
            this.checkAttackPhaseTwo(Moonknight.MoonknightPhaseTwo.IDLE, this.boss.method_5968());
        }
        this.attackStatus = 0;
        this.attackCooldown = (int)Math.floor((float)(this.boss.isPhaseTwo() ? ConfigConstructor.fallen_icon_attack_cooldown_ticks_phase_2 : ConfigConstructor.fallen_icon_attack_cooldown_ticks_phase_1) * attackCDModifier) - this.boss.getReducedCooldownAttackers() * 2;
        if (wasSpecial) {
            this.specialCooldown = (int)Math.floor((float)ConfigConstructor.fallen_icon_special_cooldown_ticks * specialCDModifier) - this.boss.getReducedCooldownAttackers() * 2;
        }
    }

    private void reset() {
        this.attackCooldown = 0;
        this.attackStatus = 0;
        this.specialCooldown = 0;
        this.bonusBeamHeight = 0.0f;
        this.projectileRotation = MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT;
        this.boss.setCanBeam(false);
        this.boss.setIncreasingBeamHeight(false);
        this.boss.setBeamHeight(0.0f);
    }

    public void method_6270() {
        super.method_6270();
        this.reset();
        this.boss.method_19540(false);
        if (this.boss.isPhaseTwo()) {
            this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
        } else {
            this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
        }
    }

    private Moonknight.MoonknightPhaseOne randomAttackPhaseOne() {
        int rand = this.boss.method_6051().method_43048(Moonknight.MoonknightPhaseOne.values().length);
        Moonknight.MoonknightPhaseOne attack = Moonknight.MoonknightPhaseOne.values()[rand];
        if (attack.equals((Object)Moonknight.MoonknightPhaseOne.IDLE)) {
            return this.randomAttackPhaseOne();
        }
        return attack;
    }

    private Moonknight.MoonknightPhaseTwo randomAttackPhaseTwo() {
        int rand = this.boss.method_6051().method_43048(Moonknight.MoonknightPhaseTwo.values().length);
        Moonknight.MoonknightPhaseTwo attack = Moonknight.MoonknightPhaseTwo.values()[rand];
        if (attack.equals((Object)Moonknight.MoonknightPhaseTwo.IDLE)) {
            return this.randomAttackPhaseTwo();
        }
        return attack;
    }

    private void checkAttackPhaseOne(@Nullable Moonknight.MoonknightPhaseOne specificPhaseOne, class_1309 target) {
        if (target == null || specificPhaseOne != null && specificPhaseOne.equals((Object)Moonknight.MoonknightPhaseOne.IDLE)) {
            this.boss.setPhaseOneAttack(specificPhaseOne);
            return;
        }
        Moonknight.MoonknightPhaseOne attack = Objects.requireNonNullElseGet(specificPhaseOne, this::randomAttackPhaseOne);
        double distance = this.boss.method_5858((class_1297)target);
        switch (attack) {
            case BLINDING_LIGHT: {
                if (distance < 30.0) {
                    this.boss.setPhaseOneAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                break;
            }
            case MACE_OF_SPADES: {
                if (distance < 50.0 && target.method_24515() != null) {
                    this.boss.setPhaseOneAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                break;
            }
            case OBLITERATE: {
                if (distance < 75.0 && target.method_24515() != null) {
                    this.boss.setPhaseOneAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                break;
            }
            case RUPTURE: 
            case SUMMON: {
                if (this.specialCooldown < 0) {
                    this.boss.setPhaseOneAttack(attack);
                    break;
                }
                if (this.specialCooldown <= 20) break;
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                break;
            }
            default: {
                this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
            }
        }
    }

    private void checkAttackPhaseTwo(@Nullable Moonknight.MoonknightPhaseTwo specificPhaseTwo, class_1309 target) {
        if (target == null || specificPhaseTwo != null && specificPhaseTwo.equals((Object)Moonknight.MoonknightPhaseTwo.IDLE)) {
            this.boss.setPhaseTwoAttack(specificPhaseTwo);
            return;
        }
        Moonknight.MoonknightPhaseTwo attack = Objects.requireNonNullElseGet(specificPhaseTwo, this::randomAttackPhaseTwo);
        double distance = this.boss.method_5858((class_1297)target);
        switch (attack) {
            case BLINDING_LIGHT: {
                if (distance < 32.0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            case CORE_BEAM: {
                if (this.specialCooldown < 0 && distance < 180.0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.specialCooldown <= 10 && this.attackCooldown >= -30) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            case MOONFALL: {
                if (distance < 80.0 && target.method_24515() != null) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            case MOONVEIL: {
                if (distance < 36.0 && this.specialCooldown < 0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.specialCooldown <= 10 && this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            case SWORD_OF_LIGHT: {
                if (distance < 300.0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.SWORD_OF_LIGHT);
                break;
            }
            case THRUST: {
                if (distance < 128.0) {
                    this.boss.setPhaseTwoAttack(attack);
                    break;
                }
                if (this.attackCooldown >= -10) break;
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                break;
            }
            default: {
                this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
            }
        }
    }

    public void method_6268() {
        --this.attackCooldown;
        --this.specialCooldown;
        class_1309 target = this.boss.method_5968();
        if (this.boss.isInitiatingPhaseTwo()) {
            this.reset();
        }
        if (!(target == null || this.boss.method_29504() || this.boss.getSpawning() || this.boss.isInitiatingPhaseTwo() || this.boss.getUnbreakable())) {
            this.boss.method_19540(true);
            this.boss.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
            boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
            this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
            if (this.attackCooldown > 0) {
                if (!this.boss.isPhaseTwo()) {
                    this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                } else {
                    this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                }
            } else if (this.attackCooldown < 0 && this.attackCooldown % 5 == 0) {
                if (!this.boss.isPhaseTwo() && this.boss.getPhaseOneAttack().equals((Object)Moonknight.MoonknightPhaseOne.IDLE)) {
                    this.checkAttackPhaseOne(null, target);
                } else if (this.boss.getPhaseTwoAttack().equals((Object)Moonknight.MoonknightPhaseTwo.IDLE)) {
                    this.checkAttackPhaseTwo(null, target);
                }
            }
            if (!this.boss.isPhaseTwo()) {
                switch (this.boss.getPhaseOneAttack()) {
                    case BLINDING_LIGHT: {
                        this.blindingLightLogic();
                        break;
                    }
                    case MACE_OF_SPADES: {
                        this.maceOfSpadesLogic(target);
                        break;
                    }
                    case OBLITERATE: {
                        this.obliterateLogic(target, 13, 3, 28, 50.0f, SoundRegistry.NIGHTFALL_BONK_EVENT, false);
                        break;
                    }
                    case RUPTURE: {
                        this.ruptureLogic();
                        break;
                    }
                    case SUMMON: {
                        this.summonLogic(target);
                        break;
                    }
                    default: {
                        this.boss.setPhaseOneAttack(Moonknight.MoonknightPhaseOne.IDLE);
                        break;
                    }
                }
            } else {
                switch (this.boss.getPhaseTwoAttack()) {
                    case BLINDING_LIGHT: {
                        this.blindingLightLogic();
                        break;
                    }
                    case CORE_BEAM: {
                        this.coreBeam(target);
                        break;
                    }
                    case MOONFALL: {
                        this.moonfallLogic(target);
                        break;
                    }
                    case MOONVEIL: {
                        this.moonveilLogic();
                        break;
                    }
                    case SWORD_OF_LIGHT: {
                        this.swordOfLight(target);
                        break;
                    }
                    case THRUST: {
                        this.thrustLogic(target);
                        break;
                    }
                    default: {
                        this.boss.setPhaseTwoAttack(Moonknight.MoonknightPhaseTwo.IDLE);
                    }
                }
            }
            if (this.targetNotVisibleTicks < 5) {
                this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
            }
        }
        super.method_6268();
    }

    private void coreBeam(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus == 1) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14880, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus < 20 && target.method_24515() != null) {
            this.targetPos = target.method_24515();
        }
        if (this.targetPos != null) {
            this.boss.method_5988().method_20248((double)this.targetPos.method_10263(), (double)((float)this.targetPos.method_10264() + this.bonusBeamHeight), (double)this.targetPos.method_10260());
            this.boss.method_5942().method_6337((double)this.targetPos.method_10263(), (double)((float)this.targetPos.method_10264() + this.bonusBeamHeight), (double)this.targetPos.method_10260(), 0.0);
            this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
            if (this.attackStatus >= 21 && this.attackStatus <= 47) {
                if (this.attackStatus == 21) {
                    this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.KNIGHT_CORE_BEAM_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                }
                this.boss.setCanBeam(true);
                this.boss.setBeamLocation(this.targetPos);
                if (this.attackStatus % 2 == 0) {
                    this.boss.method_37908().method_8454((class_1297)this.boss, CustomDamageSource.create(this.boss.method_37908(), CustomDamageSource.BEAM, (class_1297)this.boss), null, (double)this.targetPos.method_10263(), (double)((float)this.targetPos.method_10264() + this.bonusBeamHeight), (double)this.targetPos.method_10260(), 2.0f, true, this.boss.method_37908().method_8450().method_8355(class_1928.field_19388) ? class_1937.class_7867.field_40891 : class_1937.class_7867.field_40888);
                    for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(this.targetPos, this.boss.method_24515().method_10069(0, 4, 0)))) {
                        if (!(entity instanceof class_1309)) continue;
                        entity.method_5643(CustomDamageSource.create(this.boss.method_37908(), CustomDamageSource.BEAM, (class_1297)this.boss), this.getModifiedDamage(20.0f));
                        entity.method_5639(4);
                    }
                }
                if (this.attackStatus >= 26) {
                    this.bonusBeamHeight += 0.65f;
                    this.boss.setIncreasingBeamHeight(true);
                }
            }
            if (this.attackStatus > 40) {
                this.targetPos = this.targetPos.method_10069(0, class_3532.method_15375((float)(-this.bonusBeamHeight)), 0);
                this.boss.setCanBeam(false);
                this.boss.setIncreasingBeamHeight(false);
            }
        }
        if (this.attackStatus >= 77) {
            this.boss.method_5942().method_6340();
            this.bonusBeamHeight = 0.0f;
            this.boss.setBeamHeight(0.0f);
            this.resetAttack(1.0f, true, 1.0f);
        }
    }

    private void swordOfLight(class_1309 target) {
        ++this.attackStatus;
        double distance = this.boss.method_5858((class_1297)target);
        if (target.method_24515() != null) {
            if (distance < 65.0) {
                this.targetPos = target.method_24515();
            } else {
                class_243 direction = new class_243(target.method_23317() - (double)this.boss.method_31477(), 0.0, target.method_23321() - (double)this.boss.method_31479()).method_1021(0.5);
                class_243 spot = new class_243(this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321()).method_1019(direction);
                this.targetPos = class_2338.method_49638((class_2374)spot);
            }
        }
        if (this.targetPos != null && target.method_19538() != null) {
            MoonlightProjectile projectile;
            double x = target.method_23317() - this.boss.method_23317();
            double y = target.method_23320() - this.boss.method_23323(1.0);
            double z = target.method_23321() - this.boss.method_23321();
            this.boss.method_5988().method_20248((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260());
            this.boss.method_5942().method_6337((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260(), 0.0);
            this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
            if (this.attackStatus == 8 || this.attackStatus == 15 || this.attackStatus == 20 || this.attackStatus == 25) {
                this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14706, class_3419.field_15251, 1.0f, 0.75f);
                for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(this.targetPos).method_1014(3.0))) {
                    if (!(entity instanceof class_1309)) continue;
                    entity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(25.0f));
                    ((class_1309)entity).method_6005(2.0, -(entity.method_23317() - this.boss.method_23317()), -(entity.method_23321() - this.boss.method_23321()));
                }
                this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.MOONLIGHT_BIG_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                projectile = new MoonlightProjectile(EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE, this.boss.method_37908(), (class_1309)this.boss);
                projectile.setAgeAndPoints(30, 150, 4);
                projectile.method_7438(this.getModifiedDamage(25.0f));
                projectile.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
                projectile.method_7485(x, y, z, 1.5f, 1.0f);
                projectile.setRotateState(this.projectileRotation);
                this.projectileRotation = Objects.requireNonNull(this.projectileRotation) == MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT ? MoonlightProjectile.RotationState.SWIPE_FROM_LEFT : MoonlightProjectile.RotationState.NORMAL;
                this.boss.method_37908().method_8649((class_1297)projectile);
            }
            if (this.attackStatus == 27) {
                this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.KNIGHT_SWORD_SMASH_EVENT, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.attackStatus == 31) {
                this.smashGround(30.0f, SoundRegistry.KNIGHT_SWORD_SMASH_EVENT, true);
                this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.MOONLIGHT_BIG_EVENT, class_3419.field_15251, 1.0f, 0.75f);
                projectile = new MoonlightProjectile(EntityRegistry.VERTICAL_MOONLIGHT_ENTITY_TYPE, this.boss.method_37908(), (class_1309)this.boss);
                projectile.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
                projectile.method_7485(x, y, z, 1.5f, 1.0f);
                projectile.method_7438(this.getModifiedDamage(40.0f));
                projectile.setHugeExplosion(true);
                projectile.setAgeAndPoints(30, 75, 10);
                this.boss.method_37908().method_8649((class_1297)projectile);
            }
        }
        if (this.attackStatus >= 37) {
            this.boss.method_5942().method_6340();
            this.projectileRotation = MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT;
            this.resetAttack(1.0f, false, 1.0f);
        }
    }

    private void thrustLogic(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus == 1) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.KNIGHT_CHARGE_SWORD_EVENT, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus < 1) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14880, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus < 13 && target.method_24515() != null) {
            this.targetPos = target.method_24515();
            this.height = target.method_23320();
        } else if (this.targetPos != null) {
            this.boss.method_5988().method_20248((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260());
            this.boss.method_5942().method_6337((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260(), 0.0);
            this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
            if (this.attackStatus == 15) {
                this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.KNIGHT_THRUST_SWORD_EVENT, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.attackStatus == 17 && this.boss.method_5858((class_1297)target) < 128.0) {
                for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(this.targetPos).method_1014(1.0))) {
                    if (!(entity instanceof class_1309)) continue;
                    entity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(50.0f));
                    ((class_1309)entity).method_6092(new class_1293(class_1294.field_5901, 200, 1));
                    ((class_1309)entity).method_6092(new class_1293(class_1294.field_5909, 200, 1));
                    ((class_1309)entity).method_6092(new class_1293(EffectRegistry.DISABLE_HEAL, 100, 0));
                }
                if (!this.boss.method_37908().field_9236) {
                    ParticleHandler.particleOutburstMap(this.boss.method_37908(), 250, this.targetPos.method_10263(), this.height == 0.0 ? (double)this.targetPos.method_10264() : this.height, this.targetPos.method_10260(), ParticleEvents.SOUL_FLAME_SMALL_OUTBURST_MAP, 1.0f);
                }
            }
        }
        if (this.attackStatus >= 23) {
            this.boss.method_5942().method_6340();
            this.resetAttack(0.75f, false, 1.0f);
        }
    }

    private void moonfallLogic(class_1309 target) {
        this.obliterateLogic(target, 25, 15, 43, 65.0f, SoundRegistry.KNIGHT_SWORD_SMASH_EVENT, true);
        if (this.attackStatus == 18) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.KNIGHT_SWORD_SMASH_EVENT, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus == 1) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.KNIGHT_CHARGE_SWORD_EVENT, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus == 26) {
            float yaw = (this.yaw == 0.0f ? this.boss.method_5791() : this.yaw) + 90.0f;
            WeaponRegistry.HOLY_MOONLIGHT_GREATSWORD.castSpell((class_1309)this.boss, this.boss.method_37908(), WeaponRegistry.HOLY_MOONLIGHT_GREATSWORD.method_7854(), this.targetPos.method_46558(), 14, this.getModifiedDamage(30.0f), 1.0f, yaw, 1.5f, 3.5f);
        }
    }

    private void moonveilLogic() {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 40, 5));
        if (this.attackStatus == 29 || this.attackStatus == 42) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(3.0))) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                double x = livingEntity.method_23317() - this.boss.method_23317();
                double z = livingEntity.method_23321() - this.boss.method_23321();
                livingEntity.method_6005(10.0, -x, -z);
                livingEntity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(50.0f));
            }
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleSphereList(this.boss.method_37908(), 1000, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), 1.0f, new class_2394[]{class_2398.field_22246, class_2398.field_11237});
            }
        }
        if (this.attackStatus >= 55) {
            this.resetAttack(1.2f, true, 1.0f);
        }
    }

    private void smashGround(float damage, class_3414 sound, boolean isSoundDelayed) {
        for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(this.targetPos).method_1014(3.0))) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 living = (class_1309)entity;
            entity.method_5643(CustomDamageSource.create(this.boss.method_37908(), CustomDamageSource.OBLITERATED, (class_1297)this.boss), this.getModifiedDamage(damage));
            entity.method_5762(0.0, 1.0, 0.0);
            if (!living.method_5999() || !living.method_29504()) continue;
            this.summonRemnant(living.method_19538());
        }
        if (!isSoundDelayed) {
            this.boss.method_37908().method_8396(null, this.targetPos, sound, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (!this.boss.method_37908().field_9236) {
            ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, this.targetPos.method_10263(), this.targetPos.method_10264(), this.targetPos.method_10260(), ParticleEvents.OBLITERATE_MAP, 1.0f);
        }
    }

    private void summonRemnant(class_243 pos) {
        Remnant entity = new Remnant(EntityRegistry.REMNANT, this.boss.method_37908());
        if (this.canSummon()) {
            entity.method_23327(pos.method_10216(), pos.method_10214() + (double)0.1f, pos.method_10215());
        }
        this.initEquip((class_1309)entity);
        this.boss.method_37908().method_8396(null, entity.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15251, 1.0f, 1.0f);
        this.boss.method_37908().method_8649((class_1297)entity);
        if (!this.boss.method_37908().field_9236) {
            ParticleHandler.particleOutburstMap(this.boss.method_37908(), 100, pos.method_10216(), pos.method_10214(), pos.method_10215(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
        }
    }

    private void obliterateLogic(class_1309 target, int hitFrame, int followTargetTicks, int attackFinishedTicks, float damage, class_3414 sound, boolean isSoundDelayed) {
        ++this.attackStatus;
        if (this.attackStatus < followTargetTicks && target.method_24515() != null) {
            this.targetPos = target.method_24515();
        } else if (this.targetPos != null) {
            this.boss.method_5988().method_20248((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260());
            this.boss.method_5942().method_6337((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260(), 0.0);
            this.yaw = this.boss.method_5791();
            this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
            if (this.attackStatus == hitFrame) {
                this.smashGround(damage, sound, isSoundDelayed);
            }
            if (this.attackStatus >= attackFinishedTicks) {
                this.boss.method_5942().method_6340();
                this.resetAttack(1.0f, false, 1.0f);
            }
        }
    }

    private void maceOfSpadesLogic(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus < 3 && target.method_24515() != null) {
            this.targetPos = target.method_24515();
        } else if (this.targetPos != null) {
            class_1309 livingEntity;
            this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
            this.boss.method_5988().method_20248((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260());
            this.boss.method_5942().method_6337((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260(), 0.0);
            if (this.attackStatus == 7) {
                for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238((double)(this.targetPos.method_10263() - 5), (double)(this.targetPos.method_10264() - 2), (double)(this.targetPos.method_10260() - 5), (double)(this.targetPos.method_10263() + 5), (double)(this.targetPos.method_10264() + 2), (double)(this.targetPos.method_10260() + 5)))) {
                    if (!(entity instanceof class_1309)) continue;
                    livingEntity = (class_1309)entity;
                    livingEntity.method_6005(2.0, -(livingEntity.method_23317() - this.boss.method_23317()), -(livingEntity.method_23321() - this.boss.method_23321()));
                    livingEntity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(20.0f));
                }
                this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.KNIGHT_SWIPE_EVENT, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.attackStatus == 13 && target.method_24515() != null) {
                this.targetPos = target.method_24515();
            }
            if (this.attackStatus == 21 && this.targetPos != null) {
                for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(this.targetPos).method_1014(3.0))) {
                    if (!(entity instanceof class_1309)) continue;
                    livingEntity = (class_1309)entity;
                    livingEntity.method_5762(0.0, 1.0, 0.0);
                    livingEntity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(25.0f));
                }
                this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.NIGHTFALL_BONK_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                if (!this.boss.method_37908().field_9236) {
                    ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, this.targetPos.method_10263(), this.targetPos.method_10264(), this.targetPos.method_10260(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                }
            }
            if (this.attackStatus >= 36) {
                this.boss.method_5942().method_6340();
                this.resetAttack(1.0f, false, 1.0f);
            }
        }
    }

    private void ruptureLogic() {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
        if (this.attackStatus == 21 || this.attackStatus == 33) {
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(12.0))) {
                this.boss.method_37908().method_8396(null, entity.method_24515(), class_3417.field_14562, class_3419.field_15251, 1.0f, 1.0f);
            }
        }
        if (this.attackStatus == 52) {
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(12.0))) {
                Remnant remnant;
                if (!(entity instanceof class_1309) || entity instanceof Remnant && (remnant = (Remnant)entity).method_6171((class_1309)this.boss)) continue;
                entity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(35.0f));
                this.boss.method_37908().method_8396(null, entity.method_24515(), class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
                entity.method_5762(0.0, 1.0, 0.0);
                if (this.boss.method_37908().field_9236) continue;
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, entity.method_23317(), entity.method_23318(), entity.method_23321(), ParticleEvents.GROUND_RUPTURE_MAP, 1.0f);
            }
        }
        if (this.attackStatus >= 70) {
            this.resetAttack(0.5f, true, 1.0f);
        }
    }

    private void blindingLightLogic() {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
        if (this.attackStatus < 1) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14880, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus == 9) {
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), ParticleEvents.BLINDING_LIGHT_SMASH_MAP, 1.0f);
            }
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.BLINDING_LIGHT_EXPLOSION_EVENT, class_3419.field_15251, 1.0f, 1.0f);
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(3.0))) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                living.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(20.0f));
                living.method_6005(3.0, -living.method_23317() - this.boss.method_23317(), -living.method_23321() - this.boss.method_23321());
                living.method_6092(new class_1293(class_1294.field_5919, 100, 0));
                living.method_6092(new class_1293(class_1294.field_5909, 100, 1));
            }
            if (this.boss.isPhaseTwo()) {
                int r = 3;
                int y = this.boss.method_24515().method_10264() + 1;
                for (int theta = 0; theta < 360; theta += 15) {
                    double x0 = this.boss.method_23317();
                    double z0 = this.boss.method_23321();
                    double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                    double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                    MoonlightProjectile projectile = new MoonlightProjectile(EntityRegistry.MOONLIGHT_ENTITY_TYPE, this.boss.method_37908());
                    projectile.setAgeAndPoints(15, 30, 1);
                    projectile.method_23327(x, y, z);
                    projectile.method_24919((class_1297)this.boss, 0.0f, theta, 0.0f, 1.5f, 0.0f);
                    projectile.method_7438(this.getModifiedDamage(15.0f));
                    this.boss.method_37908().method_8649((class_1297)projectile);
                }
            }
        }
        if (this.attackStatus >= 24) {
            this.resetAttack(0.5f, false, 1.0f);
        }
    }

    private void summonLogic(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
        if (this.attackStatus == 30) {
            int enemyNumber = this.boss.method_6051().method_43048(3) + 3;
            for (int j = 0; j < enemyNumber; ++j) {
                Remnant entity = new Remnant(EntityRegistry.REMNANT, this.boss.method_37908());
                this.pos = new class_2338(this.boss.method_31477() + this.boss.method_6051().method_43048(20) - 10, this.boss.method_31478() - 2, this.boss.method_31479() + this.boss.method_6051().method_43048(20) - 10);
                if (this.canSummon()) {
                    entity.method_23327(this.pos.method_10263(), (float)this.pos.method_10264() + 0.1f, this.pos.method_10260());
                }
                this.initEquip((class_1309)entity);
                this.boss.method_37908().method_8396(null, entity.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                this.boss.method_37908().method_8649((class_1297)entity);
                if (this.boss.method_37908().field_9236) continue;
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 100, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
            }
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, target.method_23317(), target.method_23318(), target.method_23321(), ParticleEvents.GROUND_RUPTURE_MAP, 1.0f);
            }
            target.method_6092(new class_1293(class_1294.field_5909, 140, 1));
            this.boss.method_37908().method_8396(null, target.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15251, 0.7f, 1.0f);
        }
        if (this.attackStatus >= 48) {
            this.resetAttack(1.0f, true, 2.0f);
        }
    }

    public boolean canSummon() {
        if (!this.boss.method_37908().method_8320(this.pos).method_26215()) {
            this.pos = new class_2338(this.pos.method_10263(), this.pos.method_10264() + 1, this.pos.method_10260());
            this.canSummon();
        }
        return true;
    }

    private void initEquip(class_1309 entity) {
        HashMap<class_1799, class_1304> equip = new HashMap<class_1799, class_1304>();
        equip.put(new class_1799((class_1935)class_1802.field_22027), class_1304.field_6169);
        equip.put(new class_1799((class_1935)class_1802.field_22028), class_1304.field_6174);
        equip.put(new class_1799((class_1935)class_1802.field_22029), class_1304.field_6172);
        equip.put(new class_1799((class_1935)class_1802.field_22030), class_1304.field_6166);
        for (class_1799 stack : equip.keySet()) {
            stack.method_7978(class_1893.field_9111, 2);
            stack.method_7978(class_1893.field_9109, 1);
            entity.method_5673((class_1304)equip.get(stack), stack);
        }
        entity.method_6033(entity.method_6063() * 1.5f);
    }
}

