/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DarkSorcerer;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.ReturningKnight;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;

public class ReturningKnightGoal
extends class_1352 {
    private final ReturningKnight boss;
    private int targetNotVisibleTicks;
    private boolean hasUsedUnbreakable;
    private int unbreakableTimer;
    private int attackCooldown;
    private class_2338 targetPos;
    private boolean cordsRegistered;
    private int attackStatus;
    private int specialCooldown;
    int randomAttack = 3;
    private class_2338 pos;
    private final int numberOfAttacks = 6;

    public ReturningKnightGoal(ReturningKnight boss) {
        this.boss = boss;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.boss.method_5968();
        return target != null && target.method_5805() && this.boss.method_18395(target);
    }

    public void resetAttackCooldown(float cooldownModifier) {
        this.attackCooldown = (int)Math.floor((float)ConfigConstructor.returning_knight_attack_cooldown_ticks * cooldownModifier) - this.boss.getReducedCooldownAttackers() * 2;
    }

    public void resetSpecialCooldown(float cooldownModifier) {
        this.specialCooldown = (int)Math.floor((float)ConfigConstructor.returning_knight_special_cooldown_ticks * cooldownModifier) - this.boss.getReducedCooldownAttackers() * 2;
    }

    public float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.returning_knight_damage_modifier;
    }

    public boolean canSummon() {
        if (!this.boss.method_37908().method_8320(this.pos).method_26215()) {
            this.pos = new class_2338(this.pos.method_10263(), this.pos.method_10264() + 1, this.pos.method_10260());
            this.canSummon();
        }
        return true;
    }

    public void method_6270() {
        super.method_6270();
        this.boss.method_19540(false);
        this.boss.setObliterate(false);
        this.boss.setBlind(false);
        this.boss.setRupture(false);
        this.boss.setSummon(false);
        this.boss.setMaceOfSpades(false);
        this.attackCooldown = 10;
        this.attackStatus = 0;
        this.cordsRegistered = false;
    }

    public void method_6268() {
        --this.attackCooldown;
        --this.unbreakableTimer;
        --this.specialCooldown;
        class_1309 target = this.boss.method_5968();
        if (target != null && !this.boss.getSpawning()) {
            this.boss.method_19540(true);
            this.boss.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
            boolean entityInSight = this.boss.method_5985().method_6369((class_1297)target);
            double distanceToEntity = this.boss.method_5858((class_1297)target);
            this.targetNotVisibleTicks = entityInSight ? 0 : ++this.targetNotVisibleTicks;
            if (this.boss.method_6032() <= this.boss.method_6063() / 2.0f && !this.hasUsedUnbreakable && this.attackCooldown > 20) {
                this.hasUsedUnbreakable = true;
                this.unbreakableTimer = 38;
                this.boss.setUnbreakable(true);
                this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 40));
            } else if (this.unbreakableTimer == 19) {
                this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.NIGHTFALL_SHIELD_EVENT, class_3419.field_15251, 0.75f, 1.0f);
            }
            if (this.unbreakableTimer < 0) {
                this.boss.setUnbreakable(false);
                this.unbreakableTimer = -5;
            }
            if (this.attackCooldown < 0 && this.specialCooldown < 0 && this.randomAttack == 3) {
                this.boss.setSummon(true);
            }
            if (this.boss.getSummon()) {
                ++this.attackStatus;
                this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
                if (this.attackStatus == 30) {
                    Object entity;
                    int j;
                    int enemyNumber = this.boss.method_6051().method_43048(3) + 2;
                    int healerNumber = this.boss.method_6051().method_43048(2) + 1;
                    for (j = 0; j < enemyNumber; ++j) {
                        entity = new Remnant(EntityRegistry.REMNANT, this.boss.method_37908());
                        this.pos = new class_2338(this.boss.method_31477() + this.boss.method_6051().method_43048(32) - 16, this.boss.method_31478() - 3, this.boss.method_31479() + this.boss.method_6051().method_43048(32) - 16);
                        if (this.canSummon()) {
                            entity.method_23327(this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260());
                        }
                        this.boss.method_37908().method_8396(null, entity.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                        this.boss.method_37908().method_8649((class_1297)entity);
                        if (this.boss.method_37908().field_9236) continue;
                        ParticleHandler.particleOutburstMap(this.boss.method_37908(), 100, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
                    }
                    for (j = 0; j < healerNumber; ++j) {
                        entity = new DarkSorcerer(EntityRegistry.DARK_SORCERER, this.boss.method_37908());
                        this.pos = new class_2338(this.boss.method_31477() + this.boss.method_6051().method_43048(32) - 16, this.boss.method_31478() - 3, this.boss.method_31479() + this.boss.method_6051().method_43048(32) - 16);
                        if (this.canSummon()) {
                            entity.method_23327(this.pos.method_10263(), (float)this.pos.method_10264() + 0.2f, this.pos.method_10260());
                        }
                        this.boss.method_37908().method_8396(null, entity.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                        this.boss.method_37908().method_8649((class_1297)entity);
                        if (this.boss.method_37908().field_9236) continue;
                        ParticleHandler.particleOutburstMap(this.boss.method_37908(), 100, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
                    }
                    if (!this.boss.method_37908().field_9236) {
                        ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, target.method_23317(), target.method_23318(), target.method_23321(), ParticleEvents.GROUND_RUPTURE_MAP, 1.0f);
                    }
                    target.method_6092(new class_1293(class_1294.field_5909, 80, 1));
                    this.boss.method_37908().method_8396(null, target.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15251, 0.7f, 1.0f);
                }
                if (this.attackStatus >= 48) {
                    this.boss.setSummon(false);
                    this.resetAttackCooldown(1.0f);
                    this.resetSpecialCooldown(1.5f);
                    this.attackStatus = 0;
                    this.randomAttack = this.boss.method_6051().method_43048(this.numberOfAttacks);
                }
            }
            if (this.attackCooldown < 0 && !this.cordsRegistered && distanceToEntity < 50.0 && this.randomAttack == 5 && target.method_24515() != null) {
                this.targetPos = target.method_24515();
                this.boss.setMaceOfSpades(true);
                this.cordsRegistered = true;
            }
            if (this.boss.getMaceOfSpades() && this.targetPos != null) {
                class_1309 livingEntity;
                ++this.attackStatus;
                this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
                this.boss.method_5988().method_20248((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260());
                this.boss.method_5942().method_6337((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260(), 0.0);
                class_238 aoe = new class_238((double)(this.targetPos.method_10263() - 5), (double)(this.targetPos.method_10264() - 2), (double)(this.targetPos.method_10260() - 5), (double)(this.targetPos.method_10263() + 5), (double)(this.targetPos.method_10264() + 2), (double)(this.targetPos.method_10260() + 5));
                List entities = this.boss.method_37908().method_8335((class_1297)this.boss, aoe);
                if (this.attackStatus == 7) {
                    for (Object entity : entities) {
                        if (!(entity instanceof class_1309)) continue;
                        livingEntity = (class_1309)entity;
                        livingEntity.method_6005(2.0, -(livingEntity.method_23317() - this.boss.method_23317()), -(livingEntity.method_23321() - this.boss.method_23321()));
                        livingEntity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(20.0f));
                    }
                    this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.KNIGHT_SWIPE_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                }
                if (this.attackStatus == 13 && target.method_24515() != null) {
                    this.targetPos = target.method_24515();
                }
                if (this.attackStatus == 21 && this.targetPos != null) {
                    entities = this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(this.targetPos).method_1014(3.0));
                    for (Object entity : entities) {
                        if (!(entity instanceof class_1309)) continue;
                        livingEntity = (class_1309)entity;
                        livingEntity.method_5762(0.0, 1.0, 0.0);
                        livingEntity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(25.0f));
                    }
                    this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.NIGHTFALL_BONK_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                    if (!this.boss.method_37908().field_9236) {
                        ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, this.targetPos.method_10263(), this.targetPos.method_10264(), this.targetPos.method_10260(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                    }
                }
                if (this.attackStatus >= 36) {
                    this.boss.setMaceOfSpades(false);
                    this.resetAttackCooldown(1.0f);
                    this.cordsRegistered = false;
                    this.attackStatus = 0;
                    this.boss.method_5942().method_6340();
                    this.randomAttack = this.boss.method_6051().method_43048(this.numberOfAttacks);
                }
            }
            if (this.attackCooldown < 0 && !this.cordsRegistered && distanceToEntity < 75.0 && this.randomAttack == 0 && target.method_24515() != null) {
                this.targetPos = target.method_24515();
                this.boss.setObliterate(true);
                this.cordsRegistered = true;
            }
            if (this.boss.getObliterate() && this.targetPos != null) {
                ++this.attackStatus;
                this.boss.method_5988().method_20248((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260());
                this.boss.method_5942().method_6337((double)this.targetPos.method_10263(), (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260(), 0.0);
                this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
                class_238 aoe = new class_238(this.targetPos).method_1014(3.0);
                List entities = this.boss.method_37908().method_8335((class_1297)this.boss, aoe);
                if (this.attackStatus == 18) {
                    for (Object entity : entities) {
                        if (!(entity instanceof class_1309)) continue;
                        class_1309 living = (class_1309)entity;
                        entity.method_5643(CustomDamageSource.create(this.boss.method_37908(), CustomDamageSource.OBLITERATED, (class_1297)this.boss), this.getModifiedDamage(60.0f));
                        entity.method_18800(entity.method_18798().field_1352, 1.0, entity.method_18798().field_1350);
                        if (!living.method_5999() || !living.method_29504()) continue;
                        this.summonRemnant(living.method_19538());
                    }
                    this.boss.method_37908().method_8396(null, this.targetPos, SoundRegistry.NIGHTFALL_BONK_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                    if (!this.boss.method_37908().field_9236) {
                        ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, this.targetPos.method_10263(), this.targetPos.method_10264(), this.targetPos.method_10260(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                    }
                }
                if (this.attackStatus >= 32) {
                    this.boss.setObliterate(false);
                    this.resetAttackCooldown(1.0f);
                    this.cordsRegistered = false;
                    this.attackStatus = 0;
                    this.boss.method_5942().method_6340();
                    this.randomAttack = this.boss.method_6051().method_43048(this.numberOfAttacks);
                }
            }
            if (this.attackCooldown < 0 && distanceToEntity < 25.0 && this.randomAttack == 1) {
                this.boss.setBlind(true);
            }
            if (this.boss.getBlind()) {
                ++this.attackStatus;
                this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
                double x = target.method_23317() - this.boss.method_23317();
                double z = target.method_23321() - this.boss.method_23321();
                if (this.attackStatus == 12 && distanceToEntity < 25.0) {
                    target.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(10.0f));
                    target.method_6092(new class_1293(class_1294.field_5919, 60, 0));
                    target.method_6092(new class_1293(class_1294.field_5909, 60, 0));
                    target.method_6005(2.0, -x, -z);
                    this.boss.method_37908().method_8396(null, target.method_24515(), class_3417.field_26981, class_3419.field_15251, 1.0f, 1.0f);
                    if (!this.boss.method_37908().field_9236) {
                        ParticleHandler.particleOutburstMap(this.boss.method_37908(), 150, target.method_23317(), target.method_23320(), target.method_23321(), ParticleEvents.BLINDING_LIGHT_MAP, 1.0f);
                    }
                }
                if (this.attackStatus >= 19) {
                    this.boss.setBlind(false);
                    this.resetAttackCooldown(0.0f);
                    this.attackStatus = 0;
                    this.randomAttack = this.boss.method_6051().method_43048(this.numberOfAttacks);
                }
            }
            if (this.attackCooldown < 0 && this.specialCooldown < 0 && distanceToEntity < 300.0 && this.randomAttack == 2) {
                this.boss.setRupture(true);
            }
            if (this.boss.getRupture()) {
                ++this.attackStatus;
                this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20));
                class_238 aoe = new class_238(this.boss.method_23317() - 18.0, this.boss.method_23318() - 8.0, this.boss.method_23321() - 18.0, this.boss.method_23317() + 18.0, this.boss.method_23318() + 8.0, this.boss.method_23321() + 18.0);
                List entities = this.boss.method_37908().method_8335((class_1297)this.boss, aoe);
                if (this.attackStatus == 21 || this.attackStatus == 33) {
                    for (Object entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(12.0))) {
                        this.boss.method_37908().method_8396(null, entity.method_24515(), class_3417.field_14562, class_3419.field_15251, 1.0f, 1.0f);
                    }
                }
                if (this.attackStatus == 52) {
                    for (Object entity : entities) {
                        if (!(entity instanceof class_1309)) continue;
                        entity.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(30.0f));
                        entity.method_18800(entity.method_18798().field_1352, 1.5, entity.method_18798().field_1350);
                        this.boss.method_37908().method_8396(null, entity.method_24515(), class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
                        if (this.boss.method_37908().field_9236) continue;
                        ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, entity.method_23317(), entity.method_23318(), entity.method_23321(), ParticleEvents.GROUND_RUPTURE_MAP, 1.0f);
                    }
                }
                if (this.attackStatus >= 70) {
                    this.boss.setRupture(false);
                    this.resetAttackCooldown(0.0f);
                    this.resetSpecialCooldown(1.0f);
                    this.attackStatus = 0;
                    this.randomAttack = this.boss.method_6051().method_43048(this.numberOfAttacks);
                }
            }
            if (this.specialCooldown > 60 && this.randomAttack == 2) {
                this.randomAttack = this.boss.method_6051().method_43048(this.numberOfAttacks);
            }
            if (this.specialCooldown > 100 && this.randomAttack == 3) {
                this.randomAttack = this.boss.method_6051().method_43048(this.numberOfAttacks);
            }
            if (this.randomAttack == 4) {
                this.randomAttack = 0;
            }
            if ((this.randomAttack == 1 && !this.boss.getBlind() || this.randomAttack == 5 && !this.boss.getMaceOfSpades() || this.randomAttack == 0 && !this.boss.getObliterate()) && this.attackCooldown < -40) {
                this.randomAttack = this.boss.method_6051().method_43048(this.numberOfAttacks);
            }
            if (this.targetNotVisibleTicks < 5) {
                this.boss.method_5962().method_6239(target.method_23317(), target.method_23318(), target.method_23321(), 1.0);
            }
            super.method_6268();
        }
    }

    private void summonRemnant(class_243 pos) {
        Remnant entity = new Remnant(EntityRegistry.REMNANT, this.boss.method_37908());
        if (this.canSummon()) {
            entity.method_23327(pos.method_10216(), pos.method_10214() + (double)0.1f, pos.method_10215());
        }
        this.boss.method_37908().method_8396(null, entity.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15251, 1.0f, 1.0f);
        this.boss.method_37908().method_8649((class_1297)entity);
        if (!this.boss.method_37908().field_9236) {
            ParticleHandler.particleOutburstMap(this.boss.method_37908(), 100, pos.method_10216(), pos.method_10214(), pos.method_10215(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
        }
    }
}

