/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import org.jetbrains.annotations.Nullable;

public class BlackflameSnakeLogic {
    private final class_243 start;
    private final class_243 end;
    private final float radius;
    private final int ticksBetween;
    private final float yaw;
    private final UUID ownerUuid;
    private int age;
    private final List<List<class_243>> allPos = new ArrayList<List<class_243>>();

    public BlackflameSnakeLogic(class_243 start, class_243 end, float radius, int ticksBetween, float userYaw, UUID ownerUuid) {
        this.start = start;
        this.end = end;
        this.radius = radius;
        this.ticksBetween = ticksBetween;
        this.yaw = userYaw;
        this.ownerUuid = ownerUuid;
        this.allPos.add(this.getPositionsFromSide(true));
        this.allPos.add(this.getPositionsFromSide(false));
    }

    public void tick(class_1937 world) {
        ++this.age;
        for (List<class_243> list : this.allPos) {
            if (this.age % this.ticksBetween != 0 || list.size() == 0) continue;
            this.ruptureLogic(world, list.get(0));
            list.remove(0);
        }
    }

    private void ruptureLogic(class_1937 world, class_243 target) {
        if (!world.field_9236) {
            ParticleHandler.particleOutburstMap(world, 250, target.method_10216(), target.method_10214(), target.method_10215(), ParticleEvents.BLACKFLAME_SNAKE_PARTICLE_MAP, 1.0f);
            for (class_1297 entity : world.method_8335(this.getOwner(world), new class_238(class_2338.method_49638((class_2374)target)).method_1014(2.0))) {
                class_1282 src;
                class_1309 living;
                if (!(entity instanceof class_1309) || this.isOwner(living = (class_1309)entity) || entity instanceof NightProwler || !living.method_5643(src = this.getOwner(world) != null && this.getOwner(world) instanceof class_1309 ? world.method_48963().method_48812((class_1309)this.getOwner(world)) : world.method_48963().method_48830(), 35.0f * ConfigConstructor.night_prowler_damage_modifier)) continue;
                living.method_5762(0.0, 1.0, 0.0);
            }
            world.method_8396(null, class_2338.method_49638((class_2374)target), class_3417.field_15152, class_3419.field_15251, 1.0f, 1.0f);
        }
    }

    private List<class_243> calcAllPositions() {
        ArrayList<class_243> positions = new ArrayList<class_243>();
        double yaw = this.yaw + 90.0f;
        double ra = Math.toRadians(yaw);
        float r = this.radius;
        class_243 s = this.start.method_1031(Math.cos(ra) * (double)r, 0.0, Math.sin(ra) * (double)r);
        class_243 endLeft = null;
        class_243 endRight = null;
        for (int i = 90; i < 270; ++i) {
            if (i % 8 != 0) continue;
            double rad = Math.toRadians(yaw + (double)i);
            double x = (double)r * Math.cos(rad);
            double z = (double)r * Math.sin(rad);
            class_243 pos = new class_243(x, 0.0, z).method_1019(s);
            if (i == 264) {
                endLeft = pos;
            }
            if (i == 96) {
                endRight = pos;
            }
            positions.add(pos);
        }
        if (endLeft != null && endRight != null) {
            class_243 start = endLeft;
            class_243 between = new class_243(this.end.method_10216() - start.method_10216(), this.end.method_10214() - start.method_10214(), this.end.method_10215() - start.method_10215());
            int len = class_3532.method_15357((double)between.method_1033());
            for (int i = 0; i < len; ++i) {
                start = start.method_1019(between.method_1021(1.0 / (double)len));
                positions.add(new class_243(start.method_10216(), start.method_10214(), start.method_10215()));
            }
            class_243 start2 = endRight;
            class_243 between2 = new class_243(this.end.method_10216() - start2.method_10216(), this.end.method_10214() - start2.method_10214(), this.end.method_10215() - start2.method_10215());
            int len2 = class_3532.method_15357((double)between2.method_1033());
            for (int i = 0; i < len2; ++i) {
                start2 = start2.method_1019(between2.method_1021(1.0 / (double)len));
                positions.add(new class_243(start2.method_10216(), start2.method_10214(), start2.method_10215()));
            }
        }
        return positions;
    }

    private List<class_243> getPositionsFromSide(boolean leftSide) {
        ArrayList<class_243> positions = new ArrayList<class_243>();
        double yaw = this.yaw + 90.0f;
        double ra = Math.toRadians(yaw);
        float r = this.radius;
        class_243 s = this.start.method_1031(Math.cos(ra) * (double)r, 0.0, Math.sin(ra) * (double)r);
        class_243 endPos = null;
        int i = 180;
        while (leftSide ? i < 270 : i > 90) {
            if (i % 8 == 0) {
                double rad = Math.toRadians(yaw + (double)i);
                double x = (double)r * Math.cos(rad);
                double z = (double)r * Math.sin(rad);
                class_243 pos = new class_243(x, 0.0, z).method_1019(s);
                if (i == (leftSide ? 264 : 96)) {
                    endPos = pos;
                }
                positions.add(pos);
            }
            if (leftSide) {
                ++i;
                continue;
            }
            --i;
        }
        if (endPos != null) {
            positions.addAll(this.getPosOfLine(endPos));
        }
        return positions;
    }

    private List<class_243> getPosOfLine(class_243 targetPos) {
        ArrayList<class_243> positions = new ArrayList<class_243>();
        class_243 between = new class_243(this.end.method_10216() - targetPos.method_10216(), this.end.method_10214() - targetPos.method_10214(), this.end.method_10215() - targetPos.method_10215());
        int len = class_3532.method_15357((double)between.method_1033());
        for (int j = 0; j < len; ++j) {
            targetPos = targetPos.method_1019(between.method_1021(1.0 / (double)len));
            positions.add(new class_243(targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215()));
        }
        return positions;
    }

    public class_243 getStart() {
        return this.start;
    }

    public class_243 getEnd() {
        return this.end;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getYaw() {
        return this.yaw;
    }

    public int getTicksBetween() {
        return this.ticksBetween;
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public boolean isOwner(class_1309 target) {
        return target.method_5667().equals(this.ownerUuid);
    }

    public boolean isFinished() {
        int i = 0;
        for (List<class_243> list : this.allPos) {
            i += list.size();
        }
        return i == 0;
    }

    @Nullable
    public class_1297 getOwner(class_1937 world) {
        if (!world.field_9236) {
            return ((class_3218)world).method_14190(this.getOwnerUuid());
        }
        return null;
    }
}

