/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.NightProwlerGoal;
import net.soulsweaponry.entity.logic.BlackflameSnakeLogic;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NightProwler
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    public int phaseTwoTicks;
    public int spawnTicks;
    public int phaseTwoMaxTransitionTicks = 120;
    public int maxSpawnTicks = 50;
    public int darknessRiseTicks;
    private int[] aliveSummons = new int[0];
    @Nullable
    private BlackflameSnakeLogic blackflameSnakeLogic = null;
    public static final int ATTACKS_LENGTH = Attacks.values().length;
    private static final class_2940<Integer> ATTACKS = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> INITIATING_PHASE_2 = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_PHASE_2 = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_FLYING = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> PARTNER_UUID = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> REMAINING_ANI_TICKS = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2338> TARGET_POS = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> CHASE_TARGET = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> WAIT_ANIMATION = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SPAWN_PARTICLES_STATE = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DARKNESS_RISE = class_2945.method_12791(NightProwler.class, (class_2941)class_2943.field_13323);

    public NightProwler(class_1299<? extends NightProwler> entityType, class_1937 world) {
        super(entityType, world, class_1259.class_1260.field_5783);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new NightProwlerGoal(this, 0.75, true));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true, entity -> !this.isPartner((class_1309)entity)));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
    }

    public void setAttackAnimation(Attacks attack) {
        for (int i = 0; i < ATTACKS_LENGTH; ++i) {
            if (!Attacks.values()[i].equals((Object)attack)) continue;
            this.field_6011.method_12778(ATTACKS, (Object)i);
        }
    }

    public Attacks getAttackAnimation() {
        return Attacks.values()[(Integer)this.field_6011.method_12789(ATTACKS)];
    }

    public boolean isInitiatingPhaseTwo() {
        return (Boolean)this.field_6011.method_12789(INITIATING_PHASE_2);
    }

    public void setInitiatePhaseTwo(boolean bl) {
        this.field_6011.method_12778(INITIATING_PHASE_2, (Object)bl);
    }

    private PlayState attacks(AnimationState<?> state) {
        if (this.method_29504()) {
            return PlayState.STOP;
        }
        if (this.isInitiatingPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().then("start_phase_2", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation().equals((Object)Attacks.SPAWN)) {
            state.getController().setAnimation(RawAnimation.begin().then("spawn_1", Animation.LoopType.PLAY_ONCE));
        } else if (!this.isPhaseTwo()) {
            switch (this.getAttackAnimation()) {
                case TRINITY: {
                    state.getController().setAnimation(RawAnimation.begin().then("trinity_1", Animation.LoopType.LOOP));
                    break;
                }
                case REAPING_SLASH: {
                    state.getController().setAnimation(RawAnimation.begin().then("reaping_slash_1", Animation.LoopType.LOOP));
                    break;
                }
                case NIGHTS_EMBRACE: {
                    state.getController().setAnimation(RawAnimation.begin().then("nights_embrace_1", Animation.LoopType.LOOP));
                    break;
                }
                case RIPPLE_FANG: {
                    state.getController().setAnimation(RawAnimation.begin().then("ripple_fang_1", Animation.LoopType.LOOP));
                    break;
                }
                case BLADES_REACH: {
                    state.getController().setAnimation(RawAnimation.begin().then("blades_reach_1", Animation.LoopType.LOOP));
                    break;
                }
                case SOUL_REAPER: {
                    state.getController().setAnimation(RawAnimation.begin().then("soul_reaper_1", Animation.LoopType.LOOP));
                    break;
                }
                case DIMINISHING_LIGHT: {
                    state.getController().setAnimation(RawAnimation.begin().then("diminishing_light_1", Animation.LoopType.LOOP));
                    break;
                }
                case DARKNESS_RISE: {
                    state.getController().setAnimation(RawAnimation.begin().then("darkness_rise_1", Animation.LoopType.LOOP));
                    break;
                }
                case ENGULF: {
                    state.getController().setAnimation(RawAnimation.begin().then("engulf_1", Animation.LoopType.LOOP));
                    break;
                }
                case BLACKFLAME_SNAKE: {
                    state.getController().setAnimation(RawAnimation.begin().then("blackflame_snake_1", Animation.LoopType.LOOP));
                    break;
                }
                case DEATHBRINGERS_GRASP: {
                    state.getController().setAnimation(RawAnimation.begin().then("deaths_grasp_1", Animation.LoopType.LOOP));
                    break;
                }
                default: {
                    state.getController().setAnimation(RawAnimation.begin().then("empty_1", Animation.LoopType.LOOP));
                    break;
                }
            }
        } else {
            switch (this.getAttackAnimation()) {
                case TRINITY: {
                    state.getController().setAnimation(RawAnimation.begin().then("trinity_2", Animation.LoopType.LOOP));
                    break;
                }
                case NIGHTS_EMBRACE: {
                    state.getController().setAnimation(RawAnimation.begin().then("nights_embrace_2", Animation.LoopType.LOOP));
                    break;
                }
                case RIPPLE_FANG: {
                    state.getController().setAnimation(RawAnimation.begin().then("ripple_fang_2", Animation.LoopType.LOOP));
                    break;
                }
                case BLADES_REACH: {
                    state.getController().setAnimation(RawAnimation.begin().then("blades_reach_2", Animation.LoopType.LOOP));
                    break;
                }
                case SOUL_REAPER: {
                    state.getController().setAnimation(RawAnimation.begin().then("soul_reaper_2", Animation.LoopType.LOOP));
                    break;
                }
                case DIMINISHING_LIGHT: {
                    state.getController().setAnimation(RawAnimation.begin().then("diminishing_light_2", Animation.LoopType.LOOP));
                    break;
                }
                case DARKNESS_RISE: {
                    state.getController().setAnimation(RawAnimation.begin().then("darkness_rise_2", Animation.LoopType.LOOP));
                    break;
                }
                case ECLIPSE: {
                    state.getController().setAnimation(RawAnimation.begin().then("eclipse_2", Animation.LoopType.LOOP));
                    break;
                }
                case ENGULF: {
                    state.getController().setAnimation(RawAnimation.begin().then("engulf_2", Animation.LoopType.LOOP));
                    break;
                }
                case BLACKFLAME_SNAKE: {
                    state.getController().setAnimation(RawAnimation.begin().then("blackflame_snake_2", Animation.LoopType.LOOP));
                    break;
                }
                case LUNAR_DISPLACEMENT: {
                    state.getController().setAnimation(RawAnimation.begin().then("lunar_displacement_2", Animation.LoopType.LOOP));
                    break;
                }
                case DEATHBRINGERS_GRASP: {
                    state.getController().setAnimation(RawAnimation.begin().then("deaths_grasp_2", Animation.LoopType.LOOP));
                    break;
                }
                default: {
                    state.getController().setAnimation(RawAnimation.begin().then("empty_2", Animation.LoopType.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState idle(AnimationState<?> state) {
        if (this.method_29504() || this.getAttackAnimation().equals((Object)Attacks.DEATH) || this.getDeathTicks() > 0) {
            if (this.isPhaseTwo()) {
                state.getController().setAnimation(RawAnimation.begin().then("death_2", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("death_1", Animation.LoopType.LOOP));
            }
        } else {
            if (this.isInitiatingPhaseTwo()) {
                return PlayState.STOP;
            }
            if (this.isPhaseTwo()) {
                state.getController().setAnimation(RawAnimation.begin().then("wings_2", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("wings_1", Animation.LoopType.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState cape(AnimationState<?> state) {
        if (!this.isInitiatingPhaseTwo() && this.isPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().then("cape_2", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private PlayState flying(AnimationState<?> state) {
        if (!this.isFlying()) {
            return PlayState.STOP;
        }
        if (this.isPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().then("flying_2", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("flying_1", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACKS, (Object)0);
        this.field_6011.method_12784(INITIATING_PHASE_2, (Object)false);
        this.field_6011.method_12784(IS_PHASE_2, (Object)false);
        this.field_6011.method_12784(PARTNER_UUID, Optional.empty());
        this.field_6011.method_12784(REMAINING_ANI_TICKS, (Object)0);
        this.field_6011.method_12784(IS_FLYING, (Object)false);
        this.field_6011.method_12784(TARGET_POS, (Object)new class_2338(0, 0, 0));
        this.field_6011.method_12784(CHASE_TARGET, (Object)true);
        this.field_6011.method_12784(WAIT_ANIMATION, (Object)false);
        this.field_6011.method_12784(SPAWN_PARTICLES_STATE, (Object)0);
        this.field_6011.method_12784(DARKNESS_RISE, (Object)false);
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks == this.getTicksUntilDeath() && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{class_2398.field_11237, class_2398.field_22246});
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Nullable
    public DayStalker getPartner(class_3218 world) {
        return (DayStalker)world.method_14190(this.getPartnerUuid());
    }

    public UUID getPartnerUuid() {
        return ((Optional)this.field_6011.method_12789(PARTNER_UUID)).orElse(null);
    }

    public void setPartnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(PARTNER_UUID, Optional.ofNullable(uuid));
    }

    public boolean isPartner(class_1309 living) {
        return this.getPartnerUuid() != null && living.method_5667() != null && this.getPartnerUuid().equals(living.method_5667());
    }

    public int[] getAliveSummonsList() {
        return this.aliveSummons;
    }

    public void setAliveSummons(int[] aliveSummonsList) {
        this.aliveSummons = aliveSummonsList;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.getPartnerUuid() != null) {
            nbt.method_25927("partner_uuid", this.getPartnerUuid());
        }
        nbt.method_10556("phase_two", this.isPhaseTwo());
        nbt.method_10569("remaining_ani_ticks", this.getRemainingAniTicks());
        nbt.method_10556("is_flying", this.isFlying());
        nbt.method_10556("chase_target", this.shouldChaseTarget());
        nbt.method_10539("summons", this.getAliveSummonsList());
        nbt.method_10569("darknessTicks", this.getDarknessRiseTicks());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        UUID uUID = null;
        if (nbt.method_25928("partner_uuid")) {
            uUID = nbt.method_25926("partner_uuid");
        }
        if (uUID != null) {
            try {
                this.setPartnerUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nbt.method_10545("phase_two")) {
            this.setPhaseTwo(nbt.method_10577("phase_two"));
        }
        if (nbt.method_10545("remaining_ani_ticks")) {
            this.setRemainingAniTicks(nbt.method_10550("remaining_ani_ticks"));
        }
        if (nbt.method_10545("is_flying")) {
            this.setFlying(nbt.method_10577("is_flying"));
        }
        if (nbt.method_10545("chase_target")) {
            this.setChaseTarget(nbt.method_10577("chase_target"));
        }
        if (nbt.method_10545("summons")) {
            this.setAliveSummons(nbt.method_10561("summons"));
        }
        if (nbt.method_10545("darknessTicks")) {
            this.setDarknessRiseTicks(nbt.method_10550("darknessTicks"));
        }
    }

    public boolean isEmpowered() {
        return !this.method_37908().field_9236 && this.method_37908().method_23886() || this.isPhaseTwo();
    }

    protected class_3414 method_6002() {
        return this.isPhaseTwo() ? SoundRegistry.HARD_BOSS_DEATH_LONG : SoundRegistry.HARD_BOSS_DEATH_SHORT;
    }

    @Override
    public int getTicksUntilDeath() {
        return this.isPhaseTwo() ? 140 : 80;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
        this.setAttackAnimation(Attacks.DEATH);
    }

    @Override
    public boolean method_5753() {
        return true;
    }

    @Override
    public boolean method_5999() {
        return false;
    }

    @Override
    public class_1310 method_6046() {
        return class_1310.field_6290;
    }

    @Override
    public boolean method_42149() {
        return true;
    }

    public static class_5132.class_5133 createBossAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 120.0).method_26868(class_5134.field_23716, ConfigConstructor.night_prowler_health).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23718, 10.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23720, 0.8);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacks", 0, this::attacks)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idle)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "flying", 0, this::flying)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "cape", 0, this::cape)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public int getXp() {
        return ConfigConstructor.night_prowler_xp;
    }

    @Override
    protected void method_5958() {
        super.method_5958();
        if (!this.method_37908().field_9236) {
            DayStalker partner = this.getPartner((class_3218)this.method_37908());
            if (!this.isPhaseTwo() && (partner == null || partner.method_29504())) {
                this.method_6012();
                this.setInitiatePhaseTwo(true);
                this.setFlying(false);
            }
        }
        if (this.isInitiatingPhaseTwo()) {
            ++this.phaseTwoTicks;
            this.setFlying(false);
            int maxHealTicks = this.phaseTwoMaxTransitionTicks - 40;
            float healPerTick = this.method_6063() / (float)maxHealTicks;
            this.method_6025(healPerTick);
            if (this.phaseTwoTicks == 78) {
                this.method_37908().method_8396(null, this.method_24515(), SoundRegistry.PARTNER_DIES, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.phaseTwoTicks == 81) {
                this.method_37908().method_8396(null, this.method_24515(), SoundRegistry.DAWNBREAKER_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                if (!this.method_37908().field_9236) {
                    ParticleHandler.particleSphereList(this.method_37908(), 1000, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, new class_2394[]{class_2398.field_22246, class_2398.field_11237});
                }
                NightProwlerGoal placeHolder = new NightProwlerGoal(this, 1.0, true);
                placeHolder.aoe(this.method_5829().method_1014(4.0), 50.0f, 4.0f, true);
            }
            if (this.phaseTwoTicks >= this.phaseTwoMaxTransitionTicks) {
                this.setPhaseTwo(true);
                this.setInitiatePhaseTwo(false);
            }
        }
        if (this.getAttackAnimation().equals((Object)Attacks.SPAWN)) {
            ++this.spawnTicks;
            if (this.spawnTicks >= this.maxSpawnTicks) {
                this.setAttackAnimation(Attacks.IDLE);
            }
        }
        this.setRemainingAniTicks(Math.max(this.getRemainingAniTicks() - 1, 0));
        if (this.getRemainingAniTicks() <= 0 && this.shouldWaitAnimation()) {
            this.setWaitAnimation(false);
            this.setAttackAnimation(Attacks.IDLE);
            this.method_5942().method_6340();
        }
        if (this.getDarknessRise()) {
            this.method_6092(new class_1293(class_1294.field_5904, 40, 1));
            ++this.darknessRiseTicks;
            float r = 4.5f;
            class_238 box = new class_238(this.method_19538().method_1031((double)r, 1.0, (double)r), this.method_19538().method_1031((double)(-r), -1.0, (double)(-r)));
            for (class_1297 entity : this.method_37908().method_8335((class_1297)this, box)) {
                if (this.darknessRiseTicks % 4 != 0 || !(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                living.method_6092(new class_1293(EffectRegistry.DECAY, 60, 0));
                living.method_5643(this.method_37908().method_48963().method_48831(), 1.0f);
            }
            if (this.getDarknessRiseTicks() >= (this.isPhaseTwo() ? 200 : 120)) {
                this.setDarknessRise(false);
                this.darknessRiseTicks = 0;
            }
        }
        if (this.getBlackflameSnakeLogic() != null) {
            this.getBlackflameSnakeLogic().tick(this.method_37908());
            if (this.getBlackflameSnakeLogic().isFinished()) {
                this.setBlackflameSnakeLogic(null);
            }
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.isInitiatingPhaseTwo()) {
            return false;
        }
        if (source.method_49708(class_8111.field_42345)) {
            return false;
        }
        if (this.isEmpowered() && this.getAttackAnimation().equals((Object)Attacks.IDLE) && !this.isFlying()) {
            double z;
            double y;
            double x;
            class_1309 attacker;
            class_1297 class_12972;
            double d = this.field_5974.method_43058();
            float f = source.method_48789(class_8103.field_42247) ? 1.5f : 1.0f;
            if (d < ConfigConstructor.night_prowler_teleport_chance * (double)f && (class_12972 = source.method_5529()) instanceof class_1309 && (this.method_5858((class_1297)(attacker = (class_1309)class_12972)) > 250.0 ? this.teleportTo(x = attacker.method_23317() + (double)this.field_5974.method_43048(12) - 6.0, y = attacker.method_23318(), z = attacker.method_23321() + (double)this.field_5974.method_43048(12) - 6.0) : this.teleportAway())) {
                return false;
            }
        }
        if (this.isEmpowered() && source.method_48789(class_8103.field_42247) && (double)this.method_6032() < (double)this.method_6063() * ConfigConstructor.night_prowler_projectile_heal_below_percent_health) {
            this.method_5783(class_3417.field_14891, 1.0f, 1.0f);
            this.method_6025(ConfigConstructor.night_prowler_projectile_heal_amount);
            return false;
        }
        if (this.getAttackAnimation().equals((Object)Attacks.ECLIPSE)) {
            amount *= 0.75f;
        }
        if (source.method_49708(class_8111.field_42331)) {
            amount *= 0.25f;
        }
        return super.method_5643(source, amount);
    }

    public boolean teleportTo(double x, double y, double z) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, y, z);
        while (mutable.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutable).method_51366()) {
            mutable.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
        boolean bl = blockState.method_51366();
        boolean bl2 = blockState.method_26227().method_15767(class_3486.field_15517);
        if (!bl || bl2) {
            return false;
        }
        class_243 vec3d = this.method_19538();
        boolean bl3 = this.method_6082(x, y, z, true);
        if (bl3) {
            this.method_37908().method_32888(class_5712.field_39446, vec3d, class_5712.class_7397.method_43285((class_1297)this));
            if (!this.method_5701()) {
                this.method_37908().method_43128(null, this.field_6014, this.field_6036, this.field_5969, class_3417.field_14879, class_3419.field_15251, 1.0f, 1.0f);
                this.method_5783(class_3417.field_14879, 1.0f, 1.0f);
            }
        }
        return bl3;
    }

    public boolean teleportAway() {
        if (this.method_37908().method_8608() || !this.method_5805()) {
            return false;
        }
        double d = this.method_23317() + (this.method_6051().method_43058() - 0.5) * 32.0;
        double e = this.method_23318() + (double)(this.method_6051().method_43048(16) - 4);
        double f = this.method_23321() + (this.method_6051().method_43058() - 0.5) * 32.0;
        return this.teleportTo(d, e, f);
    }

    public void setRemainingAniTicks(int ticks) {
        this.field_6011.method_12778(REMAINING_ANI_TICKS, (Object)ticks);
    }

    public int getRemainingAniTicks() {
        return (Integer)this.field_6011.method_12789(REMAINING_ANI_TICKS);
    }

    public void setPhaseTwo(boolean bl) {
        this.field_6011.method_12778(IS_PHASE_2, (Object)bl);
    }

    public boolean isPhaseTwo() {
        return (Boolean)this.field_6011.method_12789(IS_PHASE_2);
    }

    public void setFlying(boolean bl) {
        this.field_6011.method_12778(IS_FLYING, (Object)bl);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(IS_FLYING);
    }

    public void setTargetPos(class_2338 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)pos);
    }

    public class_2338 getTargetPos() {
        return (class_2338)this.field_6011.method_12789(TARGET_POS);
    }

    public void setChaseTarget(boolean bl) {
        this.field_6011.method_12778(CHASE_TARGET, (Object)bl);
    }

    public boolean shouldChaseTarget() {
        return (Boolean)this.field_6011.method_12789(CHASE_TARGET);
    }

    public void setWaitAnimation(boolean bl) {
        this.field_6011.method_12778(WAIT_ANIMATION, (Object)bl);
    }

    public boolean shouldWaitAnimation() {
        return (Boolean)this.field_6011.method_12789(WAIT_ANIMATION);
    }

    public void setParticleState(int type) {
        this.field_6011.method_12778(SPAWN_PARTICLES_STATE, (Object)type);
    }

    public int getParticleState() {
        return (Integer)this.field_6011.method_12789(SPAWN_PARTICLES_STATE);
    }

    public void setDarknessRise(boolean bl) {
        this.field_6011.method_12778(DARKNESS_RISE, (Object)bl);
    }

    public boolean getDarknessRise() {
        return (Boolean)this.field_6011.method_12789(DARKNESS_RISE);
    }

    public void setDarknessRiseTicks(int ticks) {
        this.darknessRiseTicks = ticks;
    }

    public int getDarknessRiseTicks() {
        return this.darknessRiseTicks;
    }

    public void setBlackflameSnakeLogic(@Nullable BlackflameSnakeLogic object) {
        this.blackflameSnakeLogic = object;
    }

    @Nullable
    public BlackflameSnakeLogic getBlackflameSnakeLogic() {
        return this.blackflameSnakeLogic;
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().field_9236) {
            int i;
            if ((double)this.method_6032() < (double)this.method_6063() * ConfigConstructor.night_prowler_projectile_heal_below_percent_health) {
                for (i = 0; i < 2; ++i) {
                    this.method_37908().method_8406((class_2394)ParticleRegistry.DAZZLING_PARTICLE, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
                }
            }
            switch (this.getParticleState()) {
                case 1: {
                    double newZ;
                    double newX;
                    if (this.getTargetPos() == null) break;
                    for (i = 0; i < 500; ++i) {
                        class_5819 random = this.method_6051();
                        class_243 pos = this.getTargetPos().method_46558();
                        double d = random.method_43059() * 0.05;
                        double e = random.method_43059() * 0.05;
                        newX = random.method_43058() - 0.5 + random.method_43059() * 0.15 + d;
                        newZ = random.method_43058() - 0.5 + random.method_43059() * 0.15 + e;
                        double newY = (random.method_43058() - 0.5 + random.method_43058() * 0.5) / 2.0;
                        this.method_37908().method_8406((class_2394)class_2398.field_22246, pos.method_10216(), pos.method_10214(), pos.method_10215(), newX, newY, newZ);
                        this.method_37908().method_8406((class_2394)ParticleRegistry.NIGHTFALL_PARTICLE, pos.method_10216(), pos.method_10214(), pos.method_10215(), newX, newY, newZ);
                        this.method_37908().method_8406((class_2394)class_2398.field_11237, pos.method_10216(), pos.method_10214(), pos.method_10215(), newX, newY, newZ);
                    }
                    break;
                }
                case 2: {
                    double newZ;
                    double newX;
                    if (this.getTargetPos() == null) break;
                    for (i = 0; i < 250; ++i) {
                        class_5819 random = this.method_6051();
                        class_243 pos = this.getTargetPos().method_46558();
                        double d = random.method_43059() * 0.05;
                        double e = random.method_43059() * 0.05;
                        newX = (random.method_43058() - 0.5 + random.method_43059() * 0.15 + d) / 2.0;
                        newZ = (random.method_43058() - 0.5 + random.method_43059() * 0.15 + e) / 2.0;
                        double newY = (random.method_43058() - 0.5 + random.method_43058() * 0.5) / 4.0;
                        this.method_37908().method_8406((class_2394)class_2398.field_11237, pos.method_10216(), pos.method_10214(), pos.method_10215(), newX, newY, newZ);
                        this.method_37908().method_8406((class_2394)class_2398.field_11204, pos.method_10216(), pos.method_10214(), pos.method_10215(), newX, newY, newZ);
                        this.method_37908().method_8406((class_2394)ParticleRegistry.DARK_STAR, pos.method_10216(), pos.method_10214(), pos.method_10215(), newX, newY, newZ);
                    }
                    break;
                }
                case 3: {
                    for (int t = -90; t < 90; ++t) {
                        double rad = Math.toRadians(t);
                        int out = 4;
                        float yaw = (float)Math.toRadians(this.method_36454() + 90.0f);
                        double x1 = (double)out * Math.cos(rad);
                        double y1 = (double)out * Math.sin(rad);
                        double z1 = (double)out * Math.sin(rad);
                        class_243 vec1 = new class_243(x1, y1, z1).method_1024(-yaw).method_1019(this.method_33571().method_1031(0.0, -1.0, 0.0));
                        double x2 = (double)out * Math.cos(rad);
                        double y2 = (double)out * Math.sin(rad);
                        double z2 = (double)(-out) * Math.sin(rad);
                        class_243 vec2 = new class_243(x2, y2, z2).method_1024(-yaw).method_1019(this.method_33571().method_1031(0.0, -1.0, 0.0));
                        int div = 75;
                        this.method_37908().method_8406((class_2394)ParticleRegistry.DARK_STAR, vec1.field_1352, vec1.field_1351, vec1.field_1350, this.field_5974.method_43059() / (double)div, this.field_5974.method_43059() / (double)div, this.field_5974.method_43059() / (double)div);
                        this.method_37908().method_8406((class_2394)ParticleRegistry.DAZZLING_PARTICLE, vec2.field_1352, vec2.field_1351, vec2.field_1350, this.field_5974.method_43059() / (double)div, this.field_5974.method_43059() / (double)div, this.field_5974.method_43059() / (double)div);
                    }
                    break;
                }
                case 4: {
                    double phi = Math.PI * (3.0 - Math.sqrt(5.0));
                    int points = 600;
                    int div = 60;
                    float sizeMod = 15.0f;
                    for (int i2 = 0; i2 < points; ++i2) {
                        double y = 1.0 - (double)i2 / (double)(points - 1) * 2.0;
                        double radius = Math.sqrt(1.0 - y * y);
                        double theta = phi * (double)i2;
                        double x = Math.cos(theta) * radius;
                        double z = Math.sin(theta) * radius;
                        this.method_37908().method_8466((class_2394)ParticleRegistry.DARK_STAR, true, x * (double)sizeMod + this.method_23317(), y * (double)sizeMod + this.method_23318(), z * (double)sizeMod + this.method_23321(), this.field_5974.method_43059() / (double)div, this.field_5974.method_43059() / (double)div, this.field_5974.method_43059() / (double)div);
                    }
                    break;
                }
            }
            if (this.getDarknessRise()) {
                int div = 30;
                for (int i3 = 0; i3 < 12; ++i3) {
                    float r = (float)i3 / 2.0f;
                    for (int theta = 0; theta < 360; ++theta) {
                        if (theta % 8 != 0) continue;
                        double x0 = this.method_23317();
                        double z0 = this.method_23321();
                        double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                        double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                        this.method_37908().method_8406((class_2394)ParticleRegistry.DARK_STAR, x, this.method_23318() + (double)0.1f, z, this.field_5974.method_43059() / (double)div, this.field_5974.method_43059() / (double)div, this.field_5974.method_43059() / (double)div);
                    }
                }
            }
        }
    }

    public boolean method_5740() {
        return this.isFlying();
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        if (!this.isFlying()) {
            super.method_5623(heightDifference, onGround, state, landedPosition);
        }
    }

    public boolean method_6101() {
        return !this.isFlying() && super.method_6101();
    }

    protected boolean method_27071() {
        return this.isPhaseTwo();
    }

    public static enum Attacks {
        IDLE,
        DEATH,
        SPAWN,
        TRINITY,
        REAPING_SLASH,
        NIGHTS_EMBRACE,
        RIPPLE_FANG,
        BLADES_REACH,
        SOUL_REAPER,
        DIMINISHING_LIGHT,
        DARKNESS_RISE,
        ECLIPSE,
        ENGULF,
        BLACKFLAME_SNAKE,
        LUNAR_DISPLACEMENT,
        DEATHBRINGERS_GRASP;

    }
}

