/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.NightShadeGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NightShade
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int spawnTicks;
    public int deathTicks;
    private boolean isCopy = false;
    private boolean healthUpdated = false;
    private boolean hasDuplicated = false;
    private int duplicateTicks;
    protected static final class_2940<Integer> ATTACK_STATE = class_2945.method_12791(NightShade.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> CHARGING = class_2945.method_12791(NightShade.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<class_2338> POS = class_2945.method_12791(NightShade.class, (class_2941)class_2943.field_13324);

    public NightShade(class_1299<? extends NightShade> entityType, class_1937 world) {
        super(entityType, world, class_1259.class_1260.field_5780);
        this.field_6207 = new ShadeMoveControl(this);
    }

    public static class_5132.class_5133 createBossAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 65.0).method_26868(class_5134.field_23716, ConfigConstructor.frenzied_shade_health).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 10.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new NightShadeGoal(this));
        this.field_6201.method_6277(7, (class_1352)new Emerge());
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CHARGING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(ATTACK_STATE, (Object)0);
        this.field_6011.method_12784(POS, (Object)new class_2338(0, 0, 0));
    }

    public void setTargetPos(class_2338 pos) {
        this.field_6011.method_12778(POS, (Object)pos);
    }

    public class_2338 getTargetPos() {
        return (class_2338)this.field_6011.method_12789(POS);
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
        this.method_5852();
    }

    public void method_5773() {
        this.field_5960 = true;
        super.method_5773();
        this.field_5960 = false;
        this.method_5875(true);
        if (this.isCopy) {
            this.bossBar.method_14091(false);
            if (!this.healthUpdated) {
                this.method_6033((float)ConfigConstructor.frenzied_shade_health / 4.0f);
                this.healthUpdated = true;
            }
            this.field_6194 = 20;
        }
    }

    protected boolean method_27071() {
        return !this.isCopy();
    }

    public void method_6007() {
        int i;
        super.method_6007();
        if (this.getSpawn()) {
            ++this.spawnTicks;
            if (this.spawnTicks >= 40) {
                this.setAttackState(AttackStates.IDLE);
            }
        }
        for (i = 0; i < 3; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
        }
        if (!this.isCopy && !this.hasDuplicated && this.method_6032() <= this.method_6063() / 2.0f) {
            this.setAttackState(AttackStates.DUPLICATE);
            ++this.duplicateTicks;
            if (this.duplicateTicks == 20) {
                CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, new class_2394[]{class_2398.field_11237, ParticleRegistry.NIGHTFALL_PARTICLE, ParticleRegistry.DARK_STAR});
                this.method_5942().method_6340();
                for (i = -1; i <= 1; i += 2) {
                    NightShade copy = new NightShade(EntityRegistry.NIGHT_SHADE, this.method_37908());
                    copy.setCopy(true);
                    copy.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
                    copy.method_18800((float)i / 10.0f, (float)i / 10.0f, -((float)i) / 10.0f);
                    copy.setSpawn();
                    copy.method_5980(this.method_5968());
                    this.method_37908().method_8649((class_1297)copy);
                    NightShade copy2 = new NightShade(EntityRegistry.NIGHT_SHADE, this.method_37908());
                    copy2.setCopy(true);
                    copy2.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
                    copy2.method_18800(-((float)i) / 10.0f, (float)i / 10.0f, (float)i / 10.0f);
                    copy2.setSpawn();
                    copy2.method_5980(this.method_5968());
                    this.method_37908().method_8649((class_1297)copy2);
                }
            }
            if (this.duplicateTicks >= 60) {
                this.hasDuplicated = true;
                this.setAttackState(AttackStates.IDLE);
            }
        }
    }

    public boolean isCopy() {
        return this.isCopy;
    }

    @Override
    public void setDeath() {
        this.setAttackState(AttackStates.DEATH);
    }

    @Override
    public int getTicksUntilDeath() {
        return 60;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks % 30 == 0) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15163, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.method_37908().method_8608()) {
            if (this.isCopy) {
                this.method_37908().method_8421((class_1297)this, (byte)60);
                this.method_5650(class_1297.class_5529.field_26998);
                return;
            }
            this.method_37908().method_8421((class_1297)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{class_2398.field_11237, ParticleRegistry.NIGHTFALL_PARTICLE, ParticleRegistry.DARK_STAR});
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void setAttackState(AttackStates state) {
        for (int i = 0; i < AttackStates.values().length; ++i) {
            if (AttackStates.values()[i] != state) continue;
            this.field_6011.method_12778(ATTACK_STATE, (Object)i);
        }
    }

    public AttackStates getAttackState() {
        return AttackStates.values()[(Integer)this.field_6011.method_12789(ATTACK_STATE)];
    }

    public boolean getCharging() {
        return (Boolean)this.field_6011.method_12789(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_6011.method_12778(CHARGING, (Object)charging);
    }

    public boolean getSpawn() {
        return this.getAttackState().equals((Object)AttackStates.SPAWN);
    }

    public void setSpawn() {
        this.setAttackState(AttackStates.SPAWN);
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.method_29504()) {
            state.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME));
        }
        switch (this.getAttackState()) {
            case IDLE: {
                state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
                break;
            }
            case SPAWN: {
                state.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case DEATH: {
                state.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case BIG_SWIPES: {
                state.getController().setAnimation(RawAnimation.begin().then("big_swipes", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case GENERIC_CHARGE: {
                state.getController().setAnimation(RawAnimation.begin().then("charge", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case AOE: {
                state.getController().setAnimation(RawAnimation.begin().then("aoe", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case DUPLICATE: {
                state.getController().setAnimation(RawAnimation.begin().then("duplicate", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case THROW_MOONLIGHT: {
                state.getController().setAnimation(RawAnimation.begin().then("throw_moonlight", Animation.LoopType.HOLD_ON_LAST_FRAME));
                break;
            }
            case SHADOW_ORBS: {
                state.getController().setAnimation(RawAnimation.begin().then("shadow_orbs", Animation.LoopType.HOLD_ON_LAST_FRAME));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public void setCopy(boolean bl) {
        this.isCopy = bl;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("is_copy", this.isCopy);
        nbt.method_10556("has_duplicated", this.hasDuplicated);
        nbt.method_10556("has_health_updated", this.healthUpdated);
    }

    @Override
    public int getXp() {
        return ConfigConstructor.frenzied_shade_xp;
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("has_duplicated")) {
            this.hasDuplicated = nbt.method_10577("has_duplicated");
        }
        if (nbt.method_10545("is_copy")) {
            this.isCopy = nbt.method_10577("is_copy");
        }
        if (nbt.method_10545("has_health_updated")) {
            this.healthUpdated = nbt.method_10577("has_health_updated");
        }
    }

    @Override
    public boolean method_5753() {
        return true;
    }

    @Override
    public boolean method_5999() {
        return true;
    }

    @Override
    public class_1310 method_6046() {
        return class_1310.field_6290;
    }

    @Override
    public boolean method_42149() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected class_3414 method_5994() {
        return SoundRegistry.NIGHT_SHADE_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundRegistry.NIGHT_SHADE_DAMAGE_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundRegistry.NIGHT_SHADE_DEATH_EVENT;
    }

    class ShadeMoveControl
    extends class_1335 {
        public ShadeMoveControl(NightShade owner) {
            super((class_1308)owner);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - NightShade.this.method_23317(), this.field_6369 - NightShade.this.method_23318(), this.field_6367 - NightShade.this.method_23321());
                double d = vec3d.method_1033();
                if (d < NightShade.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    NightShade.this.method_18799(NightShade.this.method_18798().method_1021(0.5));
                } else {
                    NightShade.this.method_18799(NightShade.this.method_18798().method_1019(vec3d.method_1021(this.field_6372 * 0.05 / d)));
                    if (NightShade.this.method_5968() == null) {
                        class_243 vec3d2 = NightShade.this.method_18798();
                        NightShade.this.method_36456(-((float)class_3532.method_15349((double)vec3d2.field_1352, (double)vec3d2.field_1350)) * 57.295776f);
                    } else {
                        double e = NightShade.this.method_5968().method_23317() - NightShade.this.method_23317();
                        double f = NightShade.this.method_5968().method_23321() - NightShade.this.method_23321();
                        NightShade.this.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                    }
                    NightShade.this.field_6283 = NightShade.this.method_36454();
                }
            }
        }
    }

    class Emerge
    extends class_1352 {
        Emerge() {
        }

        public boolean method_6264() {
            return NightShade.this.method_5968() == null;
        }

        public void method_6268() {
            if (NightShade.this.method_5968() == null && this.isInsideWall()) {
                NightShade.this.method_18800(0.0, 0.1f, 0.0);
            }
        }

        private boolean isInsideWall() {
            float f = NightShade.this.method_18377((class_4050)class_4050.field_18076).field_18067 * 0.8f;
            class_238 box = class_238.method_30048((class_243)NightShade.this.method_33571(), (double)f, (double)1.0E-6, (double)f);
            return class_2338.method_29715((class_238)box).anyMatch(pos -> {
                class_2680 blockState = NightShade.this.method_37908().method_8320(pos);
                return !blockState.method_26215() && blockState.method_26228((class_1922)NightShade.this.method_37908(), pos) && class_259.method_1074((class_265)blockState.method_26220((class_1922)NightShade.this.method_37908(), pos).method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), (class_265)class_259.method_1078((class_238)box), (class_247)class_247.field_16896);
            });
        }
    }

    public static enum AttackStates {
        IDLE,
        SPAWN,
        DEATH,
        BIG_SWIPES,
        GENERIC_CHARGE,
        AOE,
        DUPLICATE,
        THROW_MOONLIGHT,
        SHADOW_ORBS;

    }
}

