/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.EnumSet;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.soulsweaponry.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WarmthEntity
extends class_1321
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> STATES = class_2945.method_12791(WarmthEntity.class, (class_2941)class_2943.field_13327);

    public WarmthEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 10;
    }

    protected void method_5959() {
        this.field_6201.method_6277(4, (class_1352)new WarmthEntityGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true, entity -> !this.method_6181() || !(this.method_35057() instanceof class_1657)));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1308.class, true, entity -> this.method_6181() && entity instanceof class_1569 && !(entity instanceof class_1548) && !this.method_5722((class_1297)entity)));
    }

    private PlayState attacks(AnimationState<?> state) {
        switch (this.getState()) {
            case 1: {
                state.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.LOOP));
                break;
            }
            case 2: {
                state.getController().setAnimation(RawAnimation.begin().then("buff", Animation.LoopType.LOOP));
                break;
            }
            default: {
                state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    public void setState(int state) {
        this.field_6011.method_12778(STATES, (Object)state);
    }

    public int getState() {
        return (Integer)this.field_6011.method_12789(STATES);
    }

    public boolean method_5753() {
        return true;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STATES, (Object)0);
    }

    public static class_5132.class_5133 createEntityAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23718, 30.0);
    }

    public class_1924 method_48926() {
        return super.method_37908();
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public boolean method_5810() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacks", 0, this::attacks)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void method_6007() {
        if (this.method_37908().field_9236) {
            this.method_37908().method_8406((class_2394)class_2398.field_11240, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
        }
        super.method_6007();
    }

    public boolean method_5740() {
        return true;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.method_37908().field_9236) {
            this.particleExplosion();
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 > 1200) {
            this.method_5768();
        }
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        if (this.method_37908().field_9236) {
            this.particleExplosion();
        }
        this.method_31472();
    }

    @Nullable
    protected class_3414 method_6002() {
        return SoundRegistry.WARMTH_DIE_EVENT;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14576;
    }

    public boolean method_29503() {
        return true;
    }

    private void particleExplosion() {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        float points = 100.0f;
        int i = 0;
        while ((float)i < points) {
            double velocityY = 1.0f - (float)i / (points - 1.0f) * 2.0f;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            this.method_37908().method_8466((class_2394)class_2398.field_11240, true, this.method_23317(), this.method_23323(0.5), this.method_23321(), velocityX * (double)0.4f, velocityY * (double)0.4f, velocityZ * (double)0.4f);
            ++i;
        }
    }

    static class WarmthEntityGoal
    extends class_1352 {
        private final WarmthEntity entity;
        private int attackCooldown;
        private int attackStatus;

        public WarmthEntityGoal(WarmthEntity entity) {
            this.entity = entity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.entity.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.entity.method_18395(livingEntity);
        }

        public void method_6270() {
            this.reset();
        }

        private void reset() {
            this.entity.setState(0);
            this.attackCooldown = 60;
            this.attackStatus = 0;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            --this.attackCooldown;
            class_1309 livingEntity = this.entity.method_5968();
            if (livingEntity == null) {
                return;
            }
            this.entity.method_5988().method_6226((class_1297)livingEntity, 10.0f, 10.0f);
            if (this.attackCooldown < 0 && this.entity.getState() == 0) {
                int rand = this.entity.field_5974.method_43048(5);
                this.entity.setState(rand == 1 ? 2 : 1);
            }
            switch (this.entity.getState()) {
                case 1: {
                    this.shootFire(livingEntity);
                    break;
                }
                case 2: {
                    this.buff();
                }
            }
        }

        private void shootFire(class_1309 livingEntity) {
            ++this.attackStatus;
            double e = livingEntity.method_23317() - this.entity.method_23317();
            double f = livingEntity.method_23323(0.5) - this.entity.method_23323(0.5);
            double g = livingEntity.method_23321() - this.entity.method_23321();
            if (this.attackStatus == 7 || this.attackStatus == 15 || this.attackStatus == 21) {
                this.entity.method_37908().method_8396(null, this.entity.method_24515(), class_3417.field_14970, class_3419.field_15251, 1.0f, 1.0f);
                class_1677 smallFireballEntity = new class_1677(this.entity.method_37908(), (class_1309)this.entity, e, f, g);
                smallFireballEntity.method_5814(smallFireballEntity.method_23317(), this.entity.method_23323(0.5), smallFireballEntity.method_23321());
                this.entity.method_37908().method_8649((class_1297)smallFireballEntity);
            }
            if (this.attackStatus >= 28) {
                this.reset();
            }
        }

        private void buff() {
            ++this.attackStatus;
            if (this.attackStatus == 1) {
                this.entity.method_37908().method_8396(null, this.entity.method_24515(), class_3417.field_14880, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.attackStatus == 30) {
                this.entity.method_37908().method_8396(null, this.entity.method_24515(), SoundRegistry.WARMTH_BUFF_EVENT, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.attackStatus == 35) {
                boolean bl = this.entity.method_6181() && this.entity.method_35057() != null;
                for (class_1297 en : this.entity.method_37908().method_8335((class_1297)this.entity, this.entity.method_5829().method_1014(16.0))) {
                    if (!(en instanceof class_1309)) continue;
                    class_1309 living = (class_1309)en;
                    if (bl && !(living instanceof class_1588)) {
                        this.addEffects(living);
                        continue;
                    }
                    if (!(living instanceof class_1569)) continue;
                    this.addEffects(living);
                }
                this.addEffects((class_1309)this.entity);
            }
            if (this.attackStatus >= 40) {
                this.reset();
            }
        }

        private void addEffects(class_1309 living) {
            living.method_6092(new class_1293(class_1294.field_5918, 200, 0));
            living.method_6092(new class_1293(class_1294.field_5924, 200, 0));
            living.method_6092(new class_1293(class_1294.field_5907, 200, 0));
            living.method_6092(new class_1293(class_1294.field_5910, 200, 0));
        }
    }
}

