/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2223;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MoonlightProjectile
extends NonArrowProjectile
implements GeoEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<Integer> POINTS = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TICK_PARTICLES = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_AGE = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HUGE_EXPLOSION = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ROTATE_STATE = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2394> EXPLOSION_PARTICLE = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13314);
    private static final class_2940<class_2394> TRAIL_PARTICLE = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13314);
    private static final class_2940<Integer> APPLY_FIRE_TICKS = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private class_1799 stackShotFrom;

    public MoonlightProjectile(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public MoonlightProjectile(class_1299<? extends class_1665> type, class_1937 world, class_1309 owner) {
        super(type, owner, world);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(POINTS, (Object)75);
        this.field_6011.method_12784(TICK_PARTICLES, (Object)4);
        this.field_6011.method_12784(MAX_AGE, (Object)30);
        this.field_6011.method_12784(HUGE_EXPLOSION, (Object)false);
        this.field_6011.method_12784(ROTATE_STATE, (Object)0);
        this.field_6011.method_12784(EXPLOSION_PARTICLE, (Object)class_2398.field_22246);
        this.field_6011.method_12784(TRAIL_PARTICLE, (Object)class_2398.field_28479);
        this.field_6011.method_12784(APPLY_FIRE_TICKS, (Object)0);
    }

    public void setAgeAndPoints(int maxAge, int explosionPoints, int tickParticleAmount) {
        this.field_6011.method_12778(MAX_AGE, (Object)maxAge);
        this.field_6011.method_12778(POINTS, (Object)explosionPoints);
        this.field_6011.method_12778(TICK_PARTICLES, (Object)tickParticleAmount);
    }

    public void setHugeExplosion(boolean bl) {
        this.field_6011.method_12778(HUGE_EXPLOSION, (Object)bl);
    }

    public void setRotateState(RotationState state) {
        for (int i = 0; i < RotationState.values().length; ++i) {
            if (!state.equals((Object)RotationState.values()[i])) continue;
            this.field_6011.method_12778(ROTATE_STATE, (Object)i);
        }
    }

    public RotationState getRotateState() {
        return RotationState.values()[(Integer)this.field_6011.method_12789(ROTATE_STATE)];
    }

    public int getMaxParticlePoints() {
        return (Integer)this.field_6011.method_12789(POINTS);
    }

    public int getTickParticleAmount() {
        return (Integer)this.field_6011.method_12789(TICK_PARTICLES);
    }

    public double getMaxAge() {
        return ((Integer)this.field_6011.method_12789(MAX_AGE)).intValue();
    }

    public void method_5773() {
        super.method_5773();
        class_243 vec3d = this.method_18798();
        double e = vec3d.field_1352;
        double f = vec3d.field_1351;
        double g = vec3d.field_1350;
        for (int i = 0; i < this.getTickParticleAmount(); ++i) {
            this.method_37908().method_8406(this.getTrailParticleType(), this.method_23317() + e * (double)i / 4.0, this.method_23318() + f * (double)i / 4.0, this.method_23321() + g * (double)i / 4.0, -e, -f + 0.2, -g);
        }
        if ((double)this.field_6012 > this.getMaxAge()) {
            this.method_31472();
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_31472();
    }

    public int method_35207() {
        if (this.stackShotFrom != null) {
            return class_1890.method_8225((class_1887)class_1893.field_9121, (class_1799)this.stackShotFrom);
        }
        return super.method_35207();
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        if (entityHitResult.method_17782() != null && entityHitResult.method_17782() instanceof class_1309 && this.method_7445() != null) {
            float bonus = class_1890.method_8218((class_1799)this.method_7445(), (class_1310)((class_1309)entityHitResult.method_17782()).method_6046());
            this.method_7438(this.method_7448() + (double)(bonus >= 5.0f ? bonus * 0.7f : bonus));
        }
        super.method_7454(entityHitResult);
        if (this.getFireTicksOnHit() > 0 && entityHitResult.method_17782() != null) {
            entityHitResult.method_17782().method_20803(this.getFireTicksOnHit());
        }
        this.method_31472();
    }

    public void detonateEntity(class_1937 world, double x, double y, double z, double points, float sizeModifier) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            world.method_8466(this.getExplosionParticleType(), true, x, y, z, velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            ++i;
        }
    }

    public void method_36209() {
        super.method_36209();
        if (((Boolean)this.field_6011.method_12789(HUGE_EXPLOSION)).booleanValue()) {
            this.detonateEntity(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), 750.0, 0.5f);
        } else {
            this.detonateEntity(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), this.getMaxParticlePoints(), 0.125f);
        }
    }

    protected class_3414 method_7440() {
        return class_3417.field_15152;
    }

    protected float method_7436() {
        return 1.01f;
    }

    protected class_1799 method_7445() {
        return this.stackShotFrom;
    }

    public void setItemStack(class_1799 stackShotFrom) {
        this.stackShotFrom = stackShotFrom;
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_5753() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setExplosionParticleType(class_2394 particle) {
        this.method_5841().method_12778(EXPLOSION_PARTICLE, (Object)particle);
    }

    public class_2394 getExplosionParticleType() {
        return (class_2394)this.method_5841().method_12789(EXPLOSION_PARTICLE);
    }

    public void setTrailParticleType(class_2394 particle) {
        this.method_5841().method_12778(TRAIL_PARTICLE, (Object)particle);
    }

    public class_2394 getTrailParticleType() {
        return (class_2394)this.method_5841().method_12789(TRAIL_PARTICLE);
    }

    public void applyFireTicks(int ticks) {
        this.field_6011.method_12778(APPLY_FIRE_TICKS, (Object)ticks);
    }

    public int getFireTicksOnHit() {
        return (Integer)this.field_6011.method_12789(APPLY_FIRE_TICKS);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Particle", this.getExplosionParticleType().method_10293());
        nbt.method_10582("TrailParticle", this.getExplosionParticleType().method_10293());
        nbt.method_10569("FireTicksOnHit", this.getFireTicksOnHit());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Particle", 8)) {
            try {
                this.setExplosionParticleType(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("Particle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("Particle"), (Object)var5);
            }
        }
        if (nbt.method_10573("TrailParticle", 8)) {
            try {
                this.setTrailParticleType(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("TrailParticle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("TrailParticle"), (Object)var5);
            }
        }
        if (nbt.method_10545("FireTicksOnHit")) {
            this.applyFireTicks(nbt.method_10550("FireTicksOnHit"));
        }
    }

    public static enum RotationState {
        NORMAL,
        SWIPE_FROM_RIGHT,
        SWIPE_FROM_LEFT;

    }
}

