/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public abstract class ReturningProjectile
extends class_1665 {
    public class_1799 stack;
    public boolean dealtDamage;
    private boolean shouldReturn;
    private int returnTimer;
    public static final String DEALT_DAMAGE = "DealtDamage";
    public static final String SHOULD_RETURN = "ShouldReturn";
    public static final class_2940<Optional<UUID>> THROWN_WEAPON_OPT = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13313);

    public ReturningProjectile(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ReturningProjectile(class_1299<? extends class_1665> type, double x, double y, double z, class_1937 world) {
        super(type, x, y, z, world);
    }

    public ReturningProjectile(class_1299<? extends class_1665> type, class_1309 owner, class_1937 world) {
        super(type, owner, world);
    }

    public ReturningProjectile(class_1299<? extends class_1665> type, class_1309 owner, class_1937 world, class_1799 stack) {
        super(type, owner, world);
        this.stack = stack.method_7972();
    }

    public abstract float getDamage(class_1297 var1);

    public abstract boolean collide(class_1297 var1, class_1297 var2, float var3);

    public abstract double getReturnSpeed(class_1799 var1);

    protected void method_7454(class_3966 entityHitResult) {
        ReturningProjectile owner = this.method_24921() == null ? this : this.method_24921();
        class_1297 entity = entityHitResult.method_17782();
        this.dealtDamage = true;
        if (this.collide((class_1297)owner, entity, this.getDamage(entity))) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 target = (class_1309)entity;
                if (owner instanceof class_1309) {
                    class_1890.method_8210((class_1309)target, (class_1297)owner);
                    class_1890.method_8213((class_1309)((class_1309)owner), (class_1297)target);
                }
                this.method_7450(target);
            }
        }
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
    }

    public void saveOnPlayer(class_1657 player) {
        Optional<UUID> uuid = Optional.of(this.method_5667());
        try {
            if (((Optional)player.method_5841().method_12789(THROWN_WEAPON_OPT)).isPresent() && player.method_37908() instanceof class_3218) {
                class_1297 entity = ((class_3218)player.method_37908()).method_14190((UUID)((Optional)player.method_5841().method_12789(THROWN_WEAPON_OPT)).get());
                if (entity instanceof ReturningProjectile) {
                    ReturningProjectile returning = (ReturningProjectile)entity;
                    returning.setShouldReturn(true);
                }
                player.method_5841().method_12778(THROWN_WEAPON_OPT, uuid);
            }
        }
        catch (Exception exception) {
            player.method_5841().method_12784(THROWN_WEAPON_OPT, uuid);
        }
    }

    public void method_5773() {
        if (this.field_7576 > 4 || this.field_6012 > 60) {
            this.dealtDamage = true;
        }
        if (!this.field_7588 && this.field_6012 > 60) {
            this.setShouldReturn(true);
        }
        class_1297 entity = this.method_24921();
        double returnSpeed = this.getReturnSpeed(this.stack);
        if (this.shouldReturn() && (this.dealtDamage || this.method_7441()) && entity != null) {
            this.method_7433(true);
            class_243 vec3d = entity.method_33571().method_1020(this.method_19538());
            if (!this.isOwnerAlive()) {
                if (this.stack.method_7985() && this.stack.method_7969().method_10545("owners_last_pos")) {
                    int[] pos = this.stack.method_7969().method_10561("owners_last_pos");
                    vec3d = new class_243((double)pos[0], (double)pos[1], (double)pos[2]).method_1020(this.method_19538());
                    if (vec3d.method_10216() == (double)pos[0] && vec3d.method_10214() == (double)pos[1] && vec3d.method_10215() == (double)pos[2]) {
                        this.dropStack();
                    }
                } else {
                    this.dropStack();
                }
            }
            this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * returnSpeed, this.method_23321());
            if (this.method_37908().field_9236) {
                this.field_5971 = this.method_23318();
            }
            double d = 0.05 * returnSpeed;
            this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
            if (this.returnTimer == 0) {
                this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
            }
            ++this.returnTimer;
            for (class_1297 entity1 : this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014(0.2))) {
                class_1309 target;
                if (!(entity1 instanceof class_1309) || (target = (class_1309)entity1).method_5722(entity)) continue;
                this.collide(entity, (class_1297)target, this.getDamage((class_1297)target));
            }
        }
        List<class_1297> list = this.method_37908().method_8335((class_1297)this, this.method_5829()).stream().filter(e -> e instanceof class_1657).toList();
        if (this.dealtDamage && !list.isEmpty()) {
            class_1657 player = (class_1657)list.get(0);
            if (entity != null) {
                for (class_1297 entity1 : list) {
                    if (!entity1.equals((Object)entity)) continue;
                    player = (class_1657)entity1;
                }
            }
            if (!this.insertStack(player)) {
                this.method_5699(this.method_7445(), 0.1f);
            }
            this.method_31472();
        }
        super.method_5773();
    }

    public boolean insertStack(class_1657 player) {
        boolean bl;
        int slot = player.method_31548().field_7545;
        if (!player.method_31548().method_7391().method_7960()) {
            slot = -1;
        }
        if (bl = player.method_31548().method_7367(slot, this.method_7445())) {
            player.method_5783(class_3417.field_15197, 1.0f, (float)this.field_5974.method_43059() + 0.25f);
        }
        return bl;
    }

    private void dropStack() {
        if (!this.method_37908().field_9236 && this.field_7572 == class_1665.class_1666.field_7593) {
            this.method_5699(this.method_7445(), 0.1f);
        }
        this.method_31472();
    }

    public boolean shouldReturn() {
        return this.shouldReturn;
    }

    public boolean method_5753() {
        return true;
    }

    public void setShouldReturn(boolean bl) {
        this.dealtDamage = bl;
        this.shouldReturn = bl;
        this.method_7433(bl);
    }

    private boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        if (entity == null || !entity.method_5805()) {
            return false;
        }
        return !(entity instanceof class_3222) || !entity.method_7325();
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        if (this.dealtDamage) {
            return null;
        }
        return super.method_7434(currentPosition, nextPosition);
    }

    public int getReturnTimer() {
        return this.returnTimer;
    }

    protected boolean method_34713(class_1657 player) {
        int slot = player.method_31548().field_7545;
        if (!player.method_31548().method_7391().method_7960()) {
            slot = -1;
        }
        return super.method_34713(player) || this.method_7441() && this.method_34714((class_1297)player) && player.method_31548().method_7367(slot, this.method_7445());
    }

    protected class_3414 method_7440() {
        return class_3417.field_15104;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Stack", 10)) {
            this.stack = class_1799.method_7915((class_2487)nbt.method_10562("Stack"));
        }
        if (nbt.method_10545(SHOULD_RETURN)) {
            this.shouldReturn = nbt.method_10577(SHOULD_RETURN);
        }
        if (nbt.method_10545("ReturnTimer")) {
            this.returnTimer = nbt.method_10550("ReturnTimer");
        }
        this.dealtDamage = nbt.method_10577(DEALT_DAMAGE);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("Stack", (class_2520)this.stack.method_7953(new class_2487()));
        nbt.method_10556(DEALT_DAMAGE, this.dealtDamage);
        nbt.method_10556(SHOULD_RETURN, this.shouldReturn);
        nbt.method_10569("ReturnTimer", this.returnTimer);
    }

    public class_1799 method_7445() {
        return this.stack;
    }

    protected float method_7436() {
        return 0.99f;
    }
}

