/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8103;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.IEntityDataSaver;
import net.soulsweaponry.networking.PacketIds;

public class ParryData {
    public static final String PARRY_FRAMES_ID = "parry_frames";
    public static int MAX_PARRY_FRAMES = ConfigConstructor.shield_parry_max_animation_frames;

    public static int addParryFrames(IEntityDataSaver player, int amount) {
        class_2487 nbt = player.getPersistentData();
        int frame = nbt.method_10550(PARRY_FRAMES_ID);
        frame = frame >= MAX_PARRY_FRAMES ? 0 : (frame += amount);
        nbt.method_10569(PARRY_FRAMES_ID, frame);
        ParryData.syncFrames(frame, (class_3222)player);
        return frame;
    }

    public static int setParryFrames(IEntityDataSaver player, int amount) {
        class_2487 nbt = player.getPersistentData();
        nbt.method_10569(PARRY_FRAMES_ID, amount);
        ParryData.syncFrames(amount, (class_3222)player);
        return amount;
    }

    public static int getParryFrames(class_1657 player) {
        return ((IEntityDataSaver)player).getPersistentData().method_10550(PARRY_FRAMES_ID);
    }

    public static boolean successfulParry(class_1657 player, boolean checkIfCanBeParried, class_1282 source) {
        int frames = ParryData.getParryFrames(player);
        boolean bl = true;
        if (checkIfCanBeParried) {
            bl = !source.method_48789(class_8103.field_43116);
        }
        return frames >= 1 && frames <= ConfigConstructor.shield_parry_frames && bl;
    }

    public static void syncFrames(int frames, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(frames);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIds.PARRY, (class_2540)buf);
    }
}

