/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.DarkinBladeRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.UltraHeavyWeapon;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DarkinBlade
extends UltraHeavyWeapon
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public DarkinBlade(class_1832 toolMaterial, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.darkin_blade_damage, attackSpeed, settings, true);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1657 player;
        if (attacker instanceof class_1657 && !(player = (class_1657)attacker).method_7357().method_7904(stack.method_7909()) && !(player.method_6032() >= player.method_6063())) {
            if (!player.method_7337()) {
                player.method_7357().method_7906((class_1792)this, ConfigConstructor.lifesteal_item_cooldown);
            }
            float healing = ConfigConstructor.lifesteal_item_base_healing;
            if (ConfigConstructor.lifesteal_item_heal_scales) {
                healing += (float)class_3532.method_15386((float)((float)WeaponUtil.getEnchantDamageBonus(stack) / 2.0f));
            }
            attacker.method_6025(healing);
        }
        this.gainStrength(attacker);
        return super.method_7873(stack, target, attacker);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int duration = ConfigConstructor.darkin_blade_ability_cooldown;
            int i = this.method_7881(stack) - remainingUseTicks;
            if (i >= 10) {
                class_243 rotation = player.method_5720().method_1021(1.0);
                player.method_5762(rotation.method_10216(), 1.0, rotation.method_10215());
                world.method_8396(player, player.method_24515(), class_3417.field_14970, class_3419.field_15248, 1.0f, 1.0f);
                duration = class_3532.method_15375((float)((float)duration / 1.5f));
                user.method_6092(new class_1293(EffectRegistry.CALCULATED_FALL, 600, ConfigConstructor.darkin_blade_ability_damage));
            } else {
                this.detonateGroundEffect(user, ConfigConstructor.darkin_blade_ability_damage, 0.0f, world, stack);
            }
            stack.method_7956(3, user, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
            player.method_7357().method_7906((class_1792)this, duration);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.OMNIVAMP, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.SWORD_SLAM, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.HEAVY, stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("heartbeat", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final DarkinBladeRenderer renderer = new DarkinBladeRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public float getBaseExpansion() {
        return 3.0f;
    }

    @Override
    public float getExpansionModifier() {
        return 1.75f;
    }

    @Override
    public float getLaunchDivisor() {
        return 25.0f;
    }

    @Override
    public boolean shouldHeal() {
        return true;
    }

    @Override
    public class_1293[] applyEffects() {
        return new class_1293[0];
    }

    @Override
    public Map<class_2394, class_243> getParticles() {
        HashMap<class_2394, class_243> map = new HashMap<class_2394, class_243>();
        map.put((class_2394)class_2398.field_11240, new class_243(1.0, 6.0, 1.0));
        return map;
    }
}

