/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_8111;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.Nightfall;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.CustomDamageSource;

public abstract class DetonateGroundItem
extends ChargeToUseItem {
    public DetonateGroundItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public void detonateGroundEffect(class_1309 user, int power, float fallDistance, class_1937 world, class_1799 stack) {
        float pDistance;
        float expansion = this.getBaseExpansion() + this.getExpansionModifier() * fallDistance / 10.0f;
        power = (int)((float)power + fallDistance / 5.0f);
        class_238 box = user.method_5829().method_1014((double)expansion);
        List entities = world.method_8335((class_1297)user, box);
        for (class_1297 targets : entities) {
            if (!(targets instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)targets;
            livingEntity.method_5643(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (class_1297)user), (float)power + class_1890.method_8218((class_1799)stack, (class_1310)livingEntity.method_6046()));
            livingEntity.method_5762(0.0, (double)(fallDistance / this.getLaunchDivisor()), 0.0);
            if (this.shouldHeal()) {
                user.method_6025((float)(ConfigConstructor.lifesteal_item_base_healing - 1) + (ConfigConstructor.lifesteal_item_heal_scales ? (float)power / 10.0f : 0.0f));
            }
            for (class_1293 effect : this.applyEffects()) {
                livingEntity.method_6092(effect);
            }
            DetonateGroundItem detonateGroundItem = this;
            if (!(detonateGroundItem instanceof Nightfall)) continue;
            Nightfall nightfall = (Nightfall)detonateGroundItem;
            nightfall.spawnRemnant(livingEntity, user);
        }
        world.method_8396(null, user.method_24515(), class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
        float f = pDistance = fallDistance >= 25.0f ? fallDistance / 25.0f : 1.0f;
        if (!world.field_9236) {
            ParticleHandler.particleOutburstMap(world, class_3532.method_15375((float)(200.0f * pDistance)), user.method_23317(), user.method_23318(), user.method_23321(), ParticleEvents.BASE_GRAND_SKYFALL_MAP, pDistance);
            for (class_2394 particle : this.getParticles().keySet()) {
                ParticleHandler.particleOutburst(world, class_3532.method_15375((float)(200.0f * pDistance)), user.method_23317(), user.method_23318(), user.method_23321(), particle, this.getParticles().get(particle), pDistance);
            }
        }
    }

    public abstract float getBaseExpansion();

    public abstract float getExpansionModifier();

    public abstract float getLaunchDivisor();

    public abstract boolean shouldHeal();

    public abstract class_1293[] applyEffects();

    public abstract Map<class_2394, class_243> getParticles();

    public static boolean triggerCalculateFall(class_1309 entity, float fallDistance, class_1282 source) {
        if (source.method_49708(class_8111.field_42345) && entity.method_6059(EffectRegistry.CALCULATED_FALL)) {
            class_1293 effect = entity.method_6112(EffectRegistry.CALCULATED_FALL);
            DetonateGroundItem item = WeaponRegistry.COMET_SPEAR;
            class_1799 stack = new class_1799((class_1935)item);
            for (class_1268 hand : class_1268.values()) {
                class_1799 itemStack = entity.method_5998(hand);
                if (!(stack.method_7909() instanceof DetonateGroundItem)) continue;
                item = (DetonateGroundItem)stack.method_7909();
                stack = itemStack;
            }
            item.detonateGroundEffect(entity, effect.method_5578(), fallDistance, entity.method_37908(), stack);
            entity.method_6016(EffectRegistry.CALCULATED_FALL);
            entity.method_6092(new class_1293(EffectRegistry.CALCULATED_FALL, 10, 0));
            return true;
        }
        return false;
    }
}

