/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DragonslayerSwordspearEntity;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public class DragonslayerSwordspear
extends ChargeToUseItem {
    private static final String RAINING = "raining_id";

    public DragonslayerSwordspear(class_1832 toolMaterial, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.dragonslayer_swordspear_damage, attackSpeed, settings);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            int i = this.method_7881(stack) - remainingUseTicks;
            if (i >= 10) {
                if (stack != user.method_6079()) {
                    stack.method_7956(1, (class_1309)playerEntity, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
                    DragonslayerSwordspearEntity entity = new DragonslayerSwordspearEntity(world, (class_1309)playerEntity, stack);
                    entity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, 5.0f, 1.0f);
                    entity.field_7572 = class_1665.class_1666.field_7594;
                    world.method_8649((class_1297)entity);
                    world.method_43129(null, (class_1297)entity, class_3417.field_15001, class_3419.field_15248, 1.0f, 1.0f);
                    playerEntity.method_7357().method_7906((class_1792)this, (ConfigConstructor.dragonslayer_swordspear_throw_cooldown - class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack) * 20) / (world.method_8419() ? 2 : 1));
                } else {
                    stack.method_7956(3, (class_1309)playerEntity, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
                    user.method_6092(new class_1293(class_1294.field_5907, 20, 5));
                    user.method_6092(new class_1293(class_1294.field_5918, 100, 0));
                    class_238 chunkBox = new class_238(user.method_23317() - 10.0, user.method_23318() - 5.0, user.method_23321() - 10.0, user.method_23317() + 10.0, user.method_23318() + 5.0, user.method_23321() + 10.0);
                    List nearbyEntities = world.method_8335((class_1297)user, chunkBox);
                    for (class_1297 nearbyEntity : nearbyEntities) {
                        if (!(nearbyEntity instanceof class_1309)) continue;
                        class_1309 target = (class_1309)nearbyEntity;
                        if (nearbyEntity instanceof class_1321) continue;
                        if (world.method_8311(target.method_24515())) {
                            for (i = 0; i < ConfigConstructor.dragonslayer_swordspear_lightning_amount; ++i) {
                                class_1538 entity = new class_1538(class_1299.field_6112, world);
                                entity.method_23327(target.method_23317(), target.method_23318(), target.method_23321());
                                world.method_8649((class_1297)entity);
                            }
                        } else {
                            double x = target.method_23317() - user.method_23317();
                            double z = target.method_23317() - user.method_23317();
                            target.method_6005(5.0, -x, -z);
                            target.method_5643(world.method_48963().method_48812(user), ConfigConstructor.dragonslayer_swordspear_ability_damage);
                            if (!world.field_9236) {
                                ParticleHandler.particleSphereList(world, 20, target.method_23317(), target.method_23318(), target.method_23321(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
                            }
                        }
                        world.method_8396(null, user.method_24515(), class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
                    }
                    int sharpness = WeaponUtil.getEnchantDamageBonus(stack);
                    playerEntity.method_7357().method_7906((class_1792)this, (ConfigConstructor.dragonslayer_swordspear_ability_cooldown - sharpness * 20) / (world.method_8419() ? 2 : 1));
                }
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        this.updateRaining(world, stack);
    }

    private void updateRaining(class_1937 world, class_1799 stack) {
        if (stack.method_7985()) {
            stack.method_7969().method_10556(RAINING, world.method_8419());
        }
    }

    private boolean getRaining(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545(RAINING)) {
            return stack.method_7969().method_10577(RAINING);
        }
        return false;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173 && this.getRaining(stack)) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)ConfigConstructor.dragonslayer_swordspear_damage, class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", -2.2, class_1322.class_1323.field_6328));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.method_7844(slot);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.LIGHTNING_CALL, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.INFINITY, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.THROW_LIGHTNING, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.STORM_STOMP, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.WEATHERBORN, stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
        super.method_7851(stack, world, tooltip, context);
    }
}

