/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.DraupnirSpearItemRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DraupnirSpearEntity;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DraupnirSpear
extends ChargeToUseItem
implements GeoItem,
IKeybindAbility {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    public static final String SPEARS_ID = "thrown_spears_id";

    public DraupnirSpear(class_1832 toolMaterial, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.draupnir_spear_damage, attackSpeed, settings);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            int i = this.method_7881(stack) - remainingUseTicks;
            if (i >= 10) {
                int enchant = WeaponUtil.getEnchantDamageBonus(stack);
                DraupnirSpearEntity entity = new DraupnirSpearEntity(world, (class_1309)playerEntity, stack);
                entity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, 5.0f, 1.0f);
                entity.field_7572 = class_1665.class_1666.field_7592;
                world.method_8649((class_1297)entity);
                world.method_43129(null, (class_1297)entity, class_3417.field_15001, class_3419.field_15248, 1.0f, 1.0f);
                this.saveSpearData(stack, entity);
                playerEntity.method_7357().method_7906((class_1792)this, ConfigConstructor.draupnir_spear_throw_cooldown - enchant * 5);
                stack.method_7956(1, (class_1309)playerEntity, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
            }
        }
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final DraupnirSpearItemRenderer renderer = new DraupnirSpearItemRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.INFINITY, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.DETONATE_SPEARS, stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    private void saveSpearData(class_1799 stack, DraupnirSpearEntity entity) {
        if (stack.method_7985()) {
            List<Integer> ids = new ArrayList<Integer>();
            if (stack.method_7969().method_10545(SPEARS_ID)) {
                int[] arr = stack.method_7969().method_10561(SPEARS_ID);
                ids = WeaponUtil.arrayToList(arr);
            }
            ids.add(entity.method_5628());
            stack.method_7969().method_10572(SPEARS_ID, ids);
        }
    }

    @Override
    public void useKeybindAbilityServer(class_3218 world, class_1799 stack, class_1657 player) {
        if (!player.method_7357().method_7904(stack.method_7909())) {
            if (player.method_5715()) {
                if (!player.method_6059(EffectRegistry.COOLDOWN)) {
                    int r = 4;
                    world.method_8396(null, player.method_24515(), class_3417.field_15203, class_3419.field_15248, 1.0f, 1.0f);
                    for (int theta = 0; theta < 360; theta += 45) {
                        double x0 = player.method_23317();
                        double z0 = player.method_23321();
                        double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                        double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                        double x1 = Math.cos((double)theta * Math.PI / 180.0);
                        double z1 = Math.sin((double)theta * Math.PI / 180.0);
                        DraupnirSpearEntity entity = new DraupnirSpearEntity((class_1937)world, (class_1309)player, stack);
                        entity.method_23327(x, player.method_23318() + 5.0, z);
                        entity.method_18800(x1, -3.0, z1);
                        entity.field_7572 = class_1665.class_1666.field_7592;
                        world.method_8649((class_1297)entity);
                        this.saveSpearData(stack, entity);
                        ParticleHandler.particleOutburst((class_1937)world, 10, x, player.method_23318() + 5.0, z, (class_2394)class_2398.field_11204, new class_243(4.0, 4.0, 4.0), 0.5f);
                    }
                    if (!player.method_7337()) {
                        player.method_6092(new class_1293(EffectRegistry.COOLDOWN, ConfigConstructor.draupnir_spear_summon_spears_cooldown, 0));
                    }
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Can't cast this ability with Cooldown effect!"), true);
                }
            } else {
                class_238 box = player.method_5829().method_1014(3.0);
                List entities = world.method_8335((class_1297)player, box);
                float power = ConfigConstructor.draupnir_spear_projectile_damage;
                for (class_1297 entity : entities) {
                    if (!(entity instanceof class_1309)) continue;
                    entity.method_5643(world.method_48963().method_48812((class_1309)player), power + class_1890.method_8218((class_1799)stack, (class_1310)((class_1309)entity).method_6046()));
                    entity.method_5762(0.0, (double)0.1f, 0.0);
                }
                ParticleHandler.particleOutburstMap((class_1937)world, 250, player.method_23317(), player.method_23318(), player.method_23321(), ParticleEvents.DEFAULT_GRAND_SKYFALL_MAP, 0.5f);
                world.method_8396(null, player.method_24515(), class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
                player.method_7357().method_7906(stack.method_7909(), ConfigConstructor.draupnir_spear_detonate_cooldown);
                if (stack.method_7985() && stack.method_7969().method_10545(SPEARS_ID)) {
                    int[] ids;
                    for (int id : ids = stack.method_7969().method_10561(SPEARS_ID)) {
                        class_1297 entity = world.method_8469(id);
                        if (!(entity instanceof DraupnirSpearEntity)) continue;
                        DraupnirSpearEntity spear = (DraupnirSpearEntity)entity;
                        spear.detonate();
                    }
                    stack.method_7969().method_10539(SPEARS_ID, new int[0]);
                }
            }
        }
    }

    @Override
    public void useKeybindAbilityClient(class_638 world, class_1799 stack, class_746 player) {
    }
}

