/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.invisible.HolyMoonlightPillar;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.TrickWeapon;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public class HolyMoonlightGreatsword
extends TrickWeapon
implements IChargeNeeded {
    public HolyMoonlightGreatsword(class_1832 toolMaterial, float attackSpeed, class_1792.class_1793 settings, int switchWeaponIndex) {
        super(toolMaterial, 3, attackSpeed, settings, switchWeaponIndex, 3, false, true);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int chargeTime = this.method_7881(stack) - remainingUseTicks;
            if (chargeTime >= 10) {
                if (!player.method_7337()) {
                    int emp = player.method_6059(EffectRegistry.MOON_HERALD) ? 20 * player.method_6112(EffectRegistry.MOON_HERALD).method_5578() : 0;
                    player.method_7357().method_7906((class_1792)this, ConfigConstructor.holy_moonlight_ability_cooldown - class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack) * 30 - emp);
                }
                stack.method_7956(5, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(player.method_6058()));
                int ruptures = ConfigConstructor.holy_moonlight_ruptures_amount + WeaponUtil.getEnchantDamageBonus(stack);
                class_243 vecBlocksAway = player.method_5720().method_1021(3.0).method_1019(player.method_19538());
                class_2338 targetArea = new class_2338((int)vecBlocksAway.field_1352, (int)user.method_23318(), (int)vecBlocksAway.field_1350);
                float power = ConfigConstructor.holy_moonlight_ability_damage;
                for (class_1297 entity : world.method_8335((class_1297)player, new class_238(targetArea).method_1014(3.0))) {
                    if (!(entity instanceof class_1309)) continue;
                    entity.method_5643(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (class_1297)player), power + 2.0f * class_1890.method_8218((class_1799)stack, (class_1310)((class_1309)entity).method_6046()));
                    entity.method_5762(0.0, (double)this.getKnockup(stack), 0.0);
                }
                if (!world.field_9236) {
                    this.castSpell((class_1309)player, world, stack, ruptures, this.getAbilityDamage(), this.getKnockup(stack), user.method_36454() + 90.0f);
                }
                if (stack.method_7985() && !player.method_7337()) {
                    stack.method_7969().method_10569("current_charge", 0);
                }
                world.method_8396(player, targetArea, SoundRegistry.MOONLIGHT_BIG_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                world.method_8396(player, targetArea, class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
                if (!world.field_9236) {
                    ParticleHandler.particleOutburstMap(player.method_37908(), 150, vecBlocksAway.method_10216(), user.method_23318(), vecBlocksAway.method_10215(), ParticleEvents.MOONFALL_MAP, 1.0f);
                }
            }
        }
    }

    public void castSpell(class_1309 user, class_1937 world, class_1799 stack, class_243 startPos, int amount, float damage, float knockup, float yaw, float particleMod, float radius) {
        double maxY = startPos.method_10214();
        double y = startPos.method_10214() + 1.0;
        float f = (float)Math.toRadians(yaw);
        for (int i = 0; i < amount; ++i) {
            double h = 1.75 * (double)(i + 1);
            this.summonPillars(user, world, stack, startPos.method_10216() + (double)class_3532.method_15362((float)f) * h, startPos.method_10215() + (double)class_3532.method_15374((float)f) * h, maxY, y, -6 + i * 2, damage, knockup, particleMod, radius);
        }
    }

    private void summonPillars(class_1309 user, class_1937 world, class_1799 stack, double x, double z, double maxY, double y, int warmup, float damage, float knockup, float particleMod, float radius) {
        class_2338 blockPos = new class_2338((int)x, (int)y, (int)z);
        boolean bl = false;
        double d = 0.0;
        do {
            class_265 voxelShape;
            class_2338 blockPos2;
            if (!world.method_8320(blockPos2 = blockPos.method_10074()).method_26206((class_1922)world, blockPos2, class_2350.field_11036)) continue;
            if (!world.method_22347(blockPos) && !(voxelShape = world.method_8320(blockPos).method_26220((class_1922)world, blockPos)).method_1110()) {
                d = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
        if (bl) {
            HolyMoonlightPillar pillar = new HolyMoonlightPillar(EntityRegistry.HOLY_MOONLIGHT_PILLAR, world);
            pillar.method_7432((class_1297)user);
            pillar.setStack(stack);
            pillar.setParticleMod(particleMod);
            pillar.setRadius(radius);
            pillar.method_7438(damage);
            pillar.setKnockUp(knockup);
            pillar.setWarmup(warmup);
            pillar.method_23327(x, (double)blockPos.method_10264() + d, z);
            world.method_8649((class_1297)pillar);
        }
    }

    public void castSpell(class_1309 user, class_1937 world, class_1799 stack, int amount, float damage, float knockup, float yaw) {
        this.castSpell(user, world, stack, user.method_19538(), amount, damage, knockup, yaw, 1.0f, 1.85f);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        this.addCharge(stack, this.getAddedCharge(stack));
        return super.method_7873(stack, target, attacker);
    }

    private float getAbilityDamage() {
        return ConfigConstructor.holy_moonlight_ability_damage;
    }

    private float getKnockup(class_1799 stack) {
        return ConfigConstructor.holy_moonlight_ability_knockup + (float)WeaponUtil.getEnchantDamageBonus(stack) / 10.0f;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() < itemStack.method_7936() - 1 && (this.isCharged(itemStack) || user.method_7337() || user.method_6059(EffectRegistry.MOON_HERALD))) {
            user.method_6019(hand);
            return class_1271.method_22427((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.TRICK_WEAPON, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.NEED_CHARGE, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.LUNAR_HERALD_NO_CHARGE, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.CHARGE, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.MOONFALL, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.RIGHTEOUS, stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
    }

    @Override
    public int getMaxCharge() {
        return ConfigConstructor.holy_moonlight_ability_charge_needed;
    }

    @Override
    public int getAddedCharge(class_1799 stack) {
        int base = ConfigConstructor.holy_moonlight_greatsword_charge_added_post_hit;
        return base + WeaponUtil.getEnchantDamageBonus(stack) * 2;
    }
}

