/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.KrakenSlayerProjectile;
import net.soulsweaponry.items.ModdedCrossbow;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public class KrakenSlayerCrossbow
extends ModdedCrossbow {
    public KrakenSlayerCrossbow(class_1792.class_1793 settings) {
        super(settings);
    }

    @Override
    public void shootProjectiles(class_1937 world, class_1309 entity, class_1268 hand, class_1799 stack, float speed, float divergence) {
        if (this.isEmpowered(stack)) {
            List<class_1799> list = this.getProjectiles(stack);
            float[] soundPitches = this.getSoundPitches(entity.method_6051());
            boolean bl = entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477;
            for (int i = 0; i < list.size(); ++i) {
                KrakenSlayerProjectile projectile;
                class_1799 arrowStack = list.get(i);
                if (arrowStack.method_7960()) continue;
                if (i == 0) {
                    projectile = new KrakenSlayerProjectile(world, entity);
                    this.shoot(world, entity, hand, stack, projectile, arrowStack, soundPitches[i], bl, speed, divergence, 0.0f);
                    continue;
                }
                if (i == 1) {
                    projectile = new KrakenSlayerProjectile(world, entity);
                    this.shoot(world, entity, hand, stack, projectile, arrowStack, soundPitches[i], bl, speed, divergence, -10.0f);
                    continue;
                }
                if (i != 2) continue;
                projectile = new KrakenSlayerProjectile(world, entity);
                this.shoot(world, entity, hand, stack, projectile, arrowStack, soundPitches[i], bl, speed, divergence, 10.0f);
            }
            this.postShoot(world, entity, stack);
        } else {
            super.shootProjectiles(world, entity, hand, stack, speed, divergence);
        }
    }

    public boolean isEmpowered(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545("firedShots") && stack.method_7969().method_10550("firedShots") >= 2) {
            stack.method_7969().method_10569("firedShots", 0);
            return true;
        }
        if (stack.method_7985()) {
            if (stack.method_7969().method_10545("firedShots")) {
                stack.method_7969().method_10569("firedShots", stack.method_7969().method_10550("firedShots") + 1);
            } else {
                stack.method_7969().method_10569("firedShots", 1);
            }
        }
        return false;
    }

    @Override
    public float getSpeed(class_1799 stack, class_1657 player) {
        return 3.15f;
    }

    @Override
    public float getDivergence(class_1799 stack, class_1657 player) {
        return 1.0f;
    }

    @Override
    public void modifyProjectile(class_1665 projectile, class_1799 stack) {
        float bonus = (float)class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack) / 4.0f;
        if (projectile instanceof KrakenSlayerProjectile) {
            KrakenSlayerProjectile kraken = (KrakenSlayerProjectile)projectile;
            kraken.setTrueDamage(ConfigConstructor.kraken_slayer_bonus_true_damage);
        }
        projectile.method_7438(projectile.method_7448() + (double)bonus);
    }

    @Override
    public float getReducedPullTime() {
        return ConfigConstructor.kraken_slayer_reduced_pull_time;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.FAST_PULL, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.THIRD_SHOT, stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
        super.method_7851(stack, world, tooltip, context);
    }
}

