/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1744;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3745;
import net.minecraft.class_5819;
import net.soulsweaponry.items.IReducedPullTime;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class ModdedCrossbow
extends class_1764
implements IReducedPullTime {
    private boolean loaded = false;
    private boolean charged = false;
    private static final String CHARGED_PROJECTILES_KEY = "ChargedProjectiles";

    public ModdedCrossbow(class_1792.class_1793 settings) {
        super(settings);
    }

    public Predicate<class_1799> method_20310() {
        return field_18281;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (class_1764.method_7781((class_1799)itemStack)) {
            this.shootProjectiles(world, (class_1309)user, hand, itemStack, this.getSpeed(itemStack, user), this.getDivergence(itemStack, user));
            class_1764.method_7782((class_1799)itemStack, (boolean)false);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!user.method_18808(itemStack).method_7960()) {
            if (!class_1764.method_7781((class_1799)itemStack)) {
                this.charged = false;
                this.loaded = false;
                user.method_6019(hand);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i = this.method_7881(stack) - remainingUseTicks;
        float f = this.getModdedPullProgress(i, stack);
        if (f >= 1.0f && !class_1764.method_7781((class_1799)stack) && this.loadProjectiles(user, stack)) {
            class_1764.method_7782((class_1799)stack, (boolean)true);
            class_3419 soundCategory = user instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14626, soundCategory, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private boolean loadProjectiles(class_1309 shooter, class_1799 crossbow) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)crossbow);
        int j = i == 0 ? 1 : 3;
        boolean bl = shooter instanceof class_1657 && ((class_1657)shooter).method_31549().field_7477;
        class_1799 itemStack = shooter.method_18808(crossbow);
        class_1799 itemStack2 = itemStack.method_7972();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack = itemStack2.method_7972();
            }
            if (itemStack.method_7960() && bl) {
                itemStack = new class_1799((class_1935)class_1802.field_8107);
                itemStack2 = itemStack.method_7972();
            }
            if (this.loadProjectile(shooter, crossbow, itemStack, k > 0, bl)) continue;
            return false;
        }
        return true;
    }

    private boolean loadProjectile(class_1309 shooter, class_1799 crossbow, class_1799 projectile, boolean simulated, boolean creative) {
        class_1799 itemStack;
        boolean bl;
        boolean bl2 = bl = creative && projectile.method_7909() instanceof class_1744;
        if (projectile.method_7960()) {
            return false;
        }
        if (!(bl || creative || simulated)) {
            itemStack = projectile.method_7971(1);
            if (projectile.method_7960() && shooter instanceof class_1657) {
                ((class_1657)shooter).method_31548().method_7378(projectile);
            }
        } else {
            itemStack = projectile.method_7972();
        }
        this.putProjectile(crossbow, itemStack);
        return true;
    }

    private void putProjectile(class_1799 crossbow, class_1799 projectile) {
        class_2487 nbtCompound = crossbow.method_7948();
        class_2499 nbtList = nbtCompound.method_10573(CHARGED_PROJECTILES_KEY, 9) ? nbtCompound.method_10554(CHARGED_PROJECTILES_KEY, 10) : new class_2499();
        class_2487 nbtCompound2 = new class_2487();
        projectile.method_7953(nbtCompound2);
        nbtList.add((Object)nbtCompound2);
        nbtCompound.method_10566(CHARGED_PROJECTILES_KEY, (class_2520)nbtList);
    }

    public abstract float getSpeed(class_1799 var1, class_1657 var2);

    public abstract float getDivergence(class_1799 var1, class_1657 var2);

    public abstract void modifyProjectile(class_1665 var1, class_1799 var2);

    public void shootProjectiles(class_1937 world, class_1309 entity, class_1268 hand, class_1799 stack, float speed, float divergence) {
        List<class_1799> list = this.getProjectiles(stack);
        float[] soundPitches = this.getSoundPitches(entity.method_6051());
        boolean bl = entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477;
        for (int i = 0; i < list.size(); ++i) {
            class_1665 projectile;
            class_1799 arrowStack = list.get(i);
            if (arrowStack.method_7960()) continue;
            if (i == 0) {
                projectile = this.createArrow(world, entity, stack, arrowStack);
                this.shoot(world, entity, hand, stack, projectile, arrowStack, soundPitches[i], bl, speed, divergence, 0.0f);
                continue;
            }
            if (i == 1) {
                projectile = this.createArrow(world, entity, stack, arrowStack);
                this.shoot(world, entity, hand, stack, projectile, arrowStack, soundPitches[i], bl, speed, divergence, -10.0f);
                continue;
            }
            if (i != 2) continue;
            projectile = this.createArrow(world, entity, stack, arrowStack);
            this.shoot(world, entity, hand, stack, projectile, arrowStack, soundPitches[i], bl, speed, divergence, 10.0f);
        }
        this.postShoot(world, entity, stack);
    }

    public void shoot(class_1937 world, class_1309 shooter, class_1268 hand, class_1799 crossbow, class_1665 projectile, class_1799 arrowStack, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (world.field_9236) {
            return;
        }
        this.modifyProjectile(projectile, crossbow);
        this.applyPiercing(projectile, crossbow);
        projectile.method_23327(shooter.method_23317(), shooter.method_23318() + 1.5, shooter.method_23321());
        projectile.method_7432((class_1297)shooter);
        if (creative || simulated != 0.0f) {
            projectile.field_7572 = class_1665.class_1666.field_7594;
        }
        if (shooter instanceof class_3745) {
            class_3745 crossbowUser = (class_3745)shooter;
            crossbowUser.method_18811(crossbowUser.method_5968(), crossbow, (class_1676)projectile, simulated);
        } else {
            class_243 vec3d = shooter.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            class_243 vec3d2 = shooter.method_5828(1.0f);
            Vector3f vector3f = vec3d2.method_46409().rotate((Quaternionfc)quaternionf);
            projectile.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
        }
        crossbow.method_7956(1, shooter, e -> e.method_20236(hand));
        world.method_8649((class_1297)projectile);
        world.method_43128(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15187, class_3419.field_15248, 1.0f, soundPitch);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
            class_3414 soundEvent = this.getQuickChargeSound(i);
            class_3414 soundEvent2 = i == 0 ? class_3417.field_14860 : null;
            float f = (float)(stack.method_7935() - remainingUseTicks) / (float)this.getModdedPullTime(stack);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent, class_3419.field_15248, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.loaded) {
                this.loaded = true;
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent2, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
    }

    public float getModdedPullProgress(int useTicks, class_1799 stack) {
        float f = (float)useTicks / (float)this.getModdedPullTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getModdedPullTime(class_1799 stack) {
        return 25 - 5 * class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack) - (int)this.getReducedPullTime();
    }

    private class_3414 getQuickChargeSound(int stage) {
        switch (stage) {
            case 1: {
                return class_3417.field_15011;
            }
            case 2: {
                return class_3417.field_14916;
            }
            case 3: {
                return class_3417.field_15089;
            }
        }
        return class_3417.field_14765;
    }

    public void postShoot(class_1937 world, class_1309 entity, class_1799 stack) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            if (!world.field_9236) {
                class_174.field_1196.method_9115(serverPlayerEntity, stack);
            }
            serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        }
        this.clearProjectiles(stack);
    }

    public void applyPiercing(class_1665 projectile, class_1799 crossbow) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)crossbow);
        if (i > 0) {
            projectile.method_7451((byte)i);
        }
    }

    public class_1665 createArrow(class_1937 world, class_1309 entity, class_1799 crossbow, class_1799 arrow) {
        class_1744 arrowItem = (class_1744)(arrow.method_7909() instanceof class_1744 ? arrow.method_7909() : class_1802.field_8107);
        class_1665 persistentProjectileEntity = arrowItem.method_7702(world, arrow, entity);
        if (entity instanceof class_1657) {
            persistentProjectileEntity.method_7439(true);
        }
        persistentProjectileEntity.method_7444(class_3417.field_14636);
        persistentProjectileEntity.method_7442(true);
        this.applyPiercing(persistentProjectileEntity, crossbow);
        return persistentProjectileEntity;
    }

    private void clearProjectiles(class_1799 crossbow) {
        class_2487 nbtCompound = crossbow.method_7969();
        if (nbtCompound != null) {
            class_2499 nbtList = nbtCompound.method_10554(CHARGED_PROJECTILES_KEY, 9);
            nbtList.clear();
            nbtCompound.method_10566(CHARGED_PROJECTILES_KEY, (class_2520)nbtList);
        }
    }

    public float[] getSoundPitches(class_5819 random) {
        boolean bl = random.method_43056();
        return new float[]{1.0f, this.getSoundPitch(bl, random), this.getSoundPitch(!bl, random)};
    }

    private float getSoundPitch(boolean flag, class_5819 random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }

    public List<class_1799> getProjectiles(class_1799 crossbow) {
        class_2499 nbtList;
        ArrayList list = Lists.newArrayList();
        class_2487 nbtCompound = crossbow.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573(CHARGED_PROJECTILES_KEY, 9) && (nbtList = nbtCompound.method_10554(CHARGED_PROJECTILES_KEY, 10)) != null) {
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound2 = nbtList.method_10602(i);
                list.add(class_1799.method_7915((class_2487)nbtCompound2));
            }
        }
        return list;
    }
}

