/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.NightfallRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entitydata.IEntityDataSaver;
import net.soulsweaponry.entitydata.SummonsData;
import net.soulsweaponry.items.ISummonAllies;
import net.soulsweaponry.items.UltraHeavyWeapon;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Nightfall
extends UltraHeavyWeapon
implements GeoItem,
IKeybindAbility,
ISummonAllies {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public Nightfall(class_1832 toolMaterial, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.nightfall_damage, attackSpeed, settings, true);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int i = this.method_7881(stack) - remainingUseTicks;
            if (i >= 10) {
                if (!player.method_7337()) {
                    player.method_7357().method_7906((class_1792)this, ConfigConstructor.nightfall_smash_cooldown - class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack) * 50);
                }
                stack.method_7956(3, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(player.method_6058()));
                class_243 vecBlocksAway = player.method_5720().method_1021(3.0).method_1019(player.method_19538());
                class_2338 targetArea = new class_2338((int)vecBlocksAway.field_1352, (int)user.method_23318(), (int)vecBlocksAway.field_1350);
                class_238 aoe = new class_238(targetArea).method_1014(3.0);
                List entities = world.method_8335((class_1297)player, aoe);
                float power = ConfigConstructor.nightfall_ability_damage;
                for (class_1297 entity : entities) {
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 target = (class_1309)entity;
                    entity.method_5643(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (class_1297)player), power + 2.0f * class_1890.method_8218((class_1799)stack, (class_1310)((class_1309)entity).method_6046()));
                    entity.method_18800(entity.method_18798().field_1352, 0.5, entity.method_18798().field_1350);
                    this.spawnRemnant(target, user);
                }
                world.method_8396(player, targetArea, SoundRegistry.NIGHTFALL_BONK_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                if (!world.field_9236) {
                    ParticleHandler.particleOutburstMap(world, 150, targetArea.method_10263(), (float)targetArea.method_10264() + 0.1f, targetArea.method_10260(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                }
            }
        }
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        this.spawnRemnant(target, attacker);
        this.gainStrength(attacker);
        return super.method_7873(stack, target, attacker);
    }

    public void spawnRemnant(class_1309 target, class_1309 attacker) {
        if (target.method_5999() && target.method_29504() && attacker instanceof class_1657) {
            double chance = new Random().nextDouble();
            class_1937 world = attacker.method_5770();
            if (!world.field_9236 && this.canSummonEntity((class_3218)world, attacker, this.getSummonsListId()) && chance < ConfigConstructor.nightfall_summon_chance) {
                Remnant entity = new Remnant(EntityRegistry.REMNANT, world);
                entity.method_23327(target.method_23317(), target.method_23318() + (double)0.1f, target.method_23321());
                entity.method_6170((class_1657)attacker);
                world.method_8649((class_1297)entity);
                this.saveSummonUuid(attacker, entity.method_5667());
                world.method_8396(null, target.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                if (!attacker.method_37908().field_9236) {
                    ParticleHandler.particleOutburstMap(attacker.method_37908(), 50, target.method_23317(), target.method_23318(), target.method_23321(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final NightfallRenderer renderer = new NightfallRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.SUMMON_GHOST, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.SHIELD, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.OBLITERATE, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.HEAVY, stack, tooltip);
            for (int i = 1; i <= 3; ++i) {
                tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.soulsweapons.nightfall.part_" + i)).method_27692(class_124.field_1063));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public void useKeybindAbilityServer(class_3218 world, class_1799 stack, class_1657 player) {
        if (!player.method_7357().method_7904((class_1792)this)) {
            player.method_7357().method_7906((class_1792)this, ConfigConstructor.nightfall_shield_cooldown - class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack) * 100);
            stack.method_7956(3, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(player.method_6058()));
            player.method_6092(new class_1293(class_1294.field_5898, 200, ConfigConstructor.nightfall_ability_shield_power));
            player.method_6092(new class_1293(class_1294.field_5907, 200, 0));
            world.method_8396(null, player.method_24515(), SoundRegistry.NIGHTFALL_SHIELD_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    @Override
    public void useKeybindAbilityClient(class_638 world, class_1799 stack, class_746 player) {
    }

    @Override
    public float getBaseExpansion() {
        return 3.0f;
    }

    @Override
    public float getExpansionModifier() {
        return 1.5f;
    }

    @Override
    public float getLaunchDivisor() {
        return 30.0f;
    }

    @Override
    public boolean shouldHeal() {
        return false;
    }

    @Override
    public class_1293[] applyEffects() {
        return new class_1293[0];
    }

    @Override
    public Map<class_2394, class_243> getParticles() {
        HashMap<class_2394, class_243> map = new HashMap<class_2394, class_243>();
        map.put((class_2394)class_2398.field_22246, new class_243(1.0, 6.0, 1.0));
        return map;
    }

    @Override
    public int getMaxSummons() {
        return ConfigConstructor.nightfall_summoned_allies_cap;
    }

    @Override
    public String getSummonsListId() {
        return "NightfallSummons";
    }

    @Override
    public void saveSummonUuid(class_1309 user, UUID summonUuid) {
        SummonsData.addSummonUUID((IEntityDataSaver)user, summonUuid, this.getSummonsListId());
    }
}

