/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.SoulReaperRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Forlorn;
import net.soulsweaponry.entity.mobs.SoulReaperGhost;
import net.soulsweaponry.entity.mobs.Soulmass;
import net.soulsweaponry.entitydata.IEntityDataSaver;
import net.soulsweaponry.entitydata.SummonsData;
import net.soulsweaponry.items.ISummonAllies;
import net.soulsweaponry.items.SoulHarvestingItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulReaper
extends SoulHarvestingItem
implements GeoItem,
ISummonAllies {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public SoulReaper(class_1832 toolMaterial, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.soul_reaper_damage, attackSpeed, settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7985() && stack.method_7969().method_10545("kills")) {
            int power = this.getSouls(stack);
            if (player.method_7337()) {
                power = player.method_6051().method_39332(5, 50);
            }
            if (power >= 3 && !world.field_9236 && this.canSummonEntity((class_3218)world, (class_1309)player, this.getSummonsListId())) {
                class_243 vecBlocksAway = player.method_5720().method_1021(3.0).method_1019(player.method_19538());
                ParticleHandler.particleOutburstMap(world, 50, vecBlocksAway.method_10216(), vecBlocksAway.method_10214(), vecBlocksAway.method_10215(), ParticleEvents.CONJURE_ENTITY_MAP, 1.0f);
                world.method_8396(null, player.method_24515(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, class_3419.field_15248, 0.8f, 1.0f);
                if (power < 10) {
                    SoulReaperGhost entity = new SoulReaperGhost(EntityRegistry.SOUL_REAPER_GHOST, world);
                    entity.method_23327(vecBlocksAway.field_1352, player.method_23318() + (double)0.1f, vecBlocksAway.field_1350);
                    entity.method_6170(player);
                    world.method_8649((class_1297)entity);
                    this.saveSummonUuid((class_1309)player, entity.method_5667());
                    if (!player.method_7337()) {
                        this.addAmount(stack, -3);
                    }
                } else if (player.method_5715() || power < 30) {
                    Forlorn entity = new Forlorn(EntityRegistry.FORLORN, world);
                    entity.method_23327(vecBlocksAway.field_1352, player.method_23318() + (double)0.1f, vecBlocksAway.field_1350);
                    entity.method_6170(player);
                    world.method_8649((class_1297)entity);
                    this.saveSummonUuid((class_1309)player, entity.method_5667());
                    if (!player.method_7337()) {
                        this.addAmount(stack, -10);
                    }
                } else {
                    Soulmass entity = new Soulmass(EntityRegistry.SOULMASS, world);
                    entity.method_23327(vecBlocksAway.field_1352, player.method_23318() + (double)0.1f, vecBlocksAway.field_1350);
                    entity.method_6170(player);
                    world.method_8649((class_1297)entity);
                    this.saveSummonUuid((class_1309)player, entity.method_5667());
                    if (!player.method_7337()) {
                        this.addAmount(stack, -30);
                    }
                }
                stack.method_7956(3, (class_1309)player, p_220045_0_ -> p_220045_0_.method_20236(hand));
                return class_1271.method_29237((Object)stack, (boolean)true);
            }
        }
        return class_1271.method_22431((Object)stack);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.SOUL_TRAP, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.SOUL_RELEASE, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.COLLECT, stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("low_souls", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final SoulReaperRenderer renderer = new SoulReaperRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public int getMaxSummons() {
        return ConfigConstructor.soul_reaper_summoned_allies_cap;
    }

    @Override
    public String getSummonsListId() {
        return "SoulReaperSummons";
    }

    @Override
    public void saveSummonUuid(class_1309 user, UUID summonUuid) {
        SummonsData.addSummonUUID((IEntityDataSaver)user, summonUuid, this.getSummonsListId());
    }
}

