/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1674;
import net.minecraft.class_1676;
import net.minecraft.class_1677;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1683;
import net.minecraft.class_1684;
import net.minecraft.class_1687;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.DragonStaffProjectile;
import net.soulsweaponry.entity.projectile.GrowingFireball;
import net.soulsweaponry.entity.projectile.WitheredWabbajackProjectile;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public class WitheredWabbajack
extends class_1829 {
    public WitheredWabbajack(class_1832 toolMaterial, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.withered_wabbajack_damage, attackSpeed, settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_7357().method_7906((class_1792)this, 1);
        world.method_43128(user, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14934, class_3419.field_15254, 0.5f, 2.0f / (world.method_8409().method_43057() * 0.4f + 0.8f));
        if (!world.field_9236) {
            class_243 look = user.method_5720();
            class_1676 entity = this.calculateProjectile((class_1309)user, world, look, itemStack);
            if (entity instanceof DragonStaffProjectile) {
                DragonStaffProjectile dragonStaffProjectile = (DragonStaffProjectile)entity;
                dragonStaffProjectile.setRadius(2.0f + user.method_6051().method_43057() * (float)this.getLuckFactor((class_1309)user));
            }
            entity.method_23327(user.method_23317(), user.method_23320(), user.method_23321());
            if (entity instanceof GrowingFireball) {
                GrowingFireball ball = (GrowingFireball)entity;
                float power = 1.0f + user.method_6051().method_43057() * 10.0f * (float)this.getLuckFactor((class_1309)user);
                int duration = user.method_6051().method_39332(10, 100 + 20 * this.getLuckFactor((class_1309)user));
                float speed = (float)user.method_6051().method_39332(25, 300 + 20 * this.getLuckFactor((class_1309)user)) / 100.0f;
                ball.setMaxAge(duration);
                ball.setRadiusGrowth(power / (float)duration);
                ball.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, speed, 0.0f);
            } else {
                entity.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 1.5f, 0.0f);
            }
            world.method_8649((class_1297)entity);
            itemStack.method_7956(1, (class_1309)user, p_220045_0_ -> p_220045_0_.method_20236(hand));
        }
        return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
    }

    /*
     * WARNING - void declaration
     */
    private class_1676 calculateProjectile(class_1309 user, class_1937 world, class_243 look, class_1799 stack) {
        void var10_14;
        int power = new Random().nextInt(6 + this.getLuckFactor(user) - this.getLuckFactor(user)) + this.getLuckFactor(user);
        Object[][] projectileTypes = new Object[][]{{new class_1667(world, look.method_10216(), look.method_10214(), look.method_10215()), LuckType.BAD}, {new DragonStaffProjectile(world, user, stack), LuckType.NEUTRAL}, {new class_1681(world, look.method_10216(), look.method_10214(), look.method_10215()), LuckType.BAD}, {new class_1684(world, user), LuckType.BAD}, {new class_1683(world, look.method_10216(), look.method_10214(), look.method_10215()), LuckType.BAD}, {new class_1674(world, user, look.method_10216(), look.method_10214(), look.method_10215(), power), LuckType.NEUTRAL}, {new class_1677(world, user, look.method_10216(), look.method_10214(), look.method_10215()), LuckType.BAD}, {new class_1680(world, look.method_10216(), look.method_10214(), look.method_10215()), LuckType.BAD}, {new class_1687(world, user, look.method_10216(), look.method_10214(), look.method_10215()), LuckType.BAD}, {new WitheredWabbajackProjectile(world, user, look.method_10216(), look.method_10214(), look.method_10215()), LuckType.GOOD}, {new GrowingFireball(world, (class_1297)user), LuckType.NEUTRAL}};
        ArrayList projectileList = new ArrayList();
        Object[][] objectArrayArray = projectileTypes;
        int n = objectArrayArray.length;
        boolean bl = false;
        while (var10_14 < n) {
            int luckFactor;
            Object[] projectileType = objectArrayArray[var10_14];
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(projectileType[0]);
            list.add(projectileType[1]);
            switch ((LuckType)((Object)list.get(1))) {
                case BAD: {
                    luckFactor = 10 - this.getLuckFactor(user);
                    list.add(luckFactor);
                    break;
                }
                case GOOD: {
                    luckFactor = 10 + this.getLuckFactor(user);
                    list.add(luckFactor);
                    break;
                }
                default: {
                    luckFactor = 10;
                    list.add(luckFactor);
                }
            }
            if (luckFactor > 0) {
                projectileList.add(list);
            }
            ++var10_14;
        }
        int totalChance = 0;
        for (ArrayList arrayList : projectileList) {
            totalChance += ((Integer)arrayList.get(2)).intValue();
        }
        int random = new Random().nextInt(totalChance);
        boolean bl2 = false;
        int under = 0;
        class_1676 chosenProjectile = null;
        for (int i = 0; i < projectileList.size(); ++i) {
            void var10_17;
            var10_17 += ((Integer)((ArrayList)projectileList.get(i)).get(2)).intValue();
            if (i > 0) {
                under += ((Integer)((ArrayList)projectileList.get(i - 1)).get(2)).intValue();
            }
            if (random >= var10_17 || random < under) continue;
            chosenProjectile = (class_1676)((ArrayList)projectileList.get(i)).get(0);
        }
        return chosenProjectile;
    }

    public int getLuckFactor(class_1309 entity) {
        if (entity.method_6059(class_1294.field_5926)) {
            return entity.method_6112(class_1294.field_5926).method_5578() * 2 + 2;
        }
        if (entity.method_6059(class_1294.field_5908)) {
            return -(entity.method_6112(class_1294.field_5908).method_5578() * 2 + 2);
        }
        return 0;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.WABBAJACK, stack, tooltip);
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.LUCK_BASED, stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public static enum LuckType {
        GOOD,
        NEUTRAL,
        BAD;

    }
}

