/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import net.minecraft.class_437;
import net.minecraft.class_572;
import net.minecraft.class_5819;
import net.soulsweaponry.blocks.WitheredBlock;
import net.soulsweaponry.blocks.WitheredFlower;
import net.soulsweaponry.blocks.WitheredGrass;
import net.soulsweaponry.blocks.WitheredTallFlower;
import net.soulsweaponry.blocks.WitheredTallGrass;
import net.soulsweaponry.client.renderer.armor.ChaosArmorRenderer;
import net.soulsweaponry.client.renderer.armor.ChaosSetRenderer;
import net.soulsweaponry.client.renderer.armor.EChaosArmorRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChaosSet
extends class_1738
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final HashMap<class_2248, WitheredBlock> turnableBlocks = new HashMap();
    private final HashMap<class_2248, WitheredGrass> turnableGrass = new HashMap();
    private final HashMap<class_2248, WitheredTallGrass> turnableTallPlant = new HashMap();
    private static final HashMap<class_1291, class_1291> FLIPPABLE_EFFECTS = new HashMap();

    public ChaosSet(class_1741 material, class_1738.class_8051 slot, class_1792.class_1793 settings) {
        super(material, slot, settings);
        this.turnableBlocks.put(class_2246.field_10219, BlockRegistry.WITHERED_GRASS_BLOCK);
        this.turnableBlocks.put(class_2246.field_10566, BlockRegistry.WITHERED_DIRT);
        this.turnableGrass.put(class_2246.field_10479, BlockRegistry.WITHERED_GRASS);
        this.turnableGrass.put(class_2246.field_10112, BlockRegistry.WITHERED_FERN);
        this.turnableGrass.put(class_2246.field_16999, BlockRegistry.WITHERED_BERRY_BUSH);
        this.turnableTallPlant.put(class_2246.field_10214, BlockRegistry.WITHERED_TALL_GRASS);
        this.turnableTallPlant.put(class_2246.field_10313, BlockRegistry.WITHERED_LARGE_FERN);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (this.isHelmetEquipped(player)) {
                player.method_6092(new class_1293(class_1294.field_5926, 40, 0));
                if (!player.method_7357().method_7904(ItemRegistry.CHAOS_CROWN) && !player.method_7357().method_7904(ItemRegistry.CHAOS_HELMET)) {
                    this.flipEffects(player);
                }
            }
            if (this.isRobesEquipped(player)) {
                this.turnBlocks((class_1309)player, world, player.method_24515(), 0);
                if (player.field_6012 % 40 == 0) {
                    for (class_1309 target : world.method_18467(class_1309.class, player.method_5829().method_1014(3.0))) {
                        if (target instanceof class_1657 || target == player) continue;
                        target.method_6092(new class_1293(class_1294.field_5920, 80, 1));
                    }
                }
            }
            if (this.isChestActive(player)) {
                class_1799 chest = player.method_31548().method_7372(2);
                player.method_6092(new class_1293(class_1294.field_5907, 40, 1));
                if (!world.field_9236 && !player.method_7357().method_7904(chest.method_7909()) && player.method_6065() != null) {
                    this.shockwave(world, player);
                }
            }
        }
    }

    public void turnBlocks(class_1309 entity, class_1937 world, class_2338 blockPos, int bonusRadius) {
        if (!entity.method_24828()) {
            return;
        }
        int f = Math.min(16, 3 + bonusRadius);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2338 blockPos2 : class_2338.method_10097((class_2338)blockPos.method_10069(-f, -1, -f), (class_2338)blockPos.method_10069(f, -1, f))) {
            if (world.method_8320(blockPos2).method_26215()) continue;
            for (class_2248 turnBlock : this.turnableBlocks.keySet()) {
                if (world.method_8320(blockPos2).method_26204() == turnBlock) {
                    class_2680 blockState = this.turnableBlocks.get(turnBlock).method_9564();
                    if (!blockPos2.method_19769((class_2374)entity.method_19538(), (double)f)) continue;
                    mutable.method_10103(blockPos2.method_10263(), blockPos2.method_10264() + 1, blockPos2.method_10260());
                    class_2680 blockState2 = world.method_8320((class_2338)mutable);
                    if (blockState2.method_26164(class_3481.field_15480)) {
                        world.method_8501((class_2338)mutable, (class_2680)BlockRegistry.HYDRANGEA.method_9564().method_11657((class_2769)WitheredFlower.CANNOT_TURN, (Comparable)Boolean.valueOf(false)));
                    }
                    for (class_2248 turnGrass : this.turnableGrass.keySet()) {
                        if (!blockState2.method_27852(turnGrass)) continue;
                        world.method_8501((class_2338)mutable, this.turnableGrass.get(turnGrass).method_9564());
                    }
                    for (class_2248 turnTallPlant : this.turnableTallPlant.keySet()) {
                        if (!blockState2.method_27852(turnTallPlant)) continue;
                        world.method_8650((class_2338)mutable, false);
                        class_2320.method_10021((class_1936)world, (class_2680)this.turnableTallPlant.get(turnTallPlant).method_9564(), (class_2338)mutable, (int)2);
                    }
                    if (blockState2.method_26164(class_3481.field_20338)) {
                        world.method_8650((class_2338)mutable, false);
                        class_2320.method_10021((class_1936)world, (class_2680)((class_2680)BlockRegistry.OLEANDER.method_9564().method_11657((class_2769)WitheredTallFlower.CANNOT_TURN, (Comparable)Boolean.valueOf(false))), (class_2338)mutable, (int)2);
                    }
                    world.method_8501(blockPos2, blockState);
                    world.method_39279(blockPos2, (class_2248)this.turnableBlocks.get(turnBlock), class_3532.method_15395((class_5819)entity.method_6051(), (int)50, (int)90));
                    continue;
                }
                if (world.method_8320(blockPos2).method_26204() != this.turnableBlocks.get(turnBlock)) continue;
                WitheredBlock block = (WitheredBlock)world.method_8320(blockPos2).method_26204();
                block.resetAge(world.method_8320(blockPos2), world, blockPos2);
            }
        }
    }

    private void flipEffects(class_1657 player) {
        ArrayList statusEffectsCopy = new ArrayList(player.method_6026());
        ArrayList<class_1291> effectsToRemove = new ArrayList<class_1291>();
        boolean triggered = false;
        for (class_1293 instance : statusEffectsCopy) {
            class_1291 effect = instance.method_5579();
            if (effect.method_18792() != class_4081.field_18272) continue;
            int duration = (int)((float)instance.method_5584() / 3.0f);
            int amplifier = (int)((float)instance.method_5578() / 2.0f);
            class_1291 newEffect = class_1294.field_5924;
            for (class_1291 harmful : FLIPPABLE_EFFECTS.keySet()) {
                if (!effect.equals(harmful)) continue;
                newEffect = FLIPPABLE_EFFECTS.get(harmful);
                break;
            }
            effectsToRemove.add(effect);
            triggered = true;
            player.method_6092(new class_1293(newEffect, duration, amplifier));
        }
        for (class_1291 effectToRemove : effectsToRemove) {
            player.method_6016(effectToRemove);
        }
        if (triggered && !player.method_7337()) {
            player.method_7357().method_7906(ItemRegistry.CHAOS_CROWN, ConfigConstructor.chaos_crown_flip_effect_cooldown);
            player.method_7357().method_7906(ItemRegistry.CHAOS_HELMET, ConfigConstructor.chaos_crown_flip_effect_cooldown);
        }
    }

    private void shockwave(class_1937 world, class_1657 player) {
        float i = ConfigConstructor.arkenplate_shockwave_knockback;
        class_1799 stack = player.method_31548().method_7372(2);
        if (stack == null) {
            return;
        }
        i += (float)class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack);
        ParticleHandler.singleParticle(world, (class_2394)class_2398.field_11221, player.method_23317(), player.method_23323(0.5), player.method_23321(), 0.0, 0.0, 0.0);
        for (class_1297 entity : world.method_8335((class_1297)player, player.method_5829().method_1014(5.0))) {
            class_1309 target;
            if (!(entity instanceof class_1309) || (target = (class_1309)entity).method_5722((class_1297)player)) continue;
            if (((Object)((Object)this)).equals(ItemRegistry.ENHANCED_ARKENPLATE)) {
                target.method_6092(new class_1293(class_1294.field_5911, 160, 2));
            }
            target.method_5643(player.method_48923().method_48812((class_1309)player), ConfigConstructor.arkenplate_shockwave_damage);
            double x = player.method_23317() - target.method_23317();
            double z = player.method_23321() - target.method_23321();
            target.method_6005((double)(i * 0.5f), x, z);
        }
        world.method_8396(null, player.method_24515(), class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
        if (!player.method_7337()) {
            player.method_7357().method_7906(stack.method_7909(), ConfigConstructor.arkenplate_shockwave_cooldown);
        }
    }

    private boolean isHelmetEquipped(class_1657 player) {
        class_1799 helmet = player.method_31548().method_7372(3);
        return !helmet.method_7960() && (helmet.method_31574(ItemRegistry.CHAOS_CROWN) || helmet.method_31574(ItemRegistry.CHAOS_HELMET));
    }

    private boolean isRobesEquipped(class_1657 player) {
        class_1799 chest = player.method_31548().method_7372(2);
        return !chest.method_7960() && chest.method_31574(ItemRegistry.CHAOS_ROBES);
    }

    private boolean isChestActive(class_1657 player) {
        class_1799 chest = player.method_31548().method_7372(2);
        return !chest.method_7960() && (chest.method_31574(ItemRegistry.ARKENPLATE) || chest.method_31574(ItemRegistry.ENHANCED_ARKENPLATE)) && player.method_6032() < player.method_6063() / 2.0f;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this == ItemRegistry.CHAOS_ROBES) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        if (((Object)((Object)this)).equals(ItemRegistry.ENHANCED_ARKENPLATE)) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("soul_spin"));
        } else if (((Object)((Object)this)).equals(ItemRegistry.ARKENPLATE)) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("no_souls"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (class_437.method_25442()) {
            if (stack.method_31574(ItemRegistry.CHAOS_CROWN) || stack.method_31574(ItemRegistry.CHAOS_HELMET)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_crown").method_27692(class_124.field_1079));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_crown_description_1").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_crown_description_2").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_crown_description_3").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.reversal").method_27692(class_124.field_1062));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.reversal_1").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.reversal_2").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.reversal_3").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.reversal_4").method_27692(class_124.field_1063));
                if (stack.method_31574(ItemRegistry.CHAOS_CROWN)) {
                    if (class_437.method_25441()) {
                        for (int i = 1; i <= 4; ++i) {
                            tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.soulsweapons.chaos_crown_lore_" + i)).method_27692(class_124.field_1063));
                        }
                    } else {
                        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.control"));
                    }
                } else if (class_437.method_25441()) {
                    for (int i = 1; i <= 4; ++i) {
                        tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.soulsweapons.chaos_helm_lore_" + i)).method_27692(class_124.field_1063));
                    }
                } else {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.control"));
                }
            } else if (stack.method_31574(ItemRegistry.CHAOS_ROBES)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes").method_27692(class_124.field_1068));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes_description_1").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes_description_2").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes_description_3").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.chaos_robes_description_4").method_27692(class_124.field_1080));
                if (class_437.method_25441()) {
                    for (int i = 1; i <= 4; ++i) {
                        tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.soulsweapons.chaos_robes_lore_" + i)).method_27692(class_124.field_1063));
                    }
                } else {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.control"));
                }
            } else if (stack.method_31574(ItemRegistry.ARKENPLATE) || stack.method_31574(ItemRegistry.ENHANCED_ARKENPLATE)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate").method_27692(class_124.field_1075));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate_description_1").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate_description_2").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate.aftershock").method_27692(class_124.field_1077));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate.aftershock.1").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate.aftershock.2").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate.aftershock.3").method_27692(class_124.field_1080));
                if (stack.method_31574(ItemRegistry.ENHANCED_ARKENPLATE)) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate.aftershock.4").method_27692(class_124.field_1080));
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate.mirror").method_27692(class_124.field_1064));
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate.mirror.1").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)((int)(ConfigConstructor.arkenplate_mirror_trigger_percent * 100.0f) + "%")).method_27692(class_124.field_1061)));
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.arkenplate.mirror.2").method_27692(class_124.field_1080));
                }
                if (!stack.method_31574(ItemRegistry.ENHANCED_ARKENPLATE)) {
                    if (class_437.method_25441()) {
                        for (int i = 1; i <= 4; ++i) {
                            tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.soulsweapons.arkenplate_lore_" + i)).method_27692(class_124.field_1063));
                        }
                    } else {
                        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.control"));
                    }
                }
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.soulsweapons.shift"));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private GeoArmorRenderer<?> renderer;

            public class_572<class_1309> getHumanoidArmorModel(class_1309 livingEntity, class_1799 itemStack, class_1304 equipmentSlot, class_572<class_1309> original) {
                if (this.renderer == null) {
                    this.renderer = itemStack.method_31574(ItemRegistry.CHAOS_HELMET) || itemStack.method_31574(ItemRegistry.ARKENPLATE) ? new ChaosArmorRenderer() : (itemStack.method_31574(ItemRegistry.ENHANCED_ARKENPLATE) ? new EChaosArmorRenderer() : new ChaosSetRenderer());
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    static {
        FLIPPABLE_EFFECTS.put(class_1294.field_5909, class_1294.field_5904);
        FLIPPABLE_EFFECTS.put(class_1294.field_5901, class_1294.field_5917);
        FLIPPABLE_EFFECTS.put(class_1294.field_5911, class_1294.field_5910);
        FLIPPABLE_EFFECTS.put(class_1294.field_5919, class_1294.field_5925);
        FLIPPABLE_EFFECTS.put(class_1294.field_5903, class_1294.field_5922);
        FLIPPABLE_EFFECTS.put(class_1294.field_5902, class_1294.field_5906);
    }
}

