/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.events.LivingEntityTickCallback;
import net.soulsweaponry.items.DetonateGroundItem;
import net.soulsweaponry.items.UmbralTrespassItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.ModifyDamageUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Unique
    private final class_1309 entity = (class_1309)this;

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    protected void modifyAppliedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> info) {
        class_1309 entity = this.entity;
        float newAmount = ((Float)info.getReturnValue()).floatValue();
        info.setReturnValue((Object)Float.valueOf(ModifyDamageUtil.modifyDamageTaken(entity, newAmount, source)));
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptHeal(float amount, CallbackInfo info) {
        if (this.entity.method_6059(EffectRegistry.DISABLE_HEAL)) {
            info.cancel();
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptFallDamage(float fallDistance, float damageMultiplier, class_1282 source, CallbackInfoReturnable<Boolean> info) {
        if (!(this.entity instanceof class_1657) && DetonateGroundItem.triggerCalculateFall(this.entity, fallDistance, source)) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"onDismounted"}, at={@At(value="HEAD")})
    public void interceptDismount(class_1297 entity, CallbackInfo info) {
        class_1309 class_13092;
        if (entity instanceof class_1309 && (class_13092 = this.entity) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            try {
                if (((Boolean)player.method_5841().method_12789(UmbralTrespassItem.SHOULD_DAMAGE_RIDING)).booleanValue()) {
                    class_1309 target = (class_1309)entity;
                    float damage = 20.0f;
                    class_1796 cooldownManager = player.method_7357();
                    for (class_1268 hand : class_1268.values()) {
                        class_1799 stack = player.method_5998(hand);
                        if (player.method_5998(hand).method_31574((class_1792)WeaponRegistry.SHADOW_ASSASSIN_SCYTHE)) {
                            damage = ConfigConstructor.shadow_assassin_scythe_ability_damage + class_1890.method_8218((class_1799)stack, (class_1310)target.method_6046());
                            cooldownManager.method_7906(stack.method_7909(), ConfigConstructor.shadow_assassin_scythe_ability_cooldown);
                            continue;
                        }
                        if (!player.method_5998(hand).method_31574((class_1792)WeaponRegistry.DARKIN_SCYTHE_PRIME)) continue;
                        damage = ConfigConstructor.darkin_scythe_prime_ability_damage + class_1890.method_8218((class_1799)stack, (class_1310)target.method_6046()) + target.method_6063() * (ConfigConstructor.darkin_scythe_prime_ability_percent_health_damage / 100.0f);
                        float healing = damage * ConfigConstructor.darkin_scythe_prime_heal_modifier;
                        player.method_6025(healing);
                        cooldownManager.method_7906(stack.method_7909(), ConfigConstructor.darkin_scythe_prime_ability_cooldown);
                    }
                    target.method_5643(player.method_37908().method_48963().method_48812((class_1309)player), damage);
                    player.method_5841().method_12778(UmbralTrespassItem.SHOULD_DAMAGE_RIDING, (Object)false);
                    if (!player.method_37908().field_9236 && player.method_24515() != null) {
                        player.method_37908().method_8396(null, player.method_24515(), SoundRegistry.SLICE_TARGET_EVENT, class_3419.field_15248, 0.8f, 1.0f);
                        ParticleHandler.particleOutburstMap(player.method_37908(), 150, player.method_23317(), player.method_23320(), player.method_23321(), ParticleEvents.SOUL_FLAME_SMALL_OUTBURST_MAP, 1.0f);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    private void interceptTick(CallbackInfo info) {
        class_1269 result = ((LivingEntityTickCallback)LivingEntityTickCallback.EVENT.invoker()).tick(this.entity);
        if (result == class_1269.field_5814) {
            info.cancel();
        }
    }
}

