/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8103;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.ParryData;
import net.soulsweaponry.items.DetonateGroundItem;
import net.soulsweaponry.items.UmbralTrespassItem;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin {
    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptFallDamage(float fallDistance, float damageMultiplier, class_1282 source, CallbackInfoReturnable<Boolean> info) {
        if (DetonateGroundItem.triggerCalculateFall((class_1309)((class_1657)this), fallDistance, source)) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"tickRiding"}, at={@At(value="HEAD")})
    public void interceptTickRiding(CallbackInfo info) {
        class_1657 player = (class_1657)this;
        try {
            if (((Boolean)player.method_5841().method_12789(UmbralTrespassItem.SHOULD_DAMAGE_RIDING)).booleanValue()) {
                int time = (Integer)player.method_5841().method_12789(UmbralTrespassItem.TICKS_BEFORE_DISMOUNT);
                player.method_6092(new class_1293(class_1294.field_5905, 10, 0));
                if (time < 0) {
                    player.method_5848();
                } else {
                    player.method_5841().method_12778(UmbralTrespassItem.TICKS_BEFORE_DISMOUNT, (Object)(time - 1));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        class_1297 projectilePos;
        class_1297 class_12972;
        class_1657 player = (class_1657)this;
        try {
            if (((Boolean)player.method_5841().method_12789(UmbralTrespassItem.SHOULD_DAMAGE_RIDING)).booleanValue()) {
                info.setReturnValue((Object)false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int frames = ParryData.getParryFrames(player);
        if (frames >= 1 && frames <= ConfigConstructor.shield_parry_frames && !source.method_48789(class_8103.field_43116)) {
            player.method_37908().method_8421((class_1297)player, (byte)29);
            if (source.method_48789(class_8103.field_42247) && source.method_5526() instanceof class_1676) {
                info.setReturnValue((Object)false);
                return;
            }
            class_12972 = source.method_5529();
            if (class_12972 instanceof class_1309) {
                class_1309 attacker = (class_1309)class_12972;
                if (!attacker.method_6059(EffectRegistry.POSTURE_BREAK)) {
                    attacker.method_37908().method_8396(null, attacker.method_24515(), SoundRegistry.POSTURE_BREAK_EVENT, class_3419.field_15248, 0.5f, 1.0f);
                }
                attacker.method_6092(new class_1293(EffectRegistry.POSTURE_BREAK, 60, 0));
                attacker.method_6005((double)0.4f, player.method_23317() - attacker.method_23317(), player.method_23321() - attacker.method_23321());
                info.setReturnValue((Object)false);
            }
        }
        if (player.method_31548().method_7372(2).method_31574(ItemRegistry.ENHANCED_ARKENPLATE) && player.method_6032() < player.method_6063() * ConfigConstructor.arkenplate_mirror_trigger_percent && source.method_48789(class_8103.field_42247) && (class_12972 = source.method_5526()) instanceof class_1676) {
            class_1676 projectile = (class_1676)class_12972;
            class_243 playerPos = player.method_19538();
            projectilePos = projectile.method_19538();
            class_243 projectileMotion = projectile.method_18798();
            class_243 reflectionVector = this.calculateReflectionVector(playerPos, (class_243)projectilePos, projectileMotion);
            projectile.method_18799(reflectionVector);
            info.setReturnValue((Object)false);
        }
        class_1799 stack = player.method_31548().method_7372(2);
        projectilePos = source.method_5529();
        if (projectilePos instanceof class_1309) {
            class_1309 attacker = (class_1309)projectilePos;
            if (player.method_6059(EffectRegistry.LIFE_LEACH) && !stack.method_7960() && (stack.method_31574(ItemRegistry.ENHANCED_WITHERED_CHEST) || stack.method_31574(ItemRegistry.WITHERED_CHEST))) {
                double x = player.method_23317() - attacker.method_23317();
                double z = player.method_23321() - attacker.method_23321();
                attacker.method_5643(player.method_48923().method_48832(), 1.0f);
                attacker.method_6005(0.5, x, z);
                attacker.method_6092(new class_1293(class_1294.field_5920, ConfigConstructor.withered_chest_apply_wither_duration, ConfigConstructor.withered_chest_apply_wither_amplifier));
                if (!player.method_31548().method_7372(2).method_7960() && player.method_31548().method_7372(2).method_31574(ItemRegistry.ENHANCED_WITHERED_CHEST)) {
                    attacker.method_5639(ConfigConstructor.withered_chest_apply_fire_seconds);
                }
                if (!player.method_37908().field_9236) {
                    for (int i = 0; i < 50; ++i) {
                        ParticleHandler.singleParticle(player.method_37908(), (class_2394)ParticleRegistry.BLACK_FLAME, player.method_23322(1.0), player.method_23323(0.5) + player.method_6051().method_43058() * 2.0 - 1.0, player.method_23325(1.0), player.method_6051().method_43059() / 10.0, player.method_6051().method_43059() / 10.0, player.method_6051().method_43059() / 10.0);
                    }
                }
                player.method_5783(class_3417.field_14588, 1.0f, 1.0f);
            }
        }
    }

    @Unique
    private class_243 calculateReflectionVector(class_243 playerPos, class_243 projectilePos, class_243 projectileMotion) {
        class_243 vectorToPlayer = playerPos.method_1020(projectilePos).method_1029();
        return projectileMotion.method_1020(vectorToPlayer.method_1021(projectileMotion.method_1026(vectorToPlayer) * 2.0));
    }
}

