/*
 * Decompiled with CFR 0.152.
 */
package elocindev.shield_overhaul.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import elocindev.shield_overhaul.config.ConfigEntries;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigBuilder {
    public static final Gson BUILDER = new GsonBuilder().setPrettyPrinting().create();
    public static final Path file = FabricLoader.getInstance().getConfigDir().resolve("shield_overhaul.json");

    public static ConfigEntries loadConfig() {
        try {
            if (!Files.notExists(file, new LinkOption[0])) {
                String json = Files.readString(file);
                ConfigEntries configEntries = (ConfigEntries)BUILDER.fromJson(json, ConfigEntries.class);
                configEntries.blacklisted_shields = configEntries.blacklisted_shields == null ? new ArrayList() : configEntries.blacklisted_shields;
                String updatedJson = BUILDER.toJson((Object)configEntries);
                Files.writeString(file, (CharSequence)updatedJson, new OpenOption[0]);
                return configEntries;
            }
            ConfigEntries exampleConfig = new ConfigEntries();
            exampleConfig.enable_instant_shield_use = true;
            exampleConfig.blacklisted_shields.add("// Items here will not use Shield Overhaul's mechanics");
            exampleConfig.blacklisted_shields.add("examplemod:epic_shield");
            exampleConfig.bosses_immune_to_stun = true;
            exampleConfig.bash_only_on_ground = true;
            exampleConfig.bash_damage = 0.0f;
            exampleConfig.bash_cooldown_secs = 2.0f;
            exampleConfig.bash_stun_duration_secs = 1.0f;
            exampleConfig.add_stun_immunity = true;
            exampleConfig.enable_parrying = true;
            exampleConfig.enable_parry_abuse_prevention = true;
            exampleConfig.parry_window_secs = 0.5f;
            String defaultJson = BUILDER.toJson((Object)exampleConfig);
            Files.writeString(file, (CharSequence)defaultJson, new OpenOption[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return new ConfigEntries();
    }
}

