/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1322;
import net.spell_power.api.MagicSchool;
import net.spell_power.api.attributes.SpellAttributeEntry;
import net.spell_power.api.attributes.SpellAttributes;

public class ItemConfig {
    public Map<String, Weapon> weapons = new HashMap<String, Weapon>();
    public Map<String, ArmorSet> armor_sets = new HashMap<String, ArmorSet>();

    public static class ArmorSet {
        public float armor_toughness = 0.0f;
        public float knockback_resistance = 0.0f;
        public Piece head = new Piece();
        public Piece chest = new Piece();
        public Piece legs = new Piece();
        public Piece feet = new Piece();

        public static ArmorSet with(Piece head, Piece chest, Piece legs, Piece feet) {
            ArmorSet set = new ArmorSet();
            set.head = head;
            set.chest = chest;
            set.legs = legs;
            set.feet = feet;
            return set;
        }

        public static class Piece {
            public int armor = 0;
            public ArrayList<Attribute> attributes = new ArrayList();

            public Piece() {
            }

            public Piece(int armor) {
                this.armor = armor;
            }

            public Piece add(Attribute attribute) {
                this.attributes.add(attribute);
                return this;
            }

            public Piece addAll(List<Attribute> attributes) {
                this.attributes.addAll(attributes);
                return this;
            }
        }
    }

    public static class Weapon {
        public float attack_damage = 0.0f;
        public float attack_speed = 0.0f;
        public ArrayList<Attribute> attributes = new ArrayList();

        public Weapon() {
        }

        public Weapon(float attack_damage, float attack_speed) {
            this.attack_damage = attack_damage;
            this.attack_speed = attack_speed;
        }

        public Weapon add(Attribute attribute) {
            this.attributes.add(attribute);
            return this;
        }
    }

    public static class Attribute {
        public String id;
        public float value;
        public class_1322.class_1323 operation;

        public Attribute() {
        }

        public Attribute(String id, float value, class_1322.class_1323 operation) {
            this.id = id;
            this.value = value;
            this.operation = operation;
        }

        public static Attribute bonus(SpellAttributeEntry attribute, float value) {
            return new Attribute(attribute.id.toString(), value, class_1322.class_1323.field_6328);
        }

        public static Attribute multiply(SpellAttributeEntry attribute, float value) {
            return new Attribute(attribute.id.toString(), value, class_1322.class_1323.field_6330);
        }

        public static ArrayList<Attribute> bonuses(EnumSet<MagicSchool> schools, float value) {
            List<SpellAttributeEntry> list = schools.stream().map(school -> (SpellAttributeEntry)SpellAttributes.POWER.get(school)).toList();
            return Attribute.bonuses(list, value);
        }

        public static ArrayList<Attribute> bonuses(List<SpellAttributeEntry> entries, float value) {
            ArrayList<Attribute> spellAttributes = new ArrayList<Attribute>();
            for (SpellAttributeEntry attribute : entries) {
                spellAttributes.add(new Attribute(attribute.id.toString(), value, class_1322.class_1323.field_6328));
            }
            return spellAttributes;
        }
    }
}

