/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.trinket;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellPool;
import net.spell_engine.internals.SpellRegistry;

public class SpellBooks {
    private static final ArrayList<SpellBookItem> all = new ArrayList();

    public static List<SpellBookItem> sorted() {
        return all.stream().sorted(Comparator.comparing(spellBookItem -> spellBookItem.poolId.toString())).filter(spellBookItem -> {
            SpellPool pool = SpellRegistry.spellPool(spellBookItem.poolId);
            return pool != null && pool.craftable();
        }).collect(Collectors.toList());
    }

    public static SpellBookItem create(class_2960 poolId) {
        return SpellBooks.create(poolId, SpellContainer.ContentType.MAGIC);
    }

    public static SpellBookItem create(class_2960 poolId, SpellContainer.ContentType contentType) {
        SpellContainer container = new SpellContainer(contentType, false, poolId.toString(), 0, List.of());
        SpellRegistry.book_containers.put(SpellBooks.itemIdFor(poolId), container);
        SpellBookItem book = new SpellBookItem(poolId, (class_1792.class_1793)new FabricItemSettings().maxCount(1));
        all.add(book);
        return book;
    }

    public static class_2960 itemIdFor(class_2960 poolId) {
        return new class_2960(poolId.method_12836(), poolId.method_12832() + "_spell_book");
    }

    public static void register(SpellBookItem spellBook) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)SpellBooks.itemIdFor(spellBook.poolId), (Object)((Object)spellBook));
    }

    public static void createAndRegister(class_2960 poolId, class_5321<class_1761> itemGroupKey) {
        SpellBooks.createAndRegister(poolId, SpellContainer.ContentType.MAGIC, itemGroupKey);
    }

    public static void createAndRegister(class_2960 poolId, SpellContainer.ContentType contentType, class_5321<class_1761> itemGroupKey) {
        SpellBookItem item = SpellBooks.create(poolId, contentType);
        ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> content.method_45421((class_1935)item));
        SpellBooks.register(item);
    }
}

