/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import java.util.Map;
import net.minecraft.class_1059;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_918;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.entity.SpellProjectile;
import org.jetbrains.annotations.Nullable;

public class SpellProjectileRenderer<T extends class_1297>
extends class_897<T> {
    private final class_918 itemRenderer;
    private final float scale;
    private final boolean lit;
    private static final Map<LightEmission, class_1921> LAYERS = Map.of(LightEmission.NONE, CustomLayers.projectile(LightEmission.NONE), LightEmission.GLOW, CustomLayers.projectile(LightEmission.GLOW), LightEmission.RADIATE, CustomLayers.projectile(LightEmission.RADIATE));

    public SpellProjectileRenderer(class_5617.class_5618 ctx, float scale, boolean lit) {
        super(ctx);
        this.itemRenderer = ctx.method_32168();
        this.scale = scale;
        this.lit = lit;
    }

    public SpellProjectileRenderer(class_5617.class_5618 arg) {
        this(arg, 1.0f, false);
    }

    protected int method_24087(T entity, class_2338 pos) {
        return this.lit ? 15 : super.method_24087(entity, pos);
    }

    public void method_3936(T entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        Spell.ProjectileModel renderData;
        boolean rendered;
        SpellProjectile projectile;
        if (entity instanceof SpellProjectile && (projectile = (SpellProjectile)entity).renderData() != null && (rendered = SpellProjectileRenderer.render(this.scale, this.field_4676, this.itemRenderer, renderData = projectile.renderData(), projectile.previousVelocity, entity, yaw, tickDelta, true, matrices, vertexConsumers, light))) {
            super.method_3936(entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
    }

    public static boolean render(float scale, class_898 dispatcher, class_918 itemRenderer, Spell.ProjectileModel renderData, @Nullable class_243 previousVelocity, class_1297 entity, float yaw, float tickDelta, boolean allowSpin, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (entity.field_6012 >= 2 || !(dispatcher.field_4686.method_19331().method_5858(entity) < 12.25)) {
            matrices.method_22903();
            matrices.method_22905(scale, scale, scale);
            switch (renderData.render) {
                case FLAT: {
                    matrices.method_22907(dispatcher.method_24197());
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                    break;
                }
                case DEEP: {
                    class_243 velocity = entity.method_18798();
                    if (previousVelocity != null) {
                        velocity = previousVelocity.method_35590(velocity, (double)tickDelta);
                    }
                    velocity = velocity.method_1029();
                    double directionBasedYaw = Math.toDegrees(Math.atan2(velocity.field_1352, velocity.field_1350)) + 180.0;
                    double directionBasedPitch = Math.toDegrees(Math.asin(velocity.field_1351));
                    matrices.method_22907(class_7833.field_40716.rotationDegrees((float)directionBasedYaw));
                    matrices.method_22907(class_7833.field_40714.rotationDegrees((float)directionBasedPitch));
                }
            }
            long time = entity.method_37908().method_8510();
            float absoluteTime = (float)time + tickDelta;
            if (allowSpin) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(absoluteTime * renderData.rotate_degrees_per_tick));
            }
            matrices.method_22905(renderData.scale, renderData.scale, renderData.scale);
            if (renderData.model_id != null && !renderData.model_id.isEmpty()) {
                class_2960 modelId = new class_2960(renderData.model_id);
                CustomModels.render(LAYERS.get((Object)renderData.light_emission), itemRenderer, modelId, matrices, vertexConsumers, light, entity.method_5628());
            }
            matrices.method_22909();
            return true;
        }
        return false;
    }

    public class_2960 method_3931(class_1297 entity) {
        return class_1059.field_5275;
    }
}

