/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.entity;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_8046;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.particle.ParticleHelper;
import org.jetbrains.annotations.Nullable;

public class SpellCloud
extends class_1297
implements class_8046 {
    public static class_1299<SpellCloud> ENTITY_TYPE;
    @Nullable
    private class_1309 owner;
    @Nullable
    private UUID ownerUuid;
    private int timeToLive;
    private class_2960 spellId;
    private SpellHelper.ImpactContext context;
    private static final class_2940<String> SPELL_ID_TRACKER;

    public SpellCloud(class_1299<? extends SpellCloud> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected SpellCloud(class_1937 world, class_1309 owner) {
        super(ENTITY_TYPE, world);
        this.setOwner(owner);
        this.field_5960 = true;
    }

    public SpellCloud(class_1937 world, class_1309 owner, SpellHelper.ImpactContext context, SpellInfo spellInfo) {
        this(world, owner);
        this.spellId = spellInfo.id();
        this.context = context;
        this.method_5841().method_12778(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        Spell.Release.Target.Cloud cloudData = spellInfo.spell().release.target.cloud;
        this.timeToLive = (int)(cloudData.time_to_live_seconds * 20.0f);
    }

    public class_4048 method_18377(class_4050 pose) {
        Spell spell = this.getSpell();
        if (spell != null) {
            Spell.Release.Target.Cloud cloudData = spell.release.target.cloud;
            float radius = cloudData.volume.radius;
            float heightMultiplier = cloudData.volume.area.vertical_range_multiplier;
            return class_4048.method_18384((float)(radius * 2.0f), (float)(radius * heightMultiplier));
        }
        return super.method_18377(pose);
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.method_5667();
    }

    @Nullable
    public class_1297 method_24921() {
        class_1297 entity;
        if (this.owner == null && this.ownerUuid != null && this.method_37908() instanceof class_3218 && (entity = ((class_3218)this.method_37908()).method_14190(this.ownerUuid)) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    protected void method_5693() {
        this.method_5841().method_12784(SPELL_ID_TRACKER, (Object)"");
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        String rawSpellId = (String)this.method_5841().method_12789(SPELL_ID_TRACKER);
        if (rawSpellId != null && !rawSpellId.isEmpty()) {
            this.spellId = new class_2960(rawSpellId);
        }
        this.method_18382();
    }

    protected void method_5749(class_2487 nbt) {
        this.field_6012 = nbt.method_10550(NBTKey.AGE.key);
        this.timeToLive = nbt.method_10550(NBTKey.TIME_TO_LIVE.key);
        this.spellId = new class_2960(nbt.method_10558(NBTKey.SPELL_ID.key));
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10569(NBTKey.AGE.key, this.field_6012);
        nbt.method_10569(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
        nbt.method_10582(NBTKey.SPELL_ID.key, this.spellId.toString());
    }

    public void method_5773() {
        super.method_5773();
        Spell spell = this.getSpell();
        if (spell == null) {
            return;
        }
        Spell.Release.Target.Cloud cloudData = this.getSpell().release.target.cloud;
        if (this.method_37908().field_9236) {
            Spell.Release.Target.Cloud.ClientData clientData = cloudData.client_data;
            for (ParticleBatch particleBatch : clientData.particles) {
                ParticleHelper.play(this.method_37908(), (class_1297)this, particleBatch);
            }
        } else {
            if (this.field_6012 >= this.timeToLive) {
                this.method_31472();
                return;
            }
            if (this.field_6012 % cloudData.impact_tick_interval == 0) {
                Spell.AreaImpact area_impact = cloudData.volume;
                class_1309 owner = (class_1309)this.method_24921();
                if (area_impact != null && owner != null) {
                    SpellHelper.ImpactContext context = this.context;
                    if (context == null) {
                        context = new SpellHelper.ImpactContext();
                    }
                    SpellHelper.lookupAndPerformAreaImpact(area_impact, spell, owner, null, this, context.position(this.method_19538()), true);
                }
            }
        }
    }

    public Spell getSpell() {
        return SpellRegistry.getSpell(this.spellId);
    }

    static {
        SPELL_ID_TRACKER = class_2945.method_12791(SpellCloud.class, (class_2941)class_2943.field_13326);
    }

    private static enum NBTKey {
        AGE("Age"),
        TIME_TO_LIVE("TTL"),
        SPELL_ID("SpellId");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

