/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.enchantment.Enchantments_SpellEngine;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.CustomSpellHandler;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellEvents;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.compat.QuiverCompat;
import net.spell_engine.entity.ConfigurableKnockback;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.WorldScheduler;
import net.spell_engine.internals.arrow.ArrowHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.AnimationHelper;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.TargetHelper;
import net.spell_power.api.MagicSchool;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellPower;
import org.jetbrains.annotations.Nullable;

public class SpellHelper {
    public static float launchPointOffsetDefault = 0.5f;
    private static final float knockbackDefaultStrength = 0.4f;

    public static SpellCast.Attempt attemptCasting(class_1657 player, class_1799 itemStack, class_2960 spellId) {
        return SpellHelper.attemptCasting(player, itemStack, spellId, true);
    }

    public static SpellCast.Attempt attemptCasting(class_1657 player, class_1799 itemStack, class_2960 spellId, boolean checkAmmo) {
        AmmoResult ammoResult;
        SpellCasterEntity caster = (SpellCasterEntity)player;
        Spell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            return SpellCast.Attempt.none();
        }
        if (caster.getCooldownManager().isCoolingDown(spellId)) {
            return SpellCast.Attempt.failOnCooldown(new SpellCast.Attempt.OnCooldownInfo());
        }
        if (checkAmmo && !(ammoResult = SpellHelper.ammoForSpell(player, spell, itemStack)).satisfied()) {
            return SpellCast.Attempt.failMissingItem(new SpellCast.Attempt.MissingItemInfo(ammoResult.ammo.method_7909()));
        }
        return SpellCast.Attempt.success();
    }

    public static AmmoResult ammoForSpell(class_1657 player, Spell spell, class_1799 itemStack) {
        boolean ignoreAmmo;
        boolean satisfied = true;
        class_1799 ammo = null;
        boolean bl = ignoreAmmo = player.method_31549().field_7477 || !SpellEngineMod.config.spell_cost_item_allowed;
        if (!ignoreAmmo && spell.cost.item_id != null && !spell.cost.item_id.isEmpty()) {
            boolean hasInfinity;
            class_2960 id = new class_2960(spell.cost.item_id);
            boolean needsArrow = id.method_12832().contains("arrow");
            boolean bl2 = needsArrow ? class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)itemStack) > 0 : (hasInfinity = class_1890.method_8225((class_1887)Enchantments_SpellEngine.INFINITY, (class_1799)itemStack) > 0);
            if (hasInfinity) {
                return new AmmoResult(satisfied, ammo);
            }
            class_1792 ammoItem = (class_1792)class_7923.field_41178.method_10223(id);
            if (ammoItem != null) {
                ammo = ammoItem.method_7854();
                satisfied = player.method_31548().method_7379(ammo);
                if (needsArrow) {
                    satisfied = satisfied || QuiverCompat.hasArrow(ammoItem, player);
                }
            }
        }
        return new AmmoResult(satisfied, ammo);
    }

    public static float hasteAffectedValue(float value, float haste) {
        return value / haste;
    }

    public static float hasteAffectedValue(class_1309 caster, float value) {
        return SpellHelper.hasteAffectedValue(caster, value, null);
    }

    public static float hasteAffectedValue(class_1309 caster, float value, class_1799 provisionedWeapon) {
        float haste = (float)SpellPower.getHaste((class_1309)caster, (class_1799)provisionedWeapon);
        return SpellHelper.hasteAffectedValue(value, haste);
    }

    public static float getCastDuration(class_1309 caster, Spell spell) {
        return SpellHelper.getCastDuration(caster, spell, null);
    }

    public static float getCastDuration(class_1309 caster, Spell spell, class_1799 provisionedWeapon) {
        if (spell.cast == null) {
            return 0.0f;
        }
        return SpellHelper.hasteAffectedValue(caster, spell.cast.duration, provisionedWeapon);
    }

    public static SpellCast.Duration getCastTimeDetails(class_1309 caster, Spell spell) {
        float haste = spell.cast.haste_affected ? (float)SpellPower.getHaste((class_1309)caster, null) : 1.0f;
        float duration = SpellHelper.hasteAffectedValue(spell.cast.duration, haste);
        return new SpellCast.Duration(haste, Math.round(duration * 20.0f));
    }

    public static float getCooldownDuration(class_1309 caster, Spell spell) {
        return SpellHelper.getCooldownDuration(caster, spell, null);
    }

    public static float getCooldownDuration(class_1309 caster, Spell spell, class_1799 provisionedWeapon) {
        float duration = spell.cost.cooldown_duration;
        if (duration > 0.0f && SpellEngineMod.config.haste_affects_cooldown && spell.cost.cooldown_haste_affected) {
            duration = SpellHelper.hasteAffectedValue(caster, spell.cost.cooldown_duration, provisionedWeapon);
        }
        return duration;
    }

    public static boolean isChanneled(Spell spell) {
        return SpellHelper.channelValueMultiplier(spell) != 0.0f;
    }

    public static boolean isInstant(Spell spell) {
        return spell.cast.duration == 0.0f;
    }

    public static float channelValueMultiplier(Spell spell) {
        int ticks = spell.cast.channel_ticks;
        if (ticks <= 0) {
            return 0.0f;
        }
        return (float)ticks / 20.0f;
    }

    public static void startCasting(class_1657 player, class_2960 spellId, float speed, int length) {
        Spell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            return;
        }
        class_1799 itemStack = player.method_6047();
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, itemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        SpellCast.Process process = new SpellCast.Process(spellId, spell, itemStack.method_7909(), speed, length, player.method_37908().method_8510());
        SpellCastSyncHelper.setCasting(player, process);
        SoundHelper.playSound(player.method_37908(), (class_1297)player, spell.cast.start_sound);
    }

    public static void performSpell(class_1937 world, class_1657 player, class_2960 spellId, List<class_1297> targets, SpellCast.Action action, float progress) {
        if (player.method_7325()) {
            return;
        }
        Spell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            return;
        }
        SpellInfo spellInfo = new SpellInfo(spell, spellId);
        class_1799 itemStack = player.method_6047();
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, itemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        float castingSpeed = ((SpellCasterEntity)player).getCurrentCastingSpeed();
        progress = Math.max(Math.min(progress, 1.0f), 0.0f);
        float channelMultiplier = 1.0f;
        boolean shouldPerformImpact = true;
        Supplier trackingPlayers = Suppliers.memoize(() -> PlayerLookup.tracking((class_1297)player));
        switch (action) {
            case CHANNEL: {
                channelMultiplier = SpellHelper.channelValueMultiplier(spell);
                break;
            }
            case RELEASE: {
                if (SpellHelper.isChanneled(spell)) {
                    shouldPerformImpact = false;
                    channelMultiplier = 1.0f;
                } else {
                    channelMultiplier = progress >= 1.0f ? 1.0f : 0.0f;
                }
                SpellCastSyncHelper.clearCasting(player);
            }
        }
        AmmoResult ammoResult = SpellHelper.ammoForSpell(player, spell, itemStack);
        if (channelMultiplier > 0.0f && ammoResult.satisfied()) {
            boolean released;
            Spell.Release.Target targeting = spell.release.target;
            boolean bl = released = action == SpellCast.Action.RELEASE;
            if (shouldPerformImpact) {
                ImpactContext context = new ImpactContext(channelMultiplier, 1.0f, null, SpellPower.getSpellPower((MagicSchool)spell.school, (class_1309)player), SpellHelper.impactTargetingMode(spell));
                if (spell.release.custom_impact) {
                    Function<CustomSpellHandler.Data, Boolean> handler = CustomSpellHandler.handlers.get(spellId);
                    released = false;
                    if (handler != null) {
                        released = (Boolean)handler.apply((Object)new CustomSpellHandler.Data(player, targets, itemStack, action, progress, context));
                    }
                } else {
                    switch (targeting.type) {
                        case AREA: {
                            class_243 center = player.method_19538().method_1031(0.0, (double)(player.method_17682() / 2.0f), 0.0);
                            Spell.Release.Target.Area area = spell.release.target.area;
                            SpellHelper.applyAreaImpact(world, (class_1309)player, targets, spell.range, area, spell, context.position(center), true);
                            break;
                        }
                        case BEAM: {
                            SpellHelper.beamImpact(world, (class_1309)player, targets, spell, context);
                            break;
                        }
                        case CLOUD: {
                            SpellHelper.placeCloud(world, (class_1309)player, spellInfo, context);
                            released = true;
                            break;
                        }
                        case CURSOR: {
                            class_1297 target = targets.stream().findFirst();
                            if (target.isPresent()) {
                                SpellHelper.directImpact(world, (class_1309)player, (class_1297)target.get(), spell, context);
                                break;
                            }
                            released = false;
                            break;
                        }
                        case PROJECTILE: {
                            class_1297 target = null;
                            Optional entityFound = targets.stream().findFirst();
                            if (entityFound.isPresent()) {
                                target = (class_1297)entityFound.get();
                            }
                            SpellHelper.shootProjectile(world, (class_1309)player, target, spellInfo, context);
                            break;
                        }
                        case METEOR: {
                            class_1297 target = targets.stream().findFirst();
                            if (target.isPresent()) {
                                SpellHelper.fallProjectile(world, (class_1309)player, (class_1297)target.get(), spellInfo, context);
                                break;
                            }
                            released = false;
                            break;
                        }
                        case SELF: {
                            SpellHelper.directImpact(world, (class_1309)player, (class_1297)player, spell, context);
                            released = true;
                            break;
                        }
                        case SHOOT_ARROW: {
                            ArrowHelper.shootArrow(world, (class_1309)player, spellInfo, context);
                            released = true;
                        }
                    }
                }
            }
            if (released) {
                ParticleHelper.sendBatches((class_1297)player, spell.release.particles);
                SoundHelper.playSound(world, (class_1297)player, spell.release.sound);
                AnimationHelper.sendAnimation(player, (Collection)trackingPlayers.get(), SpellCast.Animation.RELEASE, spell.release.animation, castingSpeed);
                SpellHelper.imposeCooldown(player, spellId, spell, progress);
                player.method_7322(spell.cost.exhaust * SpellEngineMod.config.spell_cost_exhaust_multiplier);
                if (SpellEngineMod.config.spell_cost_durability_allowed && spell.cost.durability > 0) {
                    itemStack.method_7956(spell.cost.durability, (class_1309)player, playerObj -> {
                        playerObj.method_20235(class_1304.field_6173);
                        playerObj.method_20235(class_1304.field_6171);
                    });
                }
                if (ammoResult.ammo != null && spell.cost.consume_item) {
                    for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                        class_1799 stack = player.method_31548().method_5438(i);
                        if (!stack.method_31574(ammoResult.ammo.method_7909())) continue;
                        stack.method_7934(1);
                        if (!stack.method_7960()) break;
                        player.method_31548().method_7378(stack);
                        break;
                    }
                }
                if (spell.cost.effect_id != null) {
                    class_1291 effect = (class_1291)class_7923.field_41174.method_10223(new class_2960(spell.cost.effect_id));
                    player.method_6016(effect);
                }
            }
        }
    }

    public static void imposeCooldown(class_1657 player, class_2960 spellId, Spell spell, float progress) {
        float duration = SpellHelper.cooldownToSet((class_1309)player, spell, progress);
        if (duration > 0.0f) {
            ((SpellCasterEntity)player).getCooldownManager().set(spellId, Math.round(duration * 20.0f));
        }
    }

    private static float cooldownToSet(class_1309 caster, Spell spell, float progress) {
        if (spell.cost.cooldown_proportional) {
            return SpellHelper.getCooldownDuration(caster, spell) * progress;
        }
        return SpellHelper.getCooldownDuration(caster, spell);
    }

    public static float launchHeight(class_1309 livingEntity) {
        float eyeHeight = livingEntity.method_5751();
        double shoulderDistance = (double)livingEntity.method_17682() * 0.15;
        return (float)(((double)eyeHeight - shoulderDistance) * (double)livingEntity.method_17825());
    }

    public static class_243 launchPoint(class_1309 caster) {
        return SpellHelper.launchPoint(caster, launchPointOffsetDefault);
    }

    public static class_243 launchPoint(class_1309 caster, float forward) {
        class_243 look = caster.method_5720().method_1021((double)(forward * caster.method_17825()));
        return caster.method_19538().method_1031(0.0, (double)SpellHelper.launchHeight(caster), 0.0).method_1019(look);
    }

    public static void shootProjectile(class_1937 world, class_1309 caster, class_1297 target, SpellInfo spellInfo, ImpactContext context) {
        SpellHelper.shootProjectile(world, caster, target, spellInfo, context, true);
    }

    public static void shootProjectile(class_1937 world, class_1309 caster, class_1297 target, SpellInfo spellInfo, ImpactContext context, boolean initial) {
        if (world.field_9236) {
            return;
        }
        Spell spell = spellInfo.spell();
        class_243 launchPoint = SpellHelper.launchPoint(caster);
        Spell.Release.Target.ShootProjectile data = spell.release.target.projectile;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.method_10216(), launchPoint.method_10214(), launchPoint.method_10215(), SpellProjectile.Behaviour.FLY, spellInfo.id(), target, context, mutablePerks);
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        if (SpellEvents.PROJECTILE_SHOOT.isListened()) {
            SpellEvents.PROJECTILE_SHOOT.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellInfo, context, initial)));
        }
        float velocity = mutableLaunchProperties.velocity;
        float divergence = projectileData.divergence;
        if (data.inherit_shooter_velocity) {
            projectile.method_24919((class_1297)caster, caster.method_36455(), caster.method_36454(), caster.method_6003(), velocity, divergence);
        } else {
            class_243 look = caster.method_5720().method_1029();
            projectile.method_7485(look.field_1352, look.field_1351, look.field_1350, velocity, divergence);
        }
        projectile.range = spell.range;
        projectile.method_5695(caster.method_36455());
        projectile.method_36456(caster.method_36454());
        world.method_8649((class_1297)projectile);
        if (initial && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.method_5805()) {
                        return;
                    }
                    SpellHelper.shootProjectile(world, caster, target, spellInfo, context, false);
                });
            }
        }
    }

    public static void fallProjectile(class_1937 world, class_1309 caster, class_1297 target, SpellInfo spellInfo, ImpactContext context) {
        SpellHelper.fallProjectile(world, caster, target, spellInfo, context, true);
    }

    public static void fallProjectile(class_1937 world, class_1309 caster, class_1297 target, SpellInfo spellInfo, ImpactContext context, boolean initial) {
        if (world.field_9236) {
            return;
        }
        Spell spell = spellInfo.spell();
        Spell.Release.Target.Meteor meteor = spell.release.target.meteor;
        float height = meteor.launch_height;
        class_243 launchPoint = target.method_19538().method_1031(0.0, (double)height, 0.0);
        Spell.Release.Target.Meteor data = spell.release.target.meteor;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.method_10216(), launchPoint.method_10214(), launchPoint.method_10215(), SpellProjectile.Behaviour.FALL, spellInfo.id(), target, context, mutablePerks);
        if (SpellEvents.PROJECTILE_FALL.isListened()) {
            SpellEvents.PROJECTILE_FALL.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellInfo, context, initial)));
        }
        projectile.method_36456(0.0f);
        projectile.method_36457(90.0f);
        if (!initial) {
            projectile.setVelocity(0.0, -1.0, 0.0, mutableLaunchProperties.velocity, 0.5f, projectileData.divergence);
            projectile.setFollowedTarget(null);
        } else {
            projectile.method_18799(new class_243(0.0, (double)(-mutableLaunchProperties.velocity), 0.0));
        }
        projectile.field_5982 = projectile.method_36454();
        projectile.field_6004 = projectile.method_36455();
        projectile.range = height;
        world.method_8649((class_1297)projectile);
        if (initial && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.method_5805()) {
                        return;
                    }
                    SpellHelper.fallProjectile(world, caster, target, spellInfo, context, false);
                });
            }
        }
    }

    public static void placeCloud(class_1937 world, class_1309 caster, SpellInfo spellInfo, ImpactContext context) {
        Spell spell = spellInfo.spell();
        Spell.Release.Target.Cloud cloud = spell.release.target.cloud;
        SpellCloud entity = new SpellCloud(world, caster, context, spellInfo);
        if (cloud.spawn_on_ground && !caster.method_24828()) {
            class_243 groundPosBelow = TargetHelper.findSolidBlockBelow(caster, caster.method_37908());
            class_243 position = groundPosBelow != null ? groundPosBelow : caster.method_19538();
            entity.method_33574(position);
        } else {
            entity.method_33574(caster.method_19538());
        }
        world.method_8649((class_1297)entity);
    }

    private static void directImpact(class_1937 world, class_1309 caster, class_1297 target, Spell spell, ImpactContext context) {
        SpellHelper.performImpacts(world, caster, target, target, spell, context);
    }

    private static void beamImpact(class_1937 world, class_1309 caster, List<class_1297> targets, Spell spell, ImpactContext context) {
        for (class_1297 target : targets) {
            SpellHelper.performImpacts(world, caster, target, target, spell, context.position(target.method_19538()));
        }
    }

    public static void fallImpact(class_1309 caster, class_1297 projectile, Spell spell, ImpactContext context) {
        class_243 adjustedCenter = context.position().method_1031(0.0, 1.0, 0.0);
        SpellHelper.performImpacts(projectile.method_37908(), caster, null, projectile, spell, context.position(adjustedCenter));
    }

    public static boolean projectileImpact(class_1309 caster, class_1297 projectile, class_1297 target, Spell spell, ImpactContext context) {
        return SpellHelper.performImpacts(projectile.method_37908(), caster, target, projectile, spell, context);
    }

    public static void lookupAndPerformAreaImpact(Spell.AreaImpact area_impact, Spell spell, class_1309 caster, class_1297 exclude, class_1297 aoeSource, ImpactContext context, boolean additionalTargetLookup) {
        class_243 center = context.position();
        List<class_1297> targets = TargetHelper.targetsFromArea(aoeSource, center, area_impact.radius, area_impact.area, null);
        if (exclude != null) {
            targets.remove(exclude);
        }
        SpellHelper.applyAreaImpact(aoeSource.method_37908(), caster, targets, area_impact.radius, area_impact.area, spell, context.target(TargetHelper.TargetingMode.AREA), additionalTargetLookup);
        ParticleHelper.sendBatches(aoeSource, area_impact.particles);
        SoundHelper.playSound(aoeSource.method_37908(), aoeSource, area_impact.sound);
    }

    private static void applyAreaImpact(class_1937 world, class_1309 caster, List<class_1297> targets, float range, Spell.Release.Target.Area area, Spell spell, ImpactContext context, boolean additionalTargetLookup) {
        double squaredRange = range * range;
        class_243 center = context.position();
        for (class_1297 target : targets) {
            float distanceBasedMultiplier = 1.0f;
            switch (area.distance_dropoff) {
                case NONE: {
                    break;
                }
                case SQUARED: {
                    distanceBasedMultiplier = (float)((squaredRange - target.method_5707(center)) / squaredRange);
                    distanceBasedMultiplier = Math.max(distanceBasedMultiplier, 0.0f);
                }
            }
            SpellHelper.performImpacts(world, caster, target, target, spell, context.distance(distanceBasedMultiplier), additionalTargetLookup);
        }
    }

    public static boolean performImpacts(class_1937 world, class_1309 caster, @Nullable class_1297 target, class_1297 aoeSource, Spell spell, ImpactContext context) {
        return SpellHelper.performImpacts(world, caster, target, aoeSource, spell, context, true);
    }

    public static boolean performImpacts(class_1937 world, class_1309 caster, @Nullable class_1297 target, class_1297 aoeSource, Spell spell, ImpactContext context, boolean additionalTargetLookup) {
        Collection trackers = target != null ? PlayerLookup.tracking((class_1297)target) : null;
        boolean performed = false;
        TargetHelper.Intent selectedIntent = null;
        for (Spell.Impact impact : spell.impact) {
            TargetHelper.Intent intent = SpellHelper.intent(impact.action);
            if (!impact.action.apply_to_caster && selectedIntent != null && selectedIntent != intent || target == null) continue;
            boolean result = SpellHelper.performImpact(world, caster, target, spell.school, impact, context, trackers);
            boolean bl = performed = performed || result;
            if (!result) continue;
            selectedIntent = intent;
        }
        Spell.AreaImpact area_impact = spell.area_impact;
        if (area_impact != null && additionalTargetLookup && (performed || target == null)) {
            SpellHelper.lookupAndPerformAreaImpact(area_impact, spell, caster, target, aoeSource, context, false);
        }
        return performed;
    }

    private static boolean performImpact(class_1937 world, class_1309 caster, class_1297 target, MagicSchool spellSchool, Spell.Impact impact, ImpactContext context, Collection<class_3222> trackers) {
        boolean success;
        block28: {
            if (!target.method_5732()) {
                return false;
            }
            success = false;
            boolean isKnockbackPushed = false;
            try {
                MagicSchool school;
                double particleMultiplier = 1.0f * context.total();
                SpellPower.Result power = context.power();
                MagicSchool magicSchool = school = impact.school != null ? impact.school : spellSchool;
                if (power == null || power.school() != school) {
                    power = SpellPower.getSpellPower((MagicSchool)school, (class_1309)caster);
                }
                if (power.baseValue() < (double)impact.action.min_power) {
                    power = new SpellPower.Result(power.school(), (double)impact.action.min_power, power.criticalChance(), power.criticalDamage());
                }
                if (impact.action.apply_to_caster) {
                    target = caster;
                }
                if (!TargetHelper.actionAllowed(context.targetingMode(), SpellHelper.intent(impact.action), caster, target)) {
                    return false;
                }
                switch (impact.action.type) {
                    case DAMAGE: {
                        Spell.Impact.Action.Damage damageData = impact.action.damage;
                        float knockbackMultiplier = Math.max(0.0f, damageData.knockback * context.total());
                        SpellPower.Vulnerability vulnerability = SpellPower.Vulnerability.none;
                        int timeUntilRegen = target.field_6008;
                        if (target instanceof class_1309) {
                            class_1309 livingEntity = (class_1309)target;
                            ((ConfigurableKnockback)livingEntity).pushKnockbackMultiplier_SpellEngine(context.hasOffset() ? 0.0f : knockbackMultiplier);
                            isKnockbackPushed = true;
                            if (damageData.bypass_iframes && SpellEngineMod.config.bypass_iframes) {
                                target.field_6008 = 0;
                            }
                            vulnerability = SpellPower.getVulnerability((class_1309)livingEntity, (MagicSchool)school);
                        }
                        double amount = power.randomValue(vulnerability);
                        amount *= (double)damageData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= SpellPower.getHaste((class_1309)caster);
                        }
                        particleMultiplier = power.criticalDamage() + (double)vulnerability.criticalDamageBonus();
                        caster.method_6114(target);
                        target.method_5643(SpellDamageSource.create((MagicSchool)school, (class_1309)caster), (float)amount);
                        if (target instanceof class_1309) {
                            class_1309 livingEntity = (class_1309)target;
                            ((ConfigurableKnockback)livingEntity).popKnockbackMultiplier_SpellEngine();
                            isKnockbackPushed = false;
                            target.field_6008 = timeUntilRegen;
                            if (context.hasOffset()) {
                                class_243 direction = context.knockbackDirection(livingEntity.method_19538()).method_22882();
                                livingEntity.method_6005((double)(0.4f * knockbackMultiplier), direction.field_1352, direction.field_1350);
                            }
                        }
                        success = true;
                        break;
                    }
                    case HEAL: {
                        if (!(target instanceof class_1309)) break;
                        class_1309 livingTarget = (class_1309)target;
                        Spell.Impact.Action.Heal healData = impact.action.heal;
                        particleMultiplier = power.criticalDamage();
                        double amount = power.randomValue();
                        amount *= (double)healData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= SpellPower.getHaste((class_1309)caster);
                        }
                        livingTarget.method_6025((float)amount);
                        success = true;
                        break;
                    }
                    case STATUS_EFFECT: {
                        Spell.Impact.Action.StatusEffect data = impact.action.status_effect;
                        if (!(target instanceof class_1309)) break;
                        class_1309 livingTarget = (class_1309)target;
                        class_2960 id = new class_2960(data.effect_id);
                        class_1291 effect = (class_1291)class_7923.field_41174.method_10223(id);
                        if (!SpellHelper.underApplyLimit(power, livingTarget, school, data.apply_limit)) {
                            return false;
                        }
                        int duration = Math.round(data.duration * 20.0f);
                        int amplifier = data.amplifier + (int)((double)data.amplifier_power_multiplier * power.nonCriticalValue());
                        boolean showParticles = data.show_particles;
                        switch (data.apply_mode) {
                            case SET: {
                                break;
                            }
                            case ADD: {
                                class_1293 currentEffect = livingTarget.method_6112(effect);
                                int newAmplifier = 0;
                                if (currentEffect != null) {
                                    int incrementedAmplifier = currentEffect.method_5578() + 1;
                                    newAmplifier = Math.min(incrementedAmplifier, amplifier);
                                }
                                amplifier = newAmplifier;
                            }
                        }
                        livingTarget.method_37222(new class_1293(effect, duration, amplifier, false, showParticles, true), (class_1297)caster);
                        success = true;
                        break;
                    }
                    case FIRE: {
                        Spell.Impact.Action.Fire data = impact.action.fire;
                        target.method_5639(data.duration);
                        if (target.method_20802() <= 0) break;
                        target.method_20803(target.method_20802() + data.tick_offset);
                    }
                }
                if (success) {
                    if (impact.particles != null) {
                        ParticleHelper.sendBatches(target, impact.particles, (float)particleMultiplier, trackers);
                    }
                    if (impact.sound != null) {
                        SoundHelper.playSound(world, target, impact.sound);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to perform impact effect");
                System.err.println(e.getMessage());
                if (!isKnockbackPushed) break block28;
                ((ConfigurableKnockback)target).popKnockbackMultiplier_SpellEngine();
            }
        }
        return success;
    }

    public static TargetHelper.TargetingMode selectionTargetingMode(Spell spell) {
        switch (spell.release.target.type) {
            case AREA: 
            case BEAM: {
                return TargetHelper.TargetingMode.AREA;
            }
            case CLOUD: 
            case CURSOR: 
            case PROJECTILE: 
            case METEOR: 
            case SELF: 
            case SHOOT_ARROW: {
                return TargetHelper.TargetingMode.DIRECT;
            }
        }
        return null;
    }

    public static TargetHelper.TargetingMode impactTargetingMode(Spell spell) {
        switch (spell.release.target.type) {
            case AREA: 
            case BEAM: 
            case METEOR: {
                return TargetHelper.TargetingMode.AREA;
            }
            case CLOUD: 
            case CURSOR: 
            case PROJECTILE: 
            case SELF: 
            case SHOOT_ARROW: {
                return TargetHelper.TargetingMode.DIRECT;
            }
        }
        return null;
    }

    public static EnumSet<TargetHelper.Intent> intents(Spell spell) {
        HashSet<TargetHelper.Intent> intents = new HashSet<TargetHelper.Intent>();
        for (Spell.Impact impact : spell.impact) {
            intents.add(SpellHelper.intent(impact.action));
        }
        return EnumSet.copyOf(intents);
    }

    public static TargetHelper.Intent intent(Spell.Impact.Action action) {
        switch (action.type) {
            case DAMAGE: 
            case FIRE: {
                return TargetHelper.Intent.HARMFUL;
            }
            case HEAL: {
                return TargetHelper.Intent.HELPFUL;
            }
            case STATUS_EFFECT: {
                Spell.Impact.Action.StatusEffect data = action.status_effect;
                class_2960 id = new class_2960(data.effect_id);
                class_1291 effect = (class_1291)class_7923.field_41174.method_10223(id);
                return effect.method_5573() ? TargetHelper.Intent.HELPFUL : TargetHelper.Intent.HARMFUL;
            }
        }
        return null;
    }

    public static boolean underApplyLimit(SpellPower.Result spellPower, class_1309 target, MagicSchool school, Spell.Impact.Action.StatusEffect.ApplyLimit limit) {
        if (limit == null) {
            return true;
        }
        float power = (float)spellPower.nonCriticalValue();
        float cap = limit.health_base + power * limit.spell_power_multiplier;
        return cap >= target.method_6063();
    }

    public static EstimatedOutput estimate(Spell spell, class_1657 caster, class_1799 itemStack) {
        MagicSchool spellSchool = spell.school;
        ArrayList<EstimatedValue> damageEffects = new ArrayList<EstimatedValue>();
        ArrayList<EstimatedValue> healEffects = new ArrayList<EstimatedValue>();
        boolean forSpellBook = itemStack.method_7909() instanceof SpellBookItem;
        boolean replaceAttributes = caster.method_6047() != itemStack && !forSpellBook;
        Multimap heldAttributes = caster.method_6047().method_7926(class_1304.field_6173);
        Multimap itemAttributes = itemStack.method_7926(class_1304.field_6173);
        if (replaceAttributes) {
            caster.method_6127().method_26847(heldAttributes);
            caster.method_6127().method_26854(itemAttributes);
        }
        block4: for (Spell.Impact impact : spell.impact) {
            MagicSchool school = impact.school != null ? impact.school : spellSchool;
            SpellPower.Result power = SpellPower.getSpellPower((MagicSchool)school, (class_1309)caster, (class_1799)(forSpellBook ? null : itemStack));
            if (power.baseValue() < (double)impact.action.min_power) {
                power = new SpellPower.Result(power.school(), (double)impact.action.min_power, power.criticalChance(), power.criticalDamage());
            }
            switch (impact.action.type) {
                case DAMAGE: {
                    Spell.Impact.Action.Damage damageData = impact.action.damage;
                    EstimatedValue damage = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(damageData.spell_power_coefficient);
                    damageEffects.add(damage);
                    continue block4;
                }
                case HEAL: {
                    Spell.Impact.Action.Heal healData = impact.action.heal;
                    EstimatedValue healing = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(healData.spell_power_coefficient);
                    healEffects.add(healing);
                    continue block4;
                }
            }
        }
        if (replaceAttributes) {
            caster.method_6127().method_26847(itemAttributes);
            caster.method_6127().method_26854(heldAttributes);
        }
        return new EstimatedOutput(damageEffects, healEffects);
    }

    public record AmmoResult(boolean satisfied, class_1799 ammo) {
    }

    public record ImpactContext(float channel, float distance, @Nullable class_243 position, SpellPower.Result power, TargetHelper.TargetingMode targetingMode) {
        public ImpactContext() {
            this(1.0f, 1.0f, null, null, TargetHelper.TargetingMode.DIRECT);
        }

        public ImpactContext channeled(float multiplier) {
            return new ImpactContext(multiplier, this.distance, this.position, this.power, this.targetingMode);
        }

        public ImpactContext distance(float multiplier) {
            return new ImpactContext(this.channel, multiplier, this.position, this.power, this.targetingMode);
        }

        public ImpactContext position(class_243 position) {
            return new ImpactContext(this.channel, this.distance, position, this.power, this.targetingMode);
        }

        public ImpactContext power(SpellPower.Result spellPower) {
            return new ImpactContext(this.channel, this.distance, this.position, spellPower, this.targetingMode);
        }

        public ImpactContext target(TargetHelper.TargetingMode targetingMode) {
            return new ImpactContext(this.channel, this.distance, this.position, this.power, targetingMode);
        }

        public boolean hasOffset() {
            return this.position != null;
        }

        public class_243 knockbackDirection(class_243 targetPosition) {
            return targetPosition.method_1020(this.position).method_1029();
        }

        public boolean isChanneled() {
            return this.channel != 1.0f;
        }

        public float total() {
            return this.channel * this.distance;
        }
    }

    public record EstimatedValue(double min, double max) {
        public EstimatedValue multiply(double value) {
            return new EstimatedValue(this.min * value, this.max * value);
        }
    }

    public record EstimatedOutput(List<EstimatedValue> damage, List<EstimatedValue> heal) {
    }
}

