/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellPool;
import net.spell_engine.internals.Validator;
import net.spell_engine.utils.WeaponCompatibility;
import net.spell_power.api.MagicSchool;

public class SpellRegistry {
    private static final Map<class_2960, SpellEntry> spells = new HashMap<class_2960, SpellEntry>();
    private static final Map<class_2960, SpellPool> pools = new HashMap<class_2960, SpellPool>();
    public static final Map<class_2960, SpellContainer> book_containers = new HashMap<class_2960, SpellContainer>();
    public static final Map<class_2960, SpellContainer> containers = new HashMap<class_2960, SpellContainer>();
    private static final Map<MagicSchool, Integer> spellCount = new HashMap<MagicSchool, Integer>();
    public static class_2540 encoded = PacketByteBufs.create();
    private static final Map<Integer, ReverseEntry> reverseSpells = new HashMap<Integer, ReverseEntry>();

    public static Map<class_2960, SpellEntry> all() {
        return spells;
    }

    public static void initialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            SpellRegistry.loadSpells(minecraftServer.method_34864());
            SpellRegistry.loadPools(minecraftServer.method_34864());
            SpellRegistry.loadContainers(minecraftServer.method_34864());
            WeaponCompatibility.initialize();
            SpellRegistry.encodeContent();
        });
    }

    public static void loadSpells(class_3300 resourceManager) {
        Gson gson = new Gson();
        HashMap<class_2960, SpellEntry> parsed = new HashMap<class_2960, SpellEntry>();
        int rawId = 1;
        String directory = "spells";
        for (Map.Entry entry : resourceManager.method_14488(directory, fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.method_14482()));
                Spell container = (Spell)gson.fromJson(reader, Spell.class);
                String id = identifier.toString().replace(directory + "/", "");
                id = id.substring(0, id.lastIndexOf(46));
                Validator.validate(container);
                parsed.put(new class_2960(id), new SpellEntry(container, rawId++));
            }
            catch (Exception e) {
                System.err.println("Failed to parse spell: " + identifier);
                e.printStackTrace();
            }
        }
        spells.clear();
        spells.putAll(parsed);
        SpellRegistry.spellsUpdated();
    }

    public static void loadPools(class_3300 resourceManager) {
        Gson gson = new Gson();
        HashMap<class_2960, SpellPool.DataFormat> parsed = new HashMap<class_2960, SpellPool.DataFormat>();
        String directory = "spell_pools";
        for (Map.Entry entry : resourceManager.method_14488(directory, fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.method_14482()));
                SpellPool.DataFormat pool = (SpellPool.DataFormat)gson.fromJson(reader, SpellPool.DataFormat.class);
                String id = identifier.toString().replace(directory + "/", "");
                id = id.substring(0, id.lastIndexOf(46));
                parsed.put(new class_2960(id), pool);
            }
            catch (Exception e2) {
                System.err.println("Failed to parse spell_pool: " + identifier);
                e2.printStackTrace();
            }
        }
        Map<class_2960, Spell> spellFlat = spells.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SpellEntry)e.getValue()).spell));
        pools.clear();
        for (Map.Entry entry : parsed.entrySet()) {
            pools.put((class_2960)entry.getKey(), SpellPool.fromData((SpellPool.DataFormat)entry.getValue(), spellFlat));
        }
    }

    public static void loadContainers(class_3300 resourceManager) {
        Gson gson = new Gson();
        HashMap<class_2960, SpellContainer> parsed = new HashMap<class_2960, SpellContainer>();
        String directory = "spell_assignments";
        for (Map.Entry entry : resourceManager.method_14488(directory, fileName -> fileName.method_12832().endsWith(".json")).entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.method_14482()));
                SpellContainer container = (SpellContainer)gson.fromJson(reader, SpellContainer.class);
                String id = identifier.toString().replace(directory + "/", "");
                id = id.substring(0, id.lastIndexOf(46));
                parsed.put(new class_2960(id), container);
            }
            catch (Exception e) {
                System.err.println("Failed to parse spell_assignment: " + identifier);
                e.printStackTrace();
            }
        }
        containers.clear();
        containers.putAll(parsed);
        containers.putAll(book_containers);
    }

    private static void spellsUpdated() {
        SpellRegistry.updateReverseMaps();
        spellCount.clear();
        for (MagicSchool school : MagicSchool.values()) {
            spellCount.put(school, 0);
        }
        for (Map.Entry entry : spells.entrySet()) {
            MagicSchool school = ((SpellEntry)entry.getValue()).spell.school;
            Integer current = spellCount.get(school);
            spellCount.put(school, current + 1);
        }
    }

    public static int numberOfSpells(MagicSchool school) {
        return spellCount.get(school);
    }

    public static SpellContainer containerForItem(class_2960 itemId) {
        if (itemId == null) {
            return null;
        }
        return containers.get(itemId);
    }

    public static Spell getSpell(class_2960 spellId) {
        SpellEntry entry = spells.get(spellId);
        if (entry != null) {
            return entry.spell;
        }
        return null;
    }

    public static SpellPool spellPool(class_2960 id) {
        SpellPool pool = pools.get(id);
        return pool != null ? pool : SpellPool.empty;
    }

    private static void encodeContent() {
        Gson gson = new Gson();
        class_2540 buffer = PacketByteBufs.create();
        SyncFormat sync = new SyncFormat();
        spells.forEach((key, value) -> sync.spells.put(key.toString(), (SpellEntry)value));
        pools.forEach((key, value) -> sync.pools.put(key.toString(), value.toSync()));
        containers.forEach((key, value) -> sync.containers.put(key.toString(), (SpellContainer)value));
        String json = gson.toJson((Object)sync);
        ArrayList<String> chunks = new ArrayList<String>();
        int chunkSize = 10000;
        for (int i = 0; i < json.length(); i += chunkSize) {
            chunks.add(json.substring(i, Math.min(json.length(), i + chunkSize)));
        }
        buffer.writeInt(chunks.size());
        for (String chunk : chunks) {
            buffer.method_10814(chunk);
        }
        System.out.println("Encoded SpellRegistry size (with package overhead): " + buffer.readableBytes() + " bytes (in " + chunks.size() + " string chunks with the size of " + chunkSize + ")");
        encoded = buffer;
    }

    public static void decodeContent(class_2540 buffer) {
        int chunkCount = buffer.readInt();
        String json = "";
        for (int i = 0; i < chunkCount; ++i) {
            json = json.concat(buffer.method_19772());
        }
        Gson gson = new Gson();
        SyncFormat sync = (SyncFormat)gson.fromJson(json, SyncFormat.class);
        spells.clear();
        sync.spells.forEach((key, value) -> spells.put(new class_2960(key), (SpellEntry)value));
        sync.pools.forEach((key, value) -> pools.put(new class_2960(key), SpellPool.fromSync(value)));
        sync.containers.forEach((key, value) -> containers.put(new class_2960(key), (SpellContainer)value));
        SpellRegistry.spellsUpdated();
    }

    private static void updateReverseMaps() {
        reverseSpells.clear();
        for (Map.Entry<class_2960, SpellEntry> entry : spells.entrySet()) {
            class_2960 id = entry.getKey();
            Spell spell = entry.getValue().spell;
            int rawId = entry.getValue().rawId;
            reverseSpells.put(rawId, new ReverseEntry(id, spell));
        }
    }

    public static int rawSpellId(class_2960 identifier) {
        return SpellRegistry.spells.get((Object)identifier).rawId;
    }

    public static Optional<class_2960> fromRawSpellId(int rawId) {
        ReverseEntry reverseEntry = reverseSpells.get(rawId);
        if (reverseEntry != null) {
            return Optional.of(reverseEntry.identifier);
        }
        return Optional.empty();
    }

    public static class SpellEntry {
        public Spell spell;
        public int rawId;

        public SpellEntry() {
        }

        public SpellEntry(Spell spell, int rawId) {
            this.spell = spell;
            this.rawId = rawId;
        }
    }

    public static class SyncFormat {
        public Map<String, SpellEntry> spells = new HashMap<String, SpellEntry>();
        public Map<String, SpellPool.SyncFormat> pools = new HashMap<String, SpellPool.SyncFormat>();
        public Map<String, SpellContainer> containers = new HashMap<String, SpellContainer>();
    }

    private record ReverseEntry(class_2960 identifier, Spell spell) {
    }
}

