/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin;

import com.google.gson.Gson;
import net.minecraft.class_1657;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.animation.AnimatablePlayer;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements SpellCasterEntity {
    private final SpellCooldownManager spellCooldownManager = new SpellCooldownManager(this.player());
    private static final class_2940<String> SPELL_ENGINE_SPELL_PROGRESS = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13326);
    private static final Gson syncGson = new Gson();
    private SpellCast.Process synchronizedSpellCastProcess = null;
    private String lastHandledSyncData = "";

    private class_1657 player() {
        return (class_1657)this;
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void initDataTracker_TAIL_SpellEngine_SyncEffects(CallbackInfo ci) {
        this.player().method_5841().method_12784(SPELL_ENGINE_SPELL_PROGRESS, (Object)"");
    }

    @Override
    public void setSpellCastProcess(@Nullable SpellCast.Process process) {
        this.synchronizedSpellCastProcess = process;
        String json = process != null ? process.fastSyncJSON() : "";
        this.player().method_5841().method_12778(SPELL_ENGINE_SPELL_PROGRESS, (Object)json);
    }

    @Override
    @Nullable
    public SpellCast.Process getSpellCastProcess() {
        return this.synchronizedSpellCastProcess;
    }

    @Override
    public Spell getCurrentSpell() {
        SpellCast.Process process = this.getSpellCastProcess();
        if (process != null) {
            return process.spell();
        }
        return null;
    }

    @Override
    public float getCurrentCastingSpeed() {
        SpellCast.Process process = this.getSpellCastProcess();
        if (process != null) {
            return process.speed();
        }
        return 1.0f;
    }

    @Override
    public SpellCooldownManager getCooldownManager() {
        return this.spellCooldownManager;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick_TAIL_SpellEngine(CallbackInfo ci) {
        int castTicks;
        class_1657 player = this.player();
        if (player.method_37908().field_9236) {
            ((AnimatablePlayer)this.player()).updateSpellCastAnimationsOnTick();
            String progressString = (String)player.method_5841().method_12789(SPELL_ENGINE_SPELL_PROGRESS);
            if (!progressString.equals(this.lastHandledSyncData)) {
                if (progressString.isEmpty()) {
                    this.synchronizedSpellCastProcess = null;
                } else {
                    SpellCast.Process.SyncFormat syncFormat = (SpellCast.Process.SyncFormat)syncGson.fromJson(progressString, SpellCast.Process.SyncFormat.class);
                    this.synchronizedSpellCastProcess = SpellCast.Process.fromSync(syncFormat, player.method_6047().method_7909(), player.method_37908().method_8510());
                }
                this.lastHandledSyncData = progressString;
            }
        } else if (this.synchronizedSpellCastProcess != null && (double)(castTicks = this.synchronizedSpellCastProcess.spellCastTicksSoFar(player.method_37908().method_8510())) >= (double)this.synchronizedSpellCastProcess.length() * 1.5) {
            SpellCastSyncHelper.clearCasting(player);
        }
        this.spellCooldownManager.update();
    }

    @Override
    public boolean isBeaming() {
        return this.getBeam() != null;
    }

    @Override
    @Nullable
    public Spell.Release.Target.Beam getBeam() {
        Spell spell = this.getCurrentSpell();
        if (spell != null && spell.release != null && spell.release.target.type == Spell.Release.Target.Type.BEAM) {
            return spell.release.target.beam;
        }
        return null;
    }
}

