/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client.render;

import net.minecraft.class_1059;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.beam.BeamEmitterEntity;
import net.spell_engine.client.render.BeamRenderer;
import net.spell_engine.internals.Beam;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.utils.TargetHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_922.class})
public class LivingEntityRendererMixin {
    private static final class_1921 spellObjectsLayer = CustomLayers.projectile(class_1059.field_5275, false);

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="TAIL")})
    private void render_TAIL_SpellEngine(class_1309 livingEntity, float f, float delta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, CallbackInfo ci) {
        boolean isRenderingClientPlayerInFirstPerson;
        float launchHeight = SpellHelper.launchHeight(livingEntity);
        class_243 offset = new class_243(0.0, (double)launchHeight, (double)SpellHelper.launchPointOffsetDefault);
        if (livingEntity instanceof SpellCasterEntity) {
            SpellCasterEntity caster = (SpellCasterEntity)livingEntity;
            Spell.Release.Target.Beam beamAppearance = caster.getBeam();
            if (beamAppearance != null) {
                class_243 from = livingEntity.method_19538().method_1031(0.0, (double)launchHeight, 0.0);
                class_243 lookVector = class_243.field_1353;
                if (livingEntity == class_310.method_1551().field_1724) {
                    lookVector = class_243.method_1030((float)livingEntity.method_36455(), (float)livingEntity.method_36454());
                } else {
                    lookVector = class_243.method_1030((float)livingEntity.field_6004, (float)livingEntity.field_5982);
                    lookVector = lookVector.method_35590(class_243.method_1030((float)livingEntity.method_36455(), (float)livingEntity.method_36454()), (double)delta);
                }
                lookVector = lookVector.method_1029();
                Beam.Position beamPosition = TargetHelper.castBeam(livingEntity, lookVector, 32.0f);
                lookVector = lookVector.method_1021((double)beamPosition.length());
                class_243 to = from.method_1019(lookVector);
                LivingEntityRendererMixin.renderBeam(matrixStack, vertexConsumerProvider, beamAppearance, from, to, offset, livingEntity.method_37908().method_8510(), delta);
                ((BeamEmitterEntity)livingEntity).setLastRenderedBeam(new Beam.Rendered(beamPosition, beamAppearance));
            } else {
                ((BeamEmitterEntity)livingEntity).setLastRenderedBeam(null);
            }
        }
        class_310 client = class_310.method_1551();
        boolean bl = isRenderingClientPlayerInFirstPerson = livingEntity == client.field_1724 && !client.field_1773.method_19418().method_19333();
        if (!isRenderingClientPlayerInFirstPerson) {
            for (Synchronized.Effect entry : Synchronized.effectsOf(livingEntity)) {
                class_1291 effect = entry.effect();
                int amplifier = entry.amplifier();
                CustomModelStatusEffect.Renderer renderer = CustomModelStatusEffect.rendererOf(effect);
                if (renderer == null) continue;
                renderer.renderEffect(amplifier, livingEntity, delta, matrixStack, vertexConsumerProvider, light);
            }
        }
    }

    private static void renderBeam(class_4587 matrixStack, class_4597 vertexConsumerProvider, Spell.Release.Target.Beam beam, class_243 from, class_243 to, class_243 offset, long time, float tickDelta) {
        float absoluteTime = (float)Math.floorMod(time, 40) + tickDelta;
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, offset.field_1351, 0.0);
        class_243 beamVector = to.method_1020(from);
        float length = (float)beamVector.method_1033();
        beamVector = beamVector.method_1029();
        float n = (float)Math.acos(beamVector.field_1351);
        float o = (float)Math.atan2(beamVector.field_1350, beamVector.field_1352);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees((1.5707964f - o) * 57.295776f));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(n * 57.295776f));
        matrixStack.method_22904(0.0, offset.field_1350, 0.0);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(absoluteTime * 2.25f - 45.0f));
        class_2960 texture = new class_2960(beam.texture_id);
        long color = beam.color_rgba;
        long red = color >> 24 & 0xFFL;
        long green = color >> 16 & 0xFFL;
        long blue = color >> 8 & 0xFFL;
        long alpha = color & 0xFFL;
        BeamRenderer.renderBeam(matrixStack, vertexConsumerProvider, texture, time, tickDelta, beam.flow, (int)red, (int)green, (int)blue, (int)alpha, 0.0f, length, beam.width);
        matrixStack.method_22909();
    }
}

