/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.particle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.network.Packets;

public class ParticleHelper {
    private static Random rng = new Random();

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches) {
        ParticleHelper.sendBatches(trackedEntity, batches, 1.0f, PlayerLookup.tracking((class_1297)trackedEntity));
    }

    public static void sendBatches(class_1297 trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<class_3222> trackers) {
        if (batches == null || batches.length == 0) {
            return;
        }
        int sourceEntityId = trackedEntity.method_5628();
        Packets.ParticleBatches.SourceType sourceType = Packets.ParticleBatches.SourceType.COORDINATE;
        ArrayList<Packets.ParticleBatches.Spawn> spawns = new ArrayList<Packets.ParticleBatches.Spawn>();
        for (ParticleBatch batch : batches) {
            class_243 sourceLocation = class_243.field_1353;
            switch (sourceType) {
                case ENTITY: {
                    break;
                }
                case COORDINATE: {
                    sourceLocation = ParticleHelper.origin(trackedEntity, batch.origin);
                }
            }
            spawns.add(new Packets.ParticleBatches.Spawn(sourceEntityId, sourceLocation, batch));
        }
        class_2540 packet = new Packets.ParticleBatches(sourceType, spawns).write(countMultiplier);
        if (trackedEntity instanceof class_3222) {
            class_3222 serverPlayer2 = (class_3222)trackedEntity;
            ParticleHelper.sendWrittenBatchesToPlayer(serverPlayer2, packet);
        }
        trackers.forEach(serverPlayer -> ParticleHelper.sendWrittenBatchesToPlayer(serverPlayer, packet));
    }

    private static void sendWrittenBatchesToPlayer(class_3222 serverPlayer, class_2540 packet) {
        try {
            if (ServerPlayNetworking.canSend((class_3222)serverPlayer, (class_2960)Packets.ParticleBatches.ID)) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)Packets.ParticleBatches.ID, (class_2540)packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void play(class_1937 world, class_1297 source, ParticleBatch[] batches) {
        if (batches == null) {
            return;
        }
        for (ParticleBatch batch : batches) {
            ParticleHelper.play(world, source, 0.0f, 0.0f, batch);
        }
    }

    public static void play(class_1937 world, class_1297 source, ParticleBatch batch) {
        ParticleHelper.play(world, source, 0.0f, 0.0f, batch);
    }

    public static void play(class_1937 world, class_1297 entity, float yaw, float pitch, ParticleBatch batch) {
        ParticleHelper.play(world, ParticleHelper.origin(entity, batch.origin), entity.method_17681(), yaw, pitch, batch);
    }

    public static void play(class_1937 world, class_243 origin, float width, float yaw, float pitch, ParticleBatch batch) {
        try {
            class_2960 id = new class_2960(batch.particle_id);
            class_2394 particle = (class_2394)class_7923.field_41180.method_10223(id);
            float count = batch.count;
            boolean dynamicallyOffset = ParticleHelper.requiresDynamicOffset(batch);
            class_243 defaultOrigin = origin.method_1019(ParticleHelper.offset(width, batch.extent, batch.shape, batch.rotation, yaw, pitch));
            if (batch.count < 1.0f) {
                count = rng.nextFloat() < batch.count ? 1.0f : 0.0f;
            }
            int i = 0;
            while ((float)i < count) {
                class_243 direction = ParticleHelper.direction(batch, yaw, pitch);
                class_243 particleSpecificOrigin = dynamicallyOffset ? origin.method_1019(ParticleHelper.offset(width, batch.extent, batch.shape, batch.rotation, yaw, pitch)) : defaultOrigin;
                world.method_8466(particle, true, particleSpecificOrigin.field_1352, particleSpecificOrigin.field_1351, particleSpecificOrigin.field_1350, direction.field_1352, direction.field_1351, direction.field_1350);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to play particle batch - " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static List<SpawnInstruction> convertToInstructions(class_1937 world, float pitch, float yaw, Packets.ParticleBatches packet) {
        ArrayList<SpawnInstruction> instructions = new ArrayList<SpawnInstruction>();
        Packets.ParticleBatches.SourceType sourceType = packet.sourceType();
        for (Packets.ParticleBatches.Spawn spawn : packet.spawns()) {
            ParticleBatch batch = spawn.batch();
            class_243 origin = class_243.field_1353;
            float width = 0.5f;
            switch (sourceType) {
                case ENTITY: {
                    class_1297 entity = world.method_8469(spawn.sourceEntityId());
                    origin = ParticleHelper.origin(entity, batch.origin);
                    break;
                }
                case COORDINATE: {
                    origin = spawn.sourceLocation();
                }
            }
            class_2960 id = new class_2960(batch.particle_id);
            class_2394 particle = (class_2394)class_7923.field_41180.method_10223(id);
            float count = batch.count;
            boolean dynamicallyOffset = ParticleHelper.requiresDynamicOffset(batch);
            class_243 defaultOrigin = origin.method_1019(ParticleHelper.offset(width, batch.extent, batch.shape, batch.rotation, yaw, pitch));
            if (batch.count < 1.0f) {
                count = rng.nextFloat() < batch.count ? 1.0f : 0.0f;
            }
            int i = 0;
            while ((float)i < count) {
                class_243 direction = ParticleHelper.direction(batch, yaw, pitch);
                class_243 particleSpecificOrigin = dynamicallyOffset ? origin.method_1019(ParticleHelper.offset(width, batch.extent, batch.shape, batch.rotation, yaw, pitch)) : defaultOrigin;
                instructions.add(new SpawnInstruction(particle, particleSpecificOrigin.field_1352, particleSpecificOrigin.field_1351, particleSpecificOrigin.field_1350, direction.field_1352, direction.field_1351, direction.field_1350));
                ++i;
            }
        }
        return instructions;
    }

    private static class_243 origin(class_1297 entity, ParticleBatch.Origin origin) {
        switch (origin) {
            case FEET: {
                return entity.method_19538().method_1031(0.0, (double)(entity.method_17682() * 0.1f), 0.0);
            }
            case CENTER: {
                return entity.method_19538().method_1031(0.0, (double)(entity.method_17682() * 0.5f), 0.0);
            }
            case LAUNCH_POINT: {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    return SpellHelper.launchPoint(livingEntity);
                }
                return entity.method_19538().method_1031(0.0, (double)(entity.method_17682() * 0.5f), 0.0);
            }
        }
        return entity.method_19538();
    }

    private static boolean requiresDynamicOffset(ParticleBatch origin) {
        switch (origin.shape) {
            case CIRCLE: 
            case CONE: 
            case SPHERE: {
                return false;
            }
            case PILLAR: 
            case PIPE: {
                return true;
            }
        }
        return false;
    }

    private static class_243 offset(float width, float extent, ParticleBatch.Shape shape, ParticleBatch.Rotation rotation, float yaw, float pitch) {
        class_243 offset = class_243.field_1353;
        switch (shape) {
            case CIRCLE: 
            case CONE: 
            case SPHERE: {
                return offset;
            }
            case PIPE: {
                float size = width + extent;
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new class_243((double)size, 0.0, 0.0).method_1024(angle);
                break;
            }
            case PILLAR: {
                float size = width * 0.5f + extent;
                float x = ParticleHelper.randomInRange(0.0f, size);
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new class_243((double)x, 0.0, 0.0).method_1024(angle);
            }
        }
        if (rotation != null) {
            switch (rotation) {
                case LOOK: {
                    offset = offset.method_1037((float)Math.toRadians(-1.0f * (pitch + 90.0f))).method_1024((float)Math.toRadians(-yaw));
                }
            }
        }
        return offset;
    }

    private static class_243 direction(ParticleBatch batch, float yaw, float pitch) {
        class_243 direction = class_243.field_1353;
        float normalizedYaw = yaw % 360.0f;
        float normalizedPitch = pitch % 360.0f;
        float rotateAroundX = 0.0f;
        float rotateAroundY = 0.0f;
        switch (batch.shape) {
            case CONE: {
                direction = new class_243(0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0);
                rotateAroundX += rng.nextFloat() * batch.angle - batch.angle * 0.5f;
                rotateAroundY += rng.nextFloat() * batch.angle - batch.angle * 0.5f;
                break;
            }
            case CIRCLE: {
                direction = new class_243(0.0, 0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed)).method_1024((float)Math.toRadians(rng.nextFloat() * 360.0f));
                break;
            }
            case PILLAR: 
            case PIPE: {
                direction = new class_243(0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0);
                break;
            }
            case SPHERE: {
                direction = new class_243((double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0, 0.0).method_31033((float)Math.toRadians(rng.nextFloat() * 360.0f)).method_1024((float)Math.toRadians(rng.nextFloat() * 360.0f));
            }
        }
        if (batch.rotation != null) {
            switch (batch.rotation) {
                case LOOK: {
                    rotateAroundX += normalizedPitch + 90.0f;
                    rotateAroundY += normalizedYaw;
                }
            }
            direction = direction.method_1037((float)Math.toRadians(rotateAroundX) * -1.0f).method_1024((float)Math.toRadians(rotateAroundY) * -1.0f);
        }
        return direction;
    }

    private static float randomInRange(float min, float max) {
        float range = max - min;
        return min + range * rng.nextFloat();
    }

    private static float randomSignedInRange(float min, float max) {
        float rand = rng.nextFloat();
        float range = max - min;
        float sign = rand > 0.5f ? 1.0f : -1.0f;
        float base = sign * min;
        float varied = sign * range * rand;
        return base + varied;
    }

    public record SpawnInstruction(class_2394 particle, double positionX, double positionY, double positionZ, double velocityX, double velocityY, double velocityZ) {
        public void perform(class_1937 world) {
            try {
                world.method_8466(this.particle, true, this.positionX, this.positionY, this.positionZ, this.velocityX, this.velocityY, this.velocityZ);
            }
            catch (Exception e) {
                System.err.println("Failed to perform particle SpawnInstruction");
            }
        }
    }
}

