/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.HashMap;

public class RecordsWithGson {

    public static class RecordTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            final Class clazz = type.getRawType();
            if (!clazz.isRecord()) {
                return null;
            }
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    delegate.write(out, value);
                }

                public T read(JsonReader reader) throws IOException {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    RecordComponent[] recordComponents = clazz.getRecordComponents();
                    HashMap<String, TypeToken> typeMap = new HashMap<String, TypeToken>();
                    for (int i = 0; i < recordComponents.length; ++i) {
                        typeMap.put(recordComponents[i].getName(), TypeToken.get((Type)recordComponents[i].getGenericType()));
                    }
                    HashMap<String, Object> argsMap = new HashMap<String, Object>();
                    reader.beginObject();
                    while (reader.hasNext()) {
                        String name = reader.nextName();
                        argsMap.put(name, gson.getAdapter((TypeToken)typeMap.get(name)).read(reader));
                    }
                    reader.endObject();
                    Class[] argTypes = new Class[recordComponents.length];
                    Object[] args = new Object[recordComponents.length];
                    for (int i = 0; i < recordComponents.length; ++i) {
                        argTypes[i] = recordComponents[i].getType();
                        args[i] = argsMap.get(recordComponents[i].getName());
                    }
                    try {
                        Constructor constructor = clazz.getDeclaredConstructor(argTypes);
                        constructor.setAccessible(true);
                        return constructor.newInstance(args);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }
}

